/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi.handler;

import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseHandlerResolver
implements HandlerResolver {
    private static Log log = LogFactory.getLog(BaseHandlerResolver.class);
    protected static final Map<String, String> protocolBindingsMap = new HashMap<String, String>(5);
    protected HandlerChainsType handlerChainsType;

    protected BaseHandlerResolver() {
    }

    protected BaseHandlerResolver(String file) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String className = this.getClass().getName();
        InputStream is = DescriptionUtils.openHandlerConfigStream((String)file, (String)className, (ClassLoader)classLoader);
        if (is == null) {
            log.warn((Object)("Unable to load handlers from file: " + file));
        } else {
            this.handlerChainsType = DescriptionUtils.loadHandlerChains((InputStream)is, (ClassLoader)classLoader);
        }
    }

    protected static boolean chainResolvesToPort(HandlerChainType hct, PortInfo portinfo) {
        List protocolBindings = hct.getProtocolBindings();
        if (protocolBindings != null) {
            boolean match = true;
            Iterator it = protocolBindings.iterator();
            while (it.hasNext()) {
                match = false;
                String protocolBinding = (String)it.next();
                protocolBinding = protocolBinding.startsWith("##") ? protocolBindingsMap.get(protocolBinding) : protocolBinding;
                if (protocolBinding == null || !protocolBinding.equals(portinfo.getBindingID())) continue;
                match = true;
                break;
            }
            if (!match) {
                return match;
            }
        }
        if (!BaseHandlerResolver.doesPatternMatch(portinfo.getPortName(), hct.getPortNamePattern())) {
            return false;
        }
        return BaseHandlerResolver.doesPatternMatch(portinfo.getServiceName(), hct.getServiceNamePattern());
    }

    protected static Class loadClass(String clazz) throws ClassNotFoundException {
        return BaseHandlerResolver.forName(clazz, true, BaseHandlerResolver.getContextClassLoader());
    }

    private static boolean doesPatternMatch(QName portInfoQName, QName pattern) {
        if (pattern == null) {
            return true;
        }
        String portInfoString = portInfoQName.toString();
        String patternString = pattern.toString();
        if (patternString.equals("*")) {
            return true;
        }
        if (patternString.contains("*")) {
            patternString = patternString.substring(0, patternString.length() - 1);
            return portInfoString.startsWith(patternString);
        }
        return portInfoString.equals(patternString);
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("HandlerResolverImpl attempting to load Class: " + className));
                        }
                        return Class.forName(className, initialize, classLoader);
                    }
                    catch (Throwable e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("HandlerResolverImpl cannot load the following class Throwable Exception Occured: " + className));
                        }
                        throw new ClassNotFoundException("HandlerResolverImpl cannot load the following class Throwable Exception Occured:" + className);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    static {
        protocolBindingsMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        protocolBindingsMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        protocolBindingsMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        protocolBindingsMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        protocolBindingsMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
    }
}

