/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleDeployer
implements Deployer {
    private static final Log log = LogFactory.getLog((Class)ModuleDeployer.class);
    private ConfigurationContext configCtx;
    private AxisConfiguration axisConfig;

    public ModuleDeployer() {
    }

    public ModuleDeployer(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ArchiveReader archiveReader = new ArchiveReader();
        String moduleStatus = "";
        StringWriter errorWriter = new StringWriter();
        boolean isDirectory = deploymentFileData.getFile().isDirectory();
        try {
            deploymentFileData.setClassLoader(isDirectory, this.axisConfig.getModuleClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"));
            AxisModule metaData = new AxisModule();
            metaData.setModuleClassLoader(deploymentFileData.getClassLoader());
            metaData.setParent(this.axisConfig);
            archiveReader.readModuleArchive(deploymentFileData, metaData, isDirectory, this.axisConfig);
            metaData.setFileName(deploymentFileData.getFile().toURL());
            DeploymentEngine.addNewModule(metaData, this.axisConfig);
            log.info((Object)Messages.getMessage("deployeingmodule", metaData.getName()));
        }
        catch (DeploymentException e) {
            log.error((Object)Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), (Throwable)e);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        catch (AxisFault axisFault) {
            log.error((Object)Messages.getMessage("invalidmodule", deploymentFileData.getName(), axisFault.getMessage()), (Throwable)axisFault);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            axisFault.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        catch (MalformedURLException e) {
            log.error((Object)Messages.getMessage("invalidmodule", deploymentFileData.getName(), e.getMessage()), (Throwable)e);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        catch (Throwable t) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.error((Object)Messages.getMessage("invalidmodule", deploymentFileData.getName(), t.getMessage()), t);
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            t.printStackTrace(error_ptintWriter);
            moduleStatus = "Error:\n" + errorWriter.toString();
        }
        finally {
            if (moduleStatus.startsWith("Error:")) {
                this.axisConfig.getFaultyModules().put(DeploymentEngine.getAxisServiceName(deploymentFileData.getName()), moduleStatus);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) {
    }
}

