/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingBasedDispatcher
extends AbstractDispatcher
implements AddressingConstants {
    public static final String NAME = "AddressingBasedDispatcher";
    private static final Log log = LogFactory.getLog((Class)AddressingBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        String action;
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " " + Messages.getMessage("checkingoperation", messageContext.getWSAAction())));
        }
        if ((action = messageContext.getWSAAction()) != null) {
            return service.getOperationByAction(action);
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        Map endpoints;
        AxisConfiguration registry;
        ConfigurationContext configurationContext;
        String[] values;
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR == null || toEPR.hasAnonymousAddress()) {
            return null;
        }
        AxisService service = null;
        String address = toEPR.getAddress();
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " " + Messages.getMessage("checkingserviceforepr", address)));
        }
        if ((values = Utils.parseRequestURLForServiceAndOperation(address, (configurationContext = messageContext.getConfigurationContext()).getServiceContextPath())) == null) {
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " " + Messages.getMessage("checkingserviceforepr", values[0])));
        }
        if (values[0] != null && (service = (registry = configurationContext.getAxisConfiguration()).getService(values[0])) != null && (endpoints = service.getEndpoints()) != null) {
            if (endpoints.size() == 1) {
                messageContext.setProperty("endpoint", endpoints.get(service.getEndpointName()));
            } else {
                String endpointName = values[0].substring(values[0].indexOf(".") + 1);
                messageContext.setProperty("endpoint", endpoints.get(endpointName));
            }
        }
        return service;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        if (msgctx.getRelatesTo() != null) {
            OperationContext operationContext;
            String relatesTo = msgctx.getRelatesTo().getValue();
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(msgctx.getLogIDString() + " " + Messages.getMessage("checkingrelatesto", relatesTo)));
            }
            if (relatesTo != null && !"".equals(relatesTo) && (operationContext = msgctx.getConfigurationContext().getOperationContext(relatesTo)) != null) {
                if (operationContext.isComplete()) {
                    throw new AxisFault(Messages.getMessage("duplicaterelatesto", relatesTo));
                }
                msgctx.setAxisOperation(operationContext.getAxisOperation());
                msgctx.setOperationContext(operationContext);
                msgctx.setServiceContext((ServiceContext)operationContext.getParent());
                msgctx.setAxisService(((ServiceContext)operationContext.getParent()).getAxisService());
                msgctx.getAxisOperation().registerMessageContext(msgctx, operationContext);
                msgctx.setServiceGroupContextId(((ServiceGroupContext)msgctx.getServiceContext().getParent()).getId());
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)(msgctx.getLogIDString() + " Dispatched successfully on the RelatesTo. operation=" + operationContext.getAxisOperation()));
                }
                return Handler.InvocationResponse.CONTINUE;
            }
        }
        return super.invoke(msgctx);
    }
}

