/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpService;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.IOProcessorCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;

public class HttpServiceProcessor
implements IOProcessor {
    private static final Log LOG = LogFactory.getLog((Class)HttpServiceProcessor.class);
    private volatile boolean terminated;
    private final AxisHttpService httpservice;
    private final AxisHttpConnection conn;
    private final IOProcessorCallback callback;

    public HttpServiceProcessor(AxisHttpService httpservice, AxisHttpConnection conn, IOProcessorCallback callback) {
        this.httpservice = httpservice;
        this.conn = conn;
        this.callback = callback;
        this.terminated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.debug((Object)"New connection thread");
        HttpExecutionContext context = new HttpExecutionContext(null);
        try {
            while (!Thread.interrupted() && !this.isDestroyed() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, (HttpContext)context);
            }
        }
        catch (ConnectionClosedException ex) {
            LOG.debug((Object)"Client closed connection");
        }
        catch (IOException ex) {
            if (ex instanceof SocketTimeoutException) {
                LOG.debug((Object)ex.getMessage());
            } else if (ex instanceof SocketException) {
                LOG.debug((Object)ex.getMessage());
            } else {
                LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (HttpException ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("HTTP protocol error: " + ex.getMessage()));
            }
        }
        finally {
            this.destroy();
            if (this.callback != null) {
                this.callback.completed(this);
            }
        }
    }

    public void close() throws IOException {
        this.conn.close();
    }

    public void destroy() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        try {
            this.conn.shutdown();
        }
        catch (IOException ex) {
            LOG.debug((Object)"I/O error shutting down connection");
        }
    }

    public boolean isDestroyed() {
        return this.terminated;
    }
}

