/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.URL;

public class TCPTransportSender
extends AbstractHandler
implements TransportSender {
    protected Writer out;
    private Socket socket;

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        EndpointReference epr = null;
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            epr = msgContext.getTo();
        }
        if (epr != null) {
            if (!epr.hasNoneAddress()) {
                OutputStream out = this.openTheConnection(epr, msgContext);
                TransportUtils.writeMessage(msgContext, out);
                try {
                    this.socket.shutdownOutput();
                    msgContext.setProperty("TRANSPORT_IN", this.socket.getInputStream());
                }
                catch (IOException e) {
                    throw new AxisFault(e);
                }
            }
        } else {
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            if (out != null) {
                TransportUtils.writeMessage(msgContext, out);
            } else {
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
            }
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("CONTENT_WRITTEN", "true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected OutputStream openTheConnection(EndpointReference toURL, MessageContext msgContext) throws AxisFault {
        if (toURL != null) {
            try {
                URL url = new URL(toURL.getAddress());
                InetSocketAddress add = new InetSocketAddress(url.getHost(), url.getPort() == -1 ? 80 : url.getPort());
                this.socket = new Socket();
                this.socket.connect(add);
                return this.socket.getOutputStream();
            }
            catch (MalformedURLException e) {
                throw new AxisFault(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage(), e);
            }
        }
        throw new AxisFault(Messages.getMessage("canNotBeNull", "End point reference"));
    }
}

