/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ServiceModeAnnot;
import org.apache.axis2.jaxws.description.builder.SoapBindingAnnot;
import org.apache.axis2.jaxws.description.builder.TMAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.TMFAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.WebFaultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceContextAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.apache.axis2.jaxws.description.builder.WsdlGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionBuilderComposite
implements TMAnnotationComposite,
TMFAnnotationComposite {
    private ModuleClassType moduleClassType = null;
    private Definition wsdlDefinition = null;
    private URL wsdlURL = null;
    private WebServiceAnnot webServiceAnnot;
    private WebServiceProviderAnnot webServiceProviderAnnot;
    private ServiceModeAnnot serviceModeAnnot;
    private WebServiceClientAnnot webServiceClientAnnot;
    private WebFaultAnnot webFaultAnnot;
    private HandlerChainAnnot handlerChainAnnot;
    private SoapBindingAnnot soapBindingAnnot;
    private List<WebServiceRefAnnot> webServiceRefAnnotList;
    private BindingTypeAnnot bindingTypeAnnot;
    private WebServiceContextAnnot webServiceContextAnnot;
    private String className;
    private String[] classModifiers;
    private String extendsClass;
    private List<String> interfacesList;
    private boolean isInterface = false;
    private List<MethodDescriptionComposite> methodDescriptions = new ArrayList<MethodDescriptionComposite>();
    private List<FieldDescriptionComposite> fieldDescriptions = new ArrayList<FieldDescriptionComposite>();
    private WsdlGenerator wsdlGenerator;
    private ClassLoader classLoader;

    public DescriptionBuilderComposite() {
        this.webServiceRefAnnotList = new ArrayList<WebServiceRefAnnot>();
        this.interfacesList = new ArrayList<String>();
    }

    public WebServiceAnnot getWebServiceAnnot() {
        return this.webServiceAnnot;
    }

    public String[] getClassModifiers() {
        return this.classModifiers;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.extendsClass;
    }

    public List<String> getInterfacesList() {
        return this.interfacesList;
    }

    public HandlerChainAnnot getHandlerChainAnnot() {
        return this.handlerChainAnnot;
    }

    public ServiceModeAnnot getServiceModeAnnot() {
        return this.serviceModeAnnot;
    }

    public SoapBindingAnnot getSoapBindingAnnot() {
        return this.soapBindingAnnot;
    }

    public WebFaultAnnot getWebFaultAnnot() {
        return this.webFaultAnnot;
    }

    public WebServiceClientAnnot getWebServiceClientAnnot() {
        return this.webServiceClientAnnot;
    }

    public WebServiceProviderAnnot getWebServiceProviderAnnot() {
        return this.webServiceProviderAnnot;
    }

    public List<WebServiceRefAnnot> getAllWebServiceRefAnnots() {
        return this.webServiceRefAnnotList;
    }

    public WebServiceRefAnnot getWebServiceRefAnnot(String name) {
        WebServiceRefAnnot wsra2 = null;
        for (WebServiceRefAnnot wsra2 : this.webServiceRefAnnotList) {
            if (!wsra2.name().equals(name)) continue;
            return wsra2;
        }
        return wsra2;
    }

    public BindingTypeAnnot getBindingTypeAnnot() {
        return this.bindingTypeAnnot;
    }

    public WebServiceContextAnnot getWebServiceContextAnnot() {
        return this.webServiceContextAnnot;
    }

    public Definition getWsdlDefinition() {
        return this.wsdlDefinition;
    }

    public URL getWsdlURL() {
        return this.wsdlURL;
    }

    public List<MethodDescriptionComposite> getMethodDescriptionComposite(String methodName) {
        ArrayList<MethodDescriptionComposite> matchingMethods = new ArrayList<MethodDescriptionComposite>();
        for (MethodDescriptionComposite composite : this.methodDescriptions) {
            if (composite.getMethodName() == null || !composite.getMethodName().equals(methodName)) continue;
            matchingMethods.add(composite);
        }
        return matchingMethods;
    }

    public MethodDescriptionComposite getMethodDescriptionComposite(String methodName, int occurence) {
        MethodDescriptionComposite returnMDC = null;
        List<MethodDescriptionComposite> matchingMethods = this.getMethodDescriptionComposite(methodName);
        if (matchingMethods != null && !matchingMethods.isEmpty() && occurence > 0 && occurence <= matchingMethods.size()) {
            returnMDC = matchingMethods.get(--occurence);
        }
        return returnMDC;
    }

    public List<MethodDescriptionComposite> getMethodDescriptionsList() {
        return this.methodDescriptions;
    }

    public FieldDescriptionComposite getFieldDescriptionComposite(String fieldName) {
        FieldDescriptionComposite composite2 = null;
        for (FieldDescriptionComposite composite2 : this.fieldDescriptions) {
            if (!composite2.getFieldName().equals(fieldName)) continue;
            return composite2;
        }
        return composite2;
    }

    public WsdlGenerator getCustomWsdlGenerator() {
        return this.wsdlGenerator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setWebServiceAnnot(WebServiceAnnot webServiceAnnot) {
        this.webServiceAnnot = webServiceAnnot;
    }

    public void setClassModifiers(String[] classModifiers) {
        this.classModifiers = classModifiers;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSuperClassName(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public void setInterfacesList(List<String> interfacesList) {
        this.interfacesList = interfacesList;
    }

    @Override
    public void setHandlerChainAnnot(HandlerChainAnnot handlerChainAnnot) {
        this.handlerChainAnnot = handlerChainAnnot;
    }

    public void setServiceModeAnnot(ServiceModeAnnot serviceModeAnnot) {
        this.serviceModeAnnot = serviceModeAnnot;
    }

    @Override
    public void setSoapBindingAnnot(SoapBindingAnnot soapBindingAnnot) {
        this.soapBindingAnnot = soapBindingAnnot;
    }

    public void setWebFaultAnnot(WebFaultAnnot webFaultAnnot) {
        this.webFaultAnnot = webFaultAnnot;
    }

    public void setWebServiceClientAnnot(WebServiceClientAnnot webServiceClientAnnot) {
        this.webServiceClientAnnot = webServiceClientAnnot;
    }

    public void setWebServiceProviderAnnot(WebServiceProviderAnnot webServiceProviderAnnot) {
        this.webServiceProviderAnnot = webServiceProviderAnnot;
    }

    public void addWebServiceRefAnnot(WebServiceRefAnnot webServiceRefAnnot) {
        this.webServiceRefAnnotList.add(webServiceRefAnnot);
    }

    @Override
    public void setWebServiceRefAnnot(WebServiceRefAnnot webServiceRefAnnot) {
        this.addWebServiceRefAnnot(webServiceRefAnnot);
    }

    public void setWsdlDefinition(Definition wsdlDefinition) {
        this.wsdlDefinition = wsdlDefinition;
    }

    public void setwsdlURL(URL wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public void setBindingTypeAnnot(BindingTypeAnnot bindingTypeAnnot) {
        this.bindingTypeAnnot = bindingTypeAnnot;
    }

    public void setWebServiceContextAnnot(WebServiceContextAnnot webServiceContextAnnot) {
        this.webServiceContextAnnot = webServiceContextAnnot;
    }

    public void setIsInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public void addMethodDescriptionComposite(MethodDescriptionComposite methodDescription) {
        this.methodDescriptions.add(methodDescription);
    }

    public void addFieldDescriptionComposite(FieldDescriptionComposite fieldDescription) {
        this.fieldDescriptions.add(fieldDescription);
    }

    public ModuleClassType getClassType() {
        if (this.moduleClassType == null) {
            // empty if block
        }
        return this.moduleClassType;
    }

    public void setCustomWsdlGenerator(WsdlGenerator wsdlGenerator) {
        this.wsdlGenerator = wsdlGenerator;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String newLine = "\n";
        String sameLine = "; ";
        sb.append(super.toString());
        sb.append("\n");
        sb.append("ClassName: " + this.className);
        sb.append("; ");
        sb.append("SuperClass:" + this.extendsClass);
        sb.append("\n");
        sb.append("Class modifiers: ");
        if (this.classModifiers != null) {
            for (int i = 0; i < this.classModifiers.length; ++i) {
                sb.append(this.classModifiers[i]);
                sb.append("; ");
            }
        }
        sb.append("\n");
        sb.append("Interfaces: ");
        for (String inter : this.interfacesList) {
            sb.append(inter);
            sb.append("; ");
        }
        if (this.webServiceAnnot != null) {
            sb.append("\n");
            sb.append("WebService: ");
            sb.append(this.webServiceAnnot.toString());
        }
        if (this.webServiceProviderAnnot != null) {
            sb.append("\n");
            sb.append("WebServiceProvider: ");
            sb.append(this.webServiceProviderAnnot.toString());
        }
        if (this.bindingTypeAnnot != null) {
            sb.append("\n");
            sb.append("BindingType: ");
            sb.append(this.bindingTypeAnnot.toString());
        }
        if (this.webServiceClientAnnot != null) {
            sb.append("\n");
            sb.append("WebServiceClient: ");
            sb.append(this.webServiceClientAnnot.toString());
        }
        if (this.webFaultAnnot != null) {
            sb.append("\n");
            sb.append("WebFault: ");
            sb.append(this.webFaultAnnot.toString());
        }
        if (this.serviceModeAnnot != null) {
            sb.append("\n");
            sb.append("ServiceMode: ");
            sb.append(this.serviceModeAnnot.toString());
        }
        if (this.soapBindingAnnot != null) {
            sb.append("\n");
            sb.append("SOAPBinding: ");
            sb.append(this.soapBindingAnnot.toString());
        }
        if (this.handlerChainAnnot != null) {
            sb.append("\n");
            sb.append("HandlerChain: ");
            sb.append(this.handlerChainAnnot.toString());
        }
        if (this.webServiceRefAnnotList.size() > 0) {
            sb.append("\n");
            sb.append("Number of WebServiceRef:  " + this.webServiceRefAnnotList.size());
            for (WebServiceRefAnnot wsr : this.webServiceRefAnnotList) {
                sb.append(wsr.toString());
                sb.append("; ");
            }
        }
        sb.append("\n");
        sb.append("Number of Method Descriptions: " + this.methodDescriptions.size());
        Iterator<MethodDescriptionComposite> mdcIter = this.methodDescriptions.iterator();
        while (mdcIter.hasNext()) {
            sb.append("\n");
            MethodDescriptionComposite mdc = mdcIter.next();
            sb.append(mdc.toString());
        }
        sb.append("\n");
        sb.append("Number of Field Descriptions: " + this.fieldDescriptions.size());
        Iterator<FieldDescriptionComposite> fdcIter = this.fieldDescriptions.iterator();
        while (fdcIter.hasNext()) {
            sb.append("\n");
            FieldDescriptionComposite fdc = fdcIter.next();
            sb.append(fdc.toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModuleClassType {
        SERVICEIMPL,
        SEI,
        SERVICE,
        SUPER,
        PROVIDER,
        FAULT;

    }
}

