/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ServiceModeAnnot;
import org.apache.axis2.jaxws.description.builder.WebFaultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;
import org.apache.axis2.jaxws.description.builder.converter.JavaFieldsToFDCConverter;
import org.apache.axis2.jaxws.description.builder.converter.JavaMethodsToMDCConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassToDBCConverter {
    private Class serviceClass;
    private String seiClassName;
    private List<Class> classes;

    public JavaClassToDBCConverter(Class serviceClass) {
        this.serviceClass = serviceClass;
        this.classes = new ArrayList<Class>();
        this.establishClassHierarchy(serviceClass);
        this.establishInterfaceHierarchy(serviceClass.getInterfaces());
        this.establishExceptionClasses(serviceClass);
    }

    public HashMap<String, DescriptionBuilderComposite> produceDBC() {
        HashMap<String, DescriptionBuilderComposite> dbcMap = new HashMap<String, DescriptionBuilderComposite>();
        for (int i = 0; i < this.classes.size(); ++i) {
            this.serviceClass = this.classes.get(i);
            DescriptionBuilderComposite composite = new DescriptionBuilderComposite();
            this.introspectClass(composite);
            dbcMap.put(composite.getClassName(), composite);
            if (this.seiClassName == null || this.seiClassName.equals("")) continue;
            DescriptionBuilderComposite seiComposite = new DescriptionBuilderComposite();
            try {
                this.serviceClass = Thread.currentThread().getContextClassLoader().loadClass(this.seiClassName);
                if (this.serviceClass == null) continue;
                this.introspectClass(seiComposite);
                dbcMap.put(seiComposite.getClassName(), seiComposite);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.out.println("Class not found exception caught for class: " + this.seiClassName);
                e.printStackTrace();
            }
        }
        return dbcMap;
    }

    private void introspectClass(DescriptionBuilderComposite composite) {
        composite.setClassLoader(this.serviceClass.getClassLoader());
        composite.setIsInterface(this.serviceClass.isInterface());
        composite.setSuperClassName(this.serviceClass.getSuperclass() != null ? this.serviceClass.getSuperclass().getName() : null);
        composite.setClassName(this.serviceClass.getName());
        this.setInterfaces(composite);
        this.setTypeTargettedAnnotations(composite);
        if (this.serviceClass.getFields().length > 0) {
            JavaFieldsToFDCConverter fieldConverter = new JavaFieldsToFDCConverter(this.serviceClass.getFields());
            List<FieldDescriptionComposite> fdcList = fieldConverter.convertFields();
            ConverterUtils.attachFieldDescriptionComposites(composite, fdcList);
        }
        if (this.serviceClass.getMethods().length > 0) {
            JavaMethodsToMDCConverter methodConverter = new JavaMethodsToMDCConverter(this.serviceClass.getDeclaredMethods(), this.serviceClass.getDeclaredConstructors(), this.serviceClass.getName());
            List<MethodDescriptionComposite> mdcList = methodConverter.convertMethods();
            ConverterUtils.attachMethodDescriptionComposites(composite, mdcList);
        }
    }

    private void setInterfaces(DescriptionBuilderComposite composite) {
        Type[] interfaces = this.serviceClass.getGenericInterfaces();
        ArrayList<String> interfaceList = interfaces.length > 0 ? new ArrayList<String>() : null;
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceList.add(this.getNameFromType(interfaces[i]));
        }
        if (interfaceList != null) {
            composite.setInterfacesList(interfaceList);
        }
    }

    private String getNameFromType(Type type) {
        String returnName = null;
        if (type instanceof Class) {
            returnName = ((Class)type).getName();
        } else if (type instanceof ParameterizedType) {
            returnName = ((ParameterizedType)type).toString();
        }
        return returnName;
    }

    private void setTypeTargettedAnnotations(DescriptionBuilderComposite composite) {
        this.attachBindingTypeAnnotation(composite);
        this.attachHandlerChainAnnotation(composite);
        this.attachServiceModeAnnotation(composite);
        this.attachSoapBindingAnnotation(composite);
        this.attachWebFaultAnnotation(composite);
        this.attachWebServiceAnnotation(composite);
        this.attachWebServiceClientAnnotation(composite);
        this.attachWebServiceProviderAnnotation(composite);
        this.attachWebServiceRefsAnnotation(composite);
        this.attachWebServiceRefAnnotation(composite);
    }

    private void attachWebServiceAnnotation(DescriptionBuilderComposite composite) {
        WebService webService = (WebService)ConverterUtils.getAnnotation(WebService.class, this.serviceClass);
        if (webService != null) {
            WebServiceAnnot wsAnnot = WebServiceAnnot.createWebServiceAnnotImpl();
            wsAnnot.setEndpointInterface(webService.endpointInterface());
            this.seiClassName = webService.endpointInterface();
            wsAnnot.setName(webService.name());
            wsAnnot.setPortName(webService.portName());
            wsAnnot.setServiceName(webService.serviceName());
            wsAnnot.setTargetNamespace(webService.targetNamespace());
            wsAnnot.setWsdlLocation(webService.wsdlLocation());
            composite.setWebServiceAnnot(wsAnnot);
        }
    }

    private void attachWebServiceClientAnnotation(DescriptionBuilderComposite composite) {
        WebServiceClient webServiceClient = (WebServiceClient)ConverterUtils.getAnnotation(WebServiceClient.class, this.serviceClass);
        if (webServiceClient != null) {
            // empty if block
        }
    }

    private void attachWebServiceProviderAnnotation(DescriptionBuilderComposite composite) {
        WebServiceProvider webServiceProvider = (WebServiceProvider)ConverterUtils.getAnnotation(WebServiceProvider.class, this.serviceClass);
        if (webServiceProvider != null) {
            WebServiceProviderAnnot wspAnnot = WebServiceProviderAnnot.createWebServiceAnnotImpl();
            wspAnnot.setPortName(webServiceProvider.portName());
            wspAnnot.setServiceName(webServiceProvider.serviceName());
            wspAnnot.setTargetNamespace(webServiceProvider.targetNamespace());
            wspAnnot.setWsdlLocation(webServiceProvider.wsdlLocation());
            composite.setWebServiceProviderAnnot(wspAnnot);
        }
    }

    private void attachBindingTypeAnnotation(DescriptionBuilderComposite composite) {
        BindingType bindingType = (BindingType)ConverterUtils.getAnnotation(BindingType.class, this.serviceClass);
        if (bindingType != null) {
            BindingTypeAnnot btAnnot = BindingTypeAnnot.createBindingTypeAnnotImpl();
            btAnnot.setValue(bindingType.value());
            composite.setBindingTypeAnnot(btAnnot);
        }
    }

    private void attachHandlerChainAnnotation(DescriptionBuilderComposite composite) {
        ConverterUtils.attachHandlerChainAnnotation(composite, this.serviceClass);
    }

    private void attachServiceModeAnnotation(DescriptionBuilderComposite composite) {
        ServiceMode serviceMode = (ServiceMode)ConverterUtils.getAnnotation(ServiceMode.class, this.serviceClass);
        if (serviceMode != null) {
            ServiceModeAnnot smAnnot = ServiceModeAnnot.createWebServiceAnnotImpl();
            smAnnot.setValue(serviceMode.value());
            composite.setServiceModeAnnot(smAnnot);
        }
    }

    private void attachSoapBindingAnnotation(DescriptionBuilderComposite composite) {
        ConverterUtils.attachSoapBindingAnnotation(composite, this.serviceClass);
    }

    private void attachWebFaultAnnotation(DescriptionBuilderComposite composite) {
        WebFault webFault = (WebFault)ConverterUtils.getAnnotation(WebFault.class, this.serviceClass);
        if (webFault != null) {
            WebFaultAnnot webFaultAnnot = WebFaultAnnot.createWebFaultAnnotImpl();
            webFaultAnnot.setFaultBean(webFault.faultBean());
            webFaultAnnot.setName(webFault.name());
            webFaultAnnot.setTargetNamespace(webFault.targetNamespace());
            composite.setWebFaultAnnot(webFaultAnnot);
        }
    }

    private void attachWebServiceRefsAnnotation(DescriptionBuilderComposite composite) {
        WebServiceRefs webServiceRefs = (WebServiceRefs)ConverterUtils.getAnnotation(WebServiceRefs.class, this.serviceClass);
        if (webServiceRefs != null) {
            WebServiceRef[] refs;
            for (WebServiceRef ref : refs = webServiceRefs.value()) {
                WebServiceRefAnnot wsrAnnot = ConverterUtils.createWebServiceRefAnnot(ref);
                composite.setWebServiceRefAnnot(wsrAnnot);
            }
        }
    }

    private void attachWebServiceRefAnnotation(DescriptionBuilderComposite composite) {
        ConverterUtils.attachWebServiceRefAnnotation(composite, this.serviceClass);
    }

    private void establishClassHierarchy(Class rootClass) {
        this.classes.add(rootClass);
        if (rootClass.getSuperclass() != null && !rootClass.getSuperclass().getName().equals("java.lang.Object")) {
            this.classes.add(rootClass.getSuperclass());
            this.establishInterfaceHierarchy(rootClass.getSuperclass().getInterfaces());
            this.establishClassHierarchy(rootClass.getSuperclass());
        }
    }

    private void establishInterfaceHierarchy(Class[] interfaces) {
        if (interfaces.length > 0) {
            for (Class inter : interfaces) {
                this.classes.add(inter);
                this.establishInterfaceHierarchy(inter.getInterfaces());
            }
        }
    }

    private void establishExceptionClasses(Class rootClass) {
        Method[] methods;
        for (Method method : methods = rootClass.getMethods()) {
            Class<?>[] exceptionClasses = method.getExceptionTypes();
            if (exceptionClasses.length <= 0) continue;
            for (Class<?> checkedException : exceptionClasses) {
                this.classes.add(checkedException);
            }
        }
    }
}

