/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebParamAnnot;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaParamToPDCConverter {
    private Type[] paramTypes;
    private Annotation[][] paramAnnotations;

    public JavaParamToPDCConverter(Type[] paramTypes, Annotation[][] paramAnnotations) {
        this.paramTypes = paramTypes;
        this.paramAnnotations = paramAnnotations;
    }

    public List<ParameterDescriptionComposite> convertParams() {
        ArrayList<ParameterDescriptionComposite> pdcList = new ArrayList<ParameterDescriptionComposite>();
        for (int i = 0; i < this.paramTypes.length; ++i) {
            String fullType;
            ParameterDescriptionComposite pdc = new ParameterDescriptionComposite();
            Type paramType = this.paramTypes[i];
            if (paramType instanceof Class) {
                Class paramClass = (Class)paramType;
                fullType = "";
                pdc.setParameterType(paramClass.getName());
            } else if (paramType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)paramType;
                fullType = "";
                fullType = ConverterUtils.getFullType(pt, fullType);
                pdc.setParameterType(fullType);
            }
            pdc.setListOrder(i);
            this.attachWebParamAnnotation(pdc, i);
            pdcList.add(pdc);
        }
        return pdcList;
    }

    private void attachWebParamAnnotation(ParameterDescriptionComposite pdc, int order) {
        Annotation[] orderAnnots;
        for (Annotation annot : orderAnnots = this.paramAnnotations[order]) {
            if (!(annot instanceof WebParam)) continue;
            WebParam webParam = (WebParam)annot;
            WebParamAnnot wpAnnot = WebParamAnnot.createWebParamAnnotImpl();
            wpAnnot.setHeader(webParam.header());
            wpAnnot.setMode(webParam.mode());
            wpAnnot.setName(webParam.name());
            wpAnnot.setPartName(webParam.partName());
            wpAnnot.setTargetNamespace(webParam.targetNamespace());
            pdc.setWebParamAnnot(wpAnnot);
        }
    }
}

