/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.ws.Response;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescriptionUtils {
    private static final Log log = LogFactory.getLog(DescriptionUtils.class);
    static final String NO_PACKAGE_HOST_NAME = "DefaultNamespace";

    DescriptionUtils() {
    }

    static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    static boolean isEmpty(QName qname) {
        return qname == null || DescriptionUtils.isEmpty(qname.getLocalPart());
    }

    static boolean falseExclusionsExist(DescriptionBuilderComposite dbc) {
        MethodDescriptionComposite mdc2 = null;
        for (MethodDescriptionComposite mdc2 : dbc.getMethodDescriptionsList()) {
            WebMethodAnnot wma = mdc2.getWebMethodAnnot();
            if (wma == null || wma.exclude()) continue;
            return true;
        }
        return false;
    }

    static ArrayList<MethodDescriptionComposite> getMethodsWithFalseExclusions(DescriptionBuilderComposite dbc) {
        ArrayList<MethodDescriptionComposite> mdcList = new ArrayList<MethodDescriptionComposite>();
        Iterator<MethodDescriptionComposite> iter = dbc.getMethodDescriptionsList().iterator();
        if (DescriptionUtils.falseExclusionsExist(dbc)) {
            while (iter.hasNext()) {
                MethodDescriptionComposite mdc = iter.next();
                if (mdc.getWebMethodAnnot() == null || mdc.getWebMethodAnnot().exclude()) continue;
                mdc.setDeclaringClass(dbc.getClassName());
                mdcList.add(mdc);
            }
        }
        return mdcList;
    }

    static boolean isExcludeTrue(MethodDescriptionComposite mdc) {
        return mdc.getWebMethodAnnot() != null && mdc.getWebMethodAnnot().exclude();
    }

    static String javifyClassName(String className) {
        if (className.indexOf("/") != -1) {
            return className.replaceAll("/", ".");
        }
        return className;
    }

    static String getSimpleJavaClassName(Class theClass) {
        String returnName = null;
        if (theClass != null) {
            String fqName = theClass.getName();
            int endOfPackageIndex = fqName.lastIndexOf(46);
            int startOfClassIndex = endOfPackageIndex + 1;
            returnName = fqName.substring(startOfClassIndex);
        }
        return returnName;
    }

    static String getSimpleJavaClassName(String name) {
        String returnName = null;
        if (name != null) {
            String fqName = name;
            int endOfPackageIndex = fqName.lastIndexOf(46);
            int startOfClassIndex = endOfPackageIndex + 1;
            returnName = fqName.substring(startOfClassIndex);
        }
        return returnName;
    }

    static String getJavaPackageName(Class theClass) {
        String fqName;
        int endOfPackageIndex;
        String returnPackage = null;
        if (theClass != null && (endOfPackageIndex = (fqName = theClass.getName()).lastIndexOf(46)) >= 0) {
            returnPackage = fqName.substring(0, endOfPackageIndex);
        }
        return returnPackage;
    }

    static String getJavaPackageName(String theClassName) {
        String fqName;
        int endOfPackageIndex;
        String returnPackage = null;
        if (theClassName != null && (endOfPackageIndex = (fqName = theClassName).lastIndexOf(46)) >= 0) {
            returnPackage = fqName.substring(0, endOfPackageIndex);
        }
        return returnPackage;
    }

    static String makeNamespaceFromPackageName(String packageName, String protocol) {
        if (DescriptionUtils.isEmpty(protocol)) {
            protocol = "http";
        }
        if (DescriptionUtils.isEmpty(packageName)) {
            return protocol + "://" + NO_PACKAGE_HOST_NAME;
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString() + "/";
    }

    static boolean createOperationDescription(String methodName) {
        return !methodName.equals("<init>");
    }

    public static InputStream openHandlerConfigStream(String configFile, String className, ClassLoader classLoader) {
        InputStream configStream = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to load @HandlerChain configuration file: " + configFile + " relative to class: " + className));
        }
        try {
            URL configURL = new URL(configFile);
            if (configURL != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found absolute @HandlerChain configuration file: " + configFile));
                }
                configStream = configURL.openStream();
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            ExceptionFactory.makeWebServiceException(Messages.getMessage("hcConfigLoadFail", configFile, className, e.toString()));
        }
        if (configStream == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("@HandlerChain.file attribute referes to a relative location: " + configFile));
            }
            className = className.replace(".", "/");
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolving @HandlerChain configuration file: " + configFile + " relative to class file: " + className));
                }
                URI uri = new URI(className);
                uri = uri.resolve(configFile);
                String resolvedPath = uri.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("@HandlerChain.file resolved file path location: " + resolvedPath));
                }
                configStream = classLoader.getResourceAsStream(resolvedPath);
            }
            catch (URISyntaxException e) {
                ExceptionFactory.makeWebServiceException(Messages.getMessage("hcConfigLoadFail", configFile, className, e.toString()));
            }
        }
        if (configStream == null) {
            ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainNS", configFile, className));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("@HandlerChain configuration file: " + configFile + " in class: " + className + " was successfully loaded."));
        }
        return configStream;
    }

    public static boolean isAsync(Method method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        Class<Object> returnType = method.getReturnType();
        return methodName.endsWith("Async") && (returnType.isAssignableFrom(Response.class) || returnType.isAssignableFrom(Future.class));
    }
}

