/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionJava;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.ServiceRuntimeDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.impl.EndpointDescriptionImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceDescriptionImpl
implements ServiceDescription,
ServiceDescriptionWSDL,
ServiceDescriptionJava {
    private ClientConfigurationFactory clientConfigFactory;
    private ConfigurationContext configContext;
    private URL wsdlURL;
    private QName serviceQName;
    private Class serviceClass;
    private WSDLWrapper wsdlWrapper;
    private WSDLWrapper generatedWsdlWrapper;
    private Map<QName, EndpointDescription> endpointDescriptions = new HashMap<QName, EndpointDescription>();
    private static final Log log = LogFactory.getLog(ServiceDescriptionImpl.class);
    private HashMap<String, DescriptionBuilderComposite> dbcMap = null;
    private DescriptionBuilderComposite composite = null;
    private boolean isServerSide = false;
    Map<String, ServiceRuntimeDescription> runtimeDescMap = Collections.synchronizedMap(new HashMap());

    ServiceDescriptionImpl(URL wsdlURL, QName serviceQName, Class serviceClass) {
        if (serviceQName == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr0"));
        }
        if (serviceClass == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr1", "null"));
        }
        if (!Service.class.isAssignableFrom(serviceClass)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serviceDescErr1", serviceClass.getName()));
        }
        this.wsdlURL = wsdlURL;
        this.serviceQName = serviceQName;
        this.serviceClass = serviceClass;
        this.setupWsdlDefinition();
    }

    ServiceDescriptionImpl(Class serviceImplClass, AxisService axisService) {
        EndpointDescriptionImpl endpointDescription = new EndpointDescriptionImpl(serviceImplClass, null, axisService, this);
        this.addEndpointDescription(endpointDescription);
    }

    ServiceDescriptionImpl(HashMap<String, DescriptionBuilderComposite> dbcMap, DescriptionBuilderComposite composite) {
        this.composite = composite;
        String serviceImplName = this.composite.getClassName();
        this.dbcMap = dbcMap;
        this.isServerSide = true;
        this.setupWsdlDefinition();
        this.validateDBCLIntegrity();
        EndpointDescriptionImpl endpointDescription = new EndpointDescriptionImpl(this, serviceImplName);
        this.addEndpointDescription(endpointDescription);
    }

    EndpointDescription updateEndpointDescription(Class sei, QName portQName, DescriptionFactory.UpdateType updateType) {
        EndpointDescriptionImpl endpointDescription = this.getEndpointDescriptionImpl(portQName);
        boolean isPortDeclared = this.isPortDeclared(portQName);
        switch (updateType) {
            case ADD_PORT: {
                if (DescriptionUtils.isEmpty(portQName)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortErr2"));
                }
                if (this.getWSDLWrapper() != null && isPortDeclared) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("addPortDup", portQName.toString()));
                }
                if (endpointDescription != null) break;
                endpointDescription = new EndpointDescriptionImpl(sei, portQName, true, this);
                this.addEndpointDescription(endpointDescription);
                break;
            }
            case GET_PORT: {
                if (!isPortDeclared || endpointDescription != null && endpointDescription.isDynamicPort()) {
                    throw ExceptionFactory.makeWebServiceException("ServiceDescription.updateEndpointDescription: Can not do a getPort on a port added via addPort().  PortQN: " + (portQName != null ? portQName.toString() : "not specified"));
                }
                if (sei == null) {
                    throw ExceptionFactory.makeWebServiceException("ServiceDescription.updateEndpointDescription: Can not do a getPort with a null SEI.  PortQN: " + (portQName != null ? portQName.toString() : "not specified"));
                }
                if (endpointDescription == null) {
                    endpointDescription = new EndpointDescriptionImpl(sei, portQName, this);
                    this.addEndpointDescription(endpointDescription);
                    break;
                }
                if (this.getEndpointSEI(portQName) == null && !endpointDescription.isDynamicPort()) {
                    endpointDescription.updateWithSEI(sei);
                    break;
                }
                if (this.getEndpointSEI(portQName) == sei) break;
                throw ExceptionFactory.makeWebServiceException("ServiceDescription.updateEndpointDescription: Can't do a getPort() specifiying a different SEI than the previous getPort().  PortQN: " + portQName + "; current SEI: " + sei + "; previous SEI: " + this.getEndpointSEI(portQName));
            }
            case CREATE_DISPATCH: {
                if (DescriptionUtils.isEmpty(portQName)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail0"));
                }
                if (endpointDescription != null) break;
                if (sei != null) {
                    throw ExceptionFactory.makeWebServiceException("ServiceDescription.updateEndpointDescription: Can not specify an SEI when creating a Dispatch. PortQN: " + portQName);
                }
                if (this.getWSDLWrapper() != null && isPortDeclared) {
                    endpointDescription = new EndpointDescriptionImpl(sei, portQName, this);
                    this.addEndpointDescription(endpointDescription);
                    break;
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createDispatchFail1", portQName.toString()));
            }
        }
        return endpointDescription;
    }

    private Class getEndpointSEI(QName portQName) {
        EndpointInterfaceDescription endpointInterfaceDesc;
        Class endpointSEI = null;
        EndpointDescription endpointDesc = this.getEndpointDescription(portQName);
        if (endpointDesc != null && (endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription()) != null) {
            endpointSEI = endpointInterfaceDesc.getSEIClass();
        }
        return endpointSEI;
    }

    private boolean isPortDeclared(QName portQName) {
        Definition wsdlDefn;
        javax.wsdl.Service wsdlService;
        Port wsdlPort;
        boolean portIsDeclared = false;
        portIsDeclared = !DescriptionUtils.isEmpty(portQName) ? (this.getWSDLWrapper() != null ? (wsdlPort = (wsdlService = (wsdlDefn = this.getWSDLWrapper().getDefinition()).getService(this.serviceQName)).getPort(portQName.getLocalPart())) != null : true) : true;
        return portIsDeclared;
    }

    @Override
    public EndpointDescription[] getEndpointDescriptions() {
        return this.endpointDescriptions.values().toArray(new EndpointDescriptionImpl[0]);
    }

    @Override
    public Collection<EndpointDescription> getEndpointDescriptions_AsCollection() {
        return this.endpointDescriptions.values();
    }

    @Override
    public EndpointDescription getEndpointDescription(QName portQName) {
        EndpointDescription returnDesc = null;
        if (!DescriptionUtils.isEmpty(portQName)) {
            returnDesc = this.endpointDescriptions.get(portQName);
        }
        return returnDesc;
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl(QName portQName) {
        return (EndpointDescriptionImpl)this.getEndpointDescription(portQName);
    }

    DescriptionBuilderComposite getDescriptionBuilderComposite() {
        return this.composite;
    }

    @Override
    public EndpointDescription[] getEndpointDescription(Class seiClass) {
        EndpointDescription[] returnEndpointDesc = null;
        ArrayList<EndpointDescriptionImpl> matchingEndpoints = new ArrayList<EndpointDescriptionImpl>();
        for (EndpointDescription endpointDescription : this.endpointDescriptions.values()) {
            Class endpointSEIClass;
            EndpointInterfaceDescription endpointInterfaceDesc = endpointDescription.getEndpointInterfaceDescription();
            if (endpointInterfaceDesc == null || (endpointSEIClass = endpointInterfaceDesc.getSEIClass()) == null || !endpointSEIClass.equals(seiClass)) continue;
            matchingEndpoints.add((EndpointDescriptionImpl)endpointDescription);
        }
        if (matchingEndpoints.size() > 0) {
            returnEndpointDesc = matchingEndpoints.toArray(new EndpointDescriptionImpl[0]);
        }
        return returnEndpointDesc;
    }

    boolean isDBCMap() {
        return this.dbcMap != null;
    }

    private void addEndpointDescription(EndpointDescriptionImpl endpoint) {
        this.endpointDescriptions.put(endpoint.getPortQName(), endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupWsdlDefinition() {
        if (this.isDBCMap()) {
            if (this.composite.getWebServiceAnnot() != null && DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().endpointInterface()) || this.composite.getWebServiceProviderAnnot() != null) {
                if (this.composite.getWsdlDefinition() == null) return;
                this.wsdlURL = this.composite.getWsdlURL();
                try {
                    this.wsdlWrapper = new WSDL4JWrapper(this.wsdlURL, this.composite.getWsdlDefinition());
                    return;
                }
                catch (WSDLException e) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
                }
            } else {
                if (this.composite.getWebServiceAnnot() == null) return;
                DescriptionBuilderComposite seic = this.getDBCMap().get(this.composite.getWebServiceAnnot().endpointInterface());
                try {
                    if (seic.getWsdlDefinition() != null) {
                        this.wsdlURL = seic.getWsdlURL();
                        this.wsdlWrapper = new WSDL4JWrapper(seic.getWsdlURL(), seic.getWsdlDefinition());
                        return;
                    }
                    if (this.composite.getWsdlDefinition() == null) return;
                    this.wsdlURL = this.composite.getWsdlURL();
                    this.wsdlWrapper = new WSDL4JWrapper(this.composite.getWsdlURL(), this.composite.getWsdlDefinition());
                    return;
                }
                catch (WSDLException e) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
                }
            }
        }
        if (this.wsdlURL == null) return;
        try {
            this.wsdlWrapper = new WSDL4JWrapper(this.wsdlURL);
            return;
        }
        catch (FileNotFoundException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlNotFoundErr", e.getMessage()), e);
        }
        catch (UnknownHostException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("unknownHost", e.getMessage()), e);
        }
        catch (ConnectException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("connectionRefused", e.getMessage()), e);
        }
        catch (IOException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("urlStream", e.getMessage()), e);
        }
        catch (WSDLException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("wsdlException", e.getMessage()), e);
        }
    }

    @Override
    public WSDLWrapper getWSDLWrapper() {
        return this.wsdlWrapper;
    }

    @Override
    public URL getWSDLLocation() {
        return this.wsdlURL;
    }

    @Override
    public WSDLWrapper getGeneratedWsdlWrapper() {
        return this.generatedWsdlWrapper;
    }

    @Override
    public ConfigurationContext getAxisConfigContext() {
        if (this.configContext == null) {
            this.configContext = this.getClientConfigurationFactory().getClientConfigurationContext();
        }
        return this.configContext;
    }

    ClientConfigurationFactory getClientConfigurationFactory() {
        if (this.clientConfigFactory == null) {
            this.clientConfigFactory = DescriptionFactory.createClientConfigurationFactory();
        }
        return this.clientConfigFactory;
    }

    @Override
    public ServiceClient getServiceClient(QName portQName) {
        ServiceClient returnServiceClient = null;
        if (!DescriptionUtils.isEmpty(portQName)) {
            EndpointDescription endpointDesc = this.getEndpointDescription(portQName);
            if (endpointDesc != null) {
                returnServiceClient = endpointDesc.getServiceClient();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Could not find portQName: " + portQName + " under ServiceDescription: " + this.toString()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("PortQName agrument is invalid; it can not be null or an empty string: " + portQName));
        }
        return returnServiceClient;
    }

    @Override
    public QName getServiceQName() {
        return this.serviceQName;
    }

    void setServiceQName(QName theName) {
        this.serviceQName = theName;
    }

    @Override
    public boolean isServerSide() {
        return this.isServerSide;
    }

    HashMap<String, DescriptionBuilderComposite> getDBCMap() {
        return this.dbcMap;
    }

    void setGeneratedWsdlWrapper(WSDL4JWrapper wrapper) {
        this.generatedWsdlWrapper = wrapper;
    }

    void setWsdlWrapper(WSDL4JWrapper wrapper) {
        this.wsdlWrapper = wrapper;
    }

    private void validateDBCLIntegrity() {
        try {
            this.validateIntegrity();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validation phase 1 failure: " + ex.toString()), (Throwable)ex);
                log.debug((Object)("Failing composite: " + this.composite.toString()));
            }
            throw ExceptionFactory.makeWebServiceException("Validation Exception " + ex, ex);
        }
    }

    void validateIntegrity() {
        Iterator<String> iter = this.composite.getInterfacesList().iterator();
        boolean providerInterfaceValid = false;
        while (iter.hasNext()) {
            String interfaceString = iter.next();
            if (!interfaceString.equals("javax.xml.ws.Provider<javax.xml.transform.Source>") && !interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>") && !interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>") && !interfaceString.equals("javax.xml.ws.Provider<java.lang.String>")) continue;
            providerInterfaceValid = true;
            if (this.composite.getWebServiceProviderAnnot() != null) continue;
            throw ExceptionFactory.makeWebServiceException("Validation error: This is a Provider based endpoint that does not contain a WebServiceProvider annotation.  Provider class: " + this.composite.getClassName());
        }
        if (this.composite.getWebServiceAnnot() != null && this.composite.getWebServiceProviderAnnot() != null) {
            throw ExceptionFactory.makeWebServiceException("Validation error: WebService annotation and WebServiceProvider annotation cannot coexist.  Implementation class: " + this.composite.getClassName());
        }
        if (this.composite.getWebServiceProviderAnnot() != null) {
            if (!providerInterfaceValid) {
                throw ExceptionFactory.makeWebServiceException("Validation error: This is a Provider that does not specify a valid Provider interface.   Implementation class: " + this.composite.getClassName());
            }
            if (!this.validateDefaultConstructor()) {
                throw ExceptionFactory.makeWebServiceException("Validation error: Provider must have a public default constructor.  Implementation class: " + this.composite.getClassName());
            }
            if (!this.validateInvokeMethod()) {
                throw ExceptionFactory.makeWebServiceException("Validation error: Provider must have a public invoke method.  Implementation class: " + this.composite.getClassName());
            }
            this.validateProviderInterfaces();
        } else if (this.composite.getWebServiceAnnot() != null) {
            if (this.composite.getServiceModeAnnot() != null) {
                throw ExceptionFactory.makeWebServiceException("Validation error: ServiceMode annotation can only be specified for WebServiceProvider.   Implementation class: " + this.composite.getClassName());
            }
            if (!this.composite.isInterface()) {
                if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().wsdlLocation()) && this.composite.getWsdlDefinition() == null && this.composite.getWsdlURL() == null) {
                    throw ExceptionFactory.makeWebServiceException("Validation error: cannot find WSDL Definition specified by this WebService annotation. Implementation class: " + this.composite.getClassName() + "; WSDL location: " + this.composite.getWebServiceAnnot().wsdlLocation());
                }
                if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().endpointInterface())) {
                    DescriptionBuilderComposite seic = this.dbcMap.get(this.composite.getWebServiceAnnot().endpointInterface());
                    if (seic == null) {
                        throw ExceptionFactory.makeWebServiceException("Validation error: cannot find SEI specified by the WebService.endpointInterface.  Implementaiton class: " + this.composite.getClassName() + "; EndpointInterface: " + this.composite.getWebServiceAnnot().endpointInterface());
                    }
                    if (this.composite.getSoapBindingAnnot() != null || this.composite.getWebFaultAnnot() != null || this.composite.getWebServiceClientAnnot() != null || this.composite.getWebServiceContextAnnot() != null || !this.composite.getAllWebServiceRefAnnots().isEmpty()) {
                        throw ExceptionFactory.makeWebServiceException("Validation error: invalid annotations specified when WebService annotation specifies an endpoint interface.  Implemntation class:  " + this.composite.getClassName());
                    }
                    if (!DescriptionUtils.isEmpty(this.composite.getWebServiceAnnot().name())) {
                        throw ExceptionFactory.makeWebServiceException("Validation error: WebService.name must not be specified when the bean specifies an endpoint interface.  Implentation class: " + this.composite.getClassName() + "; WebService.name: " + this.composite.getWebServiceAnnot().name());
                    }
                    this.validateSEI(seic);
                    this.validateImplementation(seic);
                    if (this.webMethodAnnotationsExist()) {
                        throw ExceptionFactory.makeWebServiceException("Validation error: WebMethod annotations cannot exist on implentation when WebService.endpointInterface is set.  Implementation class: " + this.composite.getClassName());
                    }
                } else {
                    this.checkImplicitSEIAgainstWSDL();
                }
            } else {
                throw ExceptionFactory.makeWebServiceException("Validation error: Improper usage: cannot invoke this method with an interface.  Implementation class: " + this.composite.getClassName());
            }
            this.checkMethodsAgainstWSDL();
        }
    }

    private boolean validateInvokeMethod() {
        boolean validInvokeMethod = false;
        List<MethodDescriptionComposite> invokeMethodList = this.composite.getMethodDescriptionComposite("invoke");
        if (invokeMethodList != null && !invokeMethodList.isEmpty()) {
            validInvokeMethod = true;
        }
        return validInvokeMethod;
    }

    private void validateProviderInterfaces() {
        if (this.composite.getServiceModeAnnot() == null || this.composite.getServiceModeAnnot().value() == Service.Mode.PAYLOAD) {
            for (String interfaceString : this.composite.getInterfacesList()) {
                if (!interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>") && !interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>")) continue;
                throw ExceptionFactory.makeWebServiceException("Validation error: SOAPMessage and DataSource objects cannot be used when ServiceMode specifies PAYLOAD. Implementation class: " + this.composite.getClassName());
            }
        } else {
            String bindingType = null;
            if (this.composite.getBindingTypeAnnot() != null) {
                bindingType = this.composite.getBindingTypeAnnot().value();
            }
            for (String interfaceString : this.composite.getInterfacesList()) {
                if (interfaceString.equals("javax.xml.ws.Provider<javax.xml.soap.SOAPMessage>")) {
                    if (DescriptionUtils.isEmpty(bindingType) || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) continue;
                    throw ExceptionFactory.makeWebServiceException("Validation error: SOAPMessage objects cannot be used with HTTP binding type. Implementation class: " + this.composite.getClassName());
                }
                if (!interfaceString.equals("javax.xml.ws.Provider<javax.activation.DataSource>") || !DescriptionUtils.isEmpty(bindingType) && bindingType.equals("http://www.w3.org/2004/08/wsdl/http")) continue;
                throw ExceptionFactory.makeWebServiceException("Validation error: DataSource objects must be used with HTTP binding type. Implementation class: " + this.composite.getClassName());
            }
        }
    }

    private boolean validateDefaultConstructor() {
        boolean validDefaultCtor = false;
        List<MethodDescriptionComposite> constructorList = this.composite.getMethodDescriptionComposite("<init>");
        if (constructorList != null && !constructorList.isEmpty()) {
            for (MethodDescriptionComposite checkCtor : constructorList) {
                List<ParameterDescriptionComposite> paramList = checkCtor.getParameterDescriptionCompositeList();
                if (paramList != null && !paramList.isEmpty()) continue;
                validDefaultCtor = true;
                break;
            }
        }
        return validDefaultCtor;
    }

    private void validateImplementation(DescriptionBuilderComposite seic) {
        HashMap<String, MethodDescriptionComposite> compositeHashMap = new HashMap<String, MethodDescriptionComposite>();
        for (MethodDescriptionComposite mdc : this.composite.getMethodDescriptionsList()) {
            compositeHashMap.put(mdc.getMethodName(), mdc);
        }
        this.addSuperClassMethods(compositeHashMap, this.composite);
        HashMap<String, MethodDescriptionComposite> seiMethodHashMap = new HashMap<String, MethodDescriptionComposite>();
        for (MethodDescriptionComposite mdc : seic.getMethodDescriptionsList()) {
            seiMethodHashMap.put(mdc.getMethodName(), mdc);
        }
        this.addSuperClassMethods(seiMethodHashMap, seic);
        for (MethodDescriptionComposite mdc : seiMethodHashMap.values()) {
            MethodDescriptionComposite implMDC = (MethodDescriptionComposite)compositeHashMap.get(mdc.getMethodName());
            if (implMDC == null) {
                throw ExceptionFactory.makeWebServiceException("Validation error: Implementation subclass does not implement method on specified interface.  Implementation class: " + this.composite.getClassName() + "; missing method name: " + mdc.getMethodName() + "; endpointInterface: " + seic.getClassName());
            }
            this.validateMethodExceptions(mdc, implMDC, seic.getClassName());
            this.validateMethodReturnValue(mdc, implMDC, seic.getClassName());
            this.validateMethodParameters(mdc, implMDC, seic.getClassName());
        }
    }

    private void validateMethodParameters(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        List<ParameterDescriptionComposite> seiPDCList = seiMDC.getParameterDescriptionCompositeList();
        List<ParameterDescriptionComposite> implPDCList = implMDC.getParameterDescriptionCompositeList();
        if (seiPDCList != null && !seiPDCList.isEmpty() || implPDCList != null && !implPDCList.isEmpty()) {
            if ((seiPDCList == null || seiPDCList.isEmpty()) && implPDCList != null && !implPDCList.isEmpty()) {
                String message = "Validation error: SEI indicates no parameters but implementation method specifies parameters: " + implPDCList + "; Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                throw ExceptionFactory.makeWebServiceException(message);
            }
            if (seiPDCList != null && !seiPDCList.isEmpty() && (implPDCList == null || implPDCList.isEmpty())) {
                String message = "Validation error: SEI indicates parameters " + seiPDCList + " but implementation method specifies no parameters; Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                throw ExceptionFactory.makeWebServiceException(message);
            }
            if (seiPDCList.size() != implPDCList.size()) {
                String message = "Validation error: The number of parameters on the SEI method (" + seiPDCList.size() + ") does not match the number of parameters on the implementation ( " + implPDCList.size() + "); Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                throw ExceptionFactory.makeWebServiceException(message);
            }
            boolean parametersMatch = true;
            String failingMessage = null;
            for (int paramNumber = 0; paramNumber < seiPDCList.size(); ++paramNumber) {
                String implParamType;
                String seiParamType = seiPDCList.get(paramNumber).getParameterType();
                if (seiParamType.equals(implParamType = implPDCList.get(paramNumber).getParameterType())) continue;
                parametersMatch = false;
                failingMessage = "Validation error: SEI and implementation parameters do not match.  Parameter number " + paramNumber + " on the SEI is " + seiParamType + "; on the implementation it is " + implParamType + "; Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                break;
            }
            if (!parametersMatch) {
                throw ExceptionFactory.makeWebServiceException(failingMessage);
            }
        }
    }

    private void validateMethodReturnValue(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        String seiReturnValue = seiMDC.getReturnType();
        String implReturnValue = implMDC.getReturnType();
        if (seiReturnValue != null || implReturnValue != null) {
            if (seiReturnValue == null && implReturnValue != null) {
                String message = "Validation error: SEI indicates no return value but implementation method specifies return value: " + implReturnValue + "; Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                throw ExceptionFactory.makeWebServiceException(message);
            }
            if (seiReturnValue != null && implReturnValue == null) {
                String message = "Validation error: SEI indicates return value " + seiReturnValue + " but implementation method specifies no return value; Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                throw ExceptionFactory.makeWebServiceException(message);
            }
            if (!seiReturnValue.equals(implReturnValue)) {
                String message = "Validation error: SEI return value " + seiReturnValue + " does not match implementation method return value " + implReturnValue + "; Implementation class: " + this.composite.getClassName() + "; Method name: " + seiMDC.getMethodName() + "; Endpoint Interface: " + className;
                throw ExceptionFactory.makeWebServiceException(message);
            }
        }
    }

    private void validateMethodExceptions(MethodDescriptionComposite seiMDC, MethodDescriptionComposite implMDC, String className) {
        String[] seiExceptions = seiMDC.getExceptions();
        String[] implExceptions = implMDC.getExceptions();
        if (seiExceptions == null) {
            if (implExceptions == null) {
                return;
            }
            throw ExceptionFactory.makeWebServiceException("Validation error: Implementation method signature has more checked exceptions than SEI method signature (0): Implementation class: " + this.composite.getClassName() + "; method name: " + seiMDC.getMethodName() + "; endpointInterface: " + className);
        }
        if (implExceptions == null) {
            return;
        }
        if (seiExceptions.length < implExceptions.length) {
            throw ExceptionFactory.makeWebServiceException("Validation error: Implementation method signature has more checked exceptions (" + implExceptions.length + ") than SEI method signature (" + seiExceptions.length + "): Implementation class: " + this.composite.getClassName() + "; method name: " + seiMDC.getMethodName() + "; endpointInterface: " + className);
        }
        if (implExceptions.length > 0) {
            for (String implException : implExceptions) {
                boolean foundIt = false;
                if (seiExceptions.length > 0) {
                    for (String seiException : seiExceptions) {
                        if (!seiException.equals(implException)) continue;
                        foundIt = true;
                        break;
                    }
                }
                if (foundIt) continue;
                throw ExceptionFactory.makeWebServiceException("Validation error: Implementation method signature throws exception " + implException + "which is not declared on the SEI method signature: Implementation class: " + this.composite.getClassName() + "; method name: " + seiMDC.getMethodName() + "; endpointInterface: " + className);
            }
        }
    }

    private void addSuperClassMethods(HashMap methodMap, DescriptionBuilderComposite dbc) {
        DescriptionBuilderComposite superDBC = this.dbcMap.get(dbc.getSuperClassName());
        if (superDBC != null) {
            for (MethodDescriptionComposite mdc : superDBC.getMethodDescriptionsList()) {
                methodMap.put(mdc.getMethodName(), mdc);
            }
            this.addSuperClassMethods(methodMap, superDBC);
        }
    }

    private void checkMethodsAgainstWSDL() {
        if (this.webMethodAnnotationsExist()) {
            if (DescriptionUtils.falseExclusionsExist(this.composite)) {
                this.verifyFalseExclusionsWithWSDL();
            } else {
                this.verifyPublicMethodsWithWSDL();
            }
        } else {
            this.verifyPublicMethodsWithWSDL();
        }
    }

    private void checkImplicitSEIAgainstWSDL() {
        if (this.webMethodAnnotationsExist()) {
            if (DescriptionUtils.falseExclusionsExist(this.composite)) {
                this.verifyFalseExclusionsWithWSDL();
            } else {
                this.verifyPublicMethodsWithWSDL();
            }
        } else {
            this.verifyPublicMethodsWithWSDL();
        }
    }

    private void checkSEIAgainstWSDL() {
    }

    private void validateSEI(DescriptionBuilderComposite seic) {
        if (seic.getWebServiceAnnot() == null) {
            throw ExceptionFactory.makeWebServiceException("Validation error: SEI does not contain a WebService annotation.  Implementation class: " + this.composite.getClassName() + "; SEI: " + seic.getClassName());
        }
        if (!seic.getWebServiceAnnot().endpointInterface().equals("")) {
            throw ExceptionFactory.makeWebServiceException("Validation error: SEI must not set a value for @WebService.endpointInterface.  Implementation class: " + this.composite.getClassName() + "; SEI: " + seic.getClassName() + "; Invalid endpointInterface value: " + seic.getWebServiceAnnot().endpointInterface());
        }
        this.checkSEIAgainstWSDL();
        this.validateMethods(seic.getMethodDescriptionsList());
    }

    private boolean webMethodAnnotationsExist() {
        MethodDescriptionComposite mdc2 = null;
        for (MethodDescriptionComposite mdc2 : this.composite.getMethodDescriptionsList()) {
            if (mdc2.getWebMethodAnnot() == null) continue;
            return true;
        }
        return false;
    }

    private void verifyFalseExclusionsWithWSDL() {
    }

    private void verifyPublicMethodsWithWSDL() {
    }

    private void validateMethods(List<MethodDescriptionComposite> mdcList) {
        if (mdcList != null && !mdcList.isEmpty()) {
            for (MethodDescriptionComposite mdc : mdcList) {
                String returnType = mdc.getReturnType();
                if (returnType == null || !returnType.equals("java.util.concurrent.Future") && !returnType.equals("javax.xml.ws.Response")) continue;
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("serverSideAsync", mdc.getDeclaringClass(), mdc.getMethodName()));
            }
        }
    }

    private void validateWSDLOperations() {
    }

    @Override
    public boolean isWSDLSpecified() {
        boolean wsdlSpecified = false;
        if (this.getWSDLWrapper() != null) {
            wsdlSpecified = this.getWSDLWrapper().getDefinition() != null;
        }
        return wsdlSpecified;
    }

    @Override
    public Definition getWSDLDefinition() {
        Definition defn = null;
        if (this.getWSDLWrapper() != null) {
            defn = this.getWSDLWrapper().getDefinition();
        }
        return defn;
    }

    public Definition getWSDLGeneratedDefinition() {
        Definition defn = null;
        if (this.getGeneratedWsdlWrapper() != null) {
            defn = this.getGeneratedWsdlWrapper().getDefinition();
        }
        return defn;
    }

    @Override
    public javax.wsdl.Service getWSDLService() {
        javax.wsdl.Service returnWSDLService = null;
        Definition defn = this.getWSDLDefinition();
        if (defn != null) {
            returnWSDLService = defn.getService(this.getServiceQName());
        }
        return returnWSDLService;
    }

    @Override
    public Map getWSDLPorts() {
        javax.wsdl.Service wsdlService = this.getWSDLService();
        if (wsdlService != null) {
            return wsdlService.getPorts();
        }
        return null;
    }

    @Override
    public List<QName> getPorts() {
        ArrayList<QName> portList = new ArrayList<QName>();
        Map wsdlPortsMap = this.getWSDLPorts();
        if (wsdlPortsMap != null) {
            Iterator wsdlPortsIterator = wsdlPortsMap.values().iterator();
            String serviceTNS = this.getServiceQName().getNamespaceURI();
            Port wsdlPort = null;
            while (wsdlPortsIterator.hasNext()) {
                wsdlPort = (Port)wsdlPortsIterator.next();
                String wsdlPortLocalPart = wsdlPort.getName();
                portList.add(new QName(serviceTNS, wsdlPortLocalPart));
            }
        }
        Collection<EndpointDescription> endpointDescs = this.getEndpointDescriptions_AsCollection();
        for (EndpointDescription endpointDesc : endpointDescs) {
            QName endpointPortQName = endpointDesc.getPortQName();
            if (portList.contains(endpointPortQName)) continue;
            portList.add(endpointPortQName);
        }
        return portList;
    }

    @Override
    public List<Port> getWSDLPortsUsingPortType(QName portTypeQN) {
        Map wsdlPortMap;
        ArrayList<Port> portList = new ArrayList<Port>();
        if (!DescriptionUtils.isEmpty(portTypeQN) && (wsdlPortMap = this.getWSDLPorts()) != null && !wsdlPortMap.isEmpty()) {
            for (Object mapElement : wsdlPortMap.values()) {
                Port wsdlPort = (Port)mapElement;
                PortType wsdlPortType = wsdlPort.getBinding().getPortType();
                QName wsdlPortTypeQN = wsdlPortType.getQName();
                if (!portTypeQN.equals(wsdlPortTypeQN)) continue;
                portList.add(wsdlPort);
            }
        }
        return portList;
    }

    @Override
    public List<Port> getWSDLPortsUsingSOAPAddress(List<Port> wsdlPorts) {
        ArrayList<Port> portsUsingAddress = new ArrayList<Port>();
        if (wsdlPorts != null && !wsdlPorts.isEmpty()) {
            for (Port checkPort : wsdlPorts) {
                List extensibilityElementList = checkPort.getExtensibilityElements();
                for (Object checkElement : extensibilityElementList) {
                    if (!EndpointDescriptionImpl.isSOAPAddressElement((ExtensibilityElement)checkElement)) continue;
                    portsUsingAddress.add(checkPort);
                }
            }
        }
        return portsUsingAddress;
    }

    @Override
    public ServiceRuntimeDescription getServiceRuntimeDesc(String name) {
        return this.runtimeDescMap.get(name);
    }

    @Override
    public void setServiceRuntimeDesc(ServiceRuntimeDescription srd) {
        this.runtimeDescMap.put(srd.getKey(), srd);
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        boolean dumpWSDLContents = false;
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("ServiceQName: " + this.getServiceQName());
            string.append("\n");
            string.append("isWSDLSpecified: " + this.isWSDLSpecified());
            string.append("; ");
            string.append("WSDL Location: " + this.getWSDLLocation());
            string.append("\n");
            if (dumpWSDLContents) {
                string.append("WSDL Definition: " + this.getWSDLDefinition());
                string.append("\n");
                string.append("Generated WSDL Definition: " + this.getWSDLGeneratedDefinition());
            } else {
                string.append("WSDL Definition available: " + (this.getWSDLDefinition() != null));
                string.append("; ");
                string.append("Generated WSDL Definition available: " + (this.getWSDLGeneratedDefinition() != null));
            }
            string.append("\n");
            List<QName> ports = this.getPorts();
            string.append("Number of ports: " + ports.size());
            string.append("\n");
            string.append("Port QNames: ");
            for (QName port : ports) {
                string.append(port + "; ");
            }
            string.append("\n");
            Collection<EndpointDescription> endpointDescs = this.getEndpointDescriptions_AsCollection();
            if (endpointDescs == null) {
                string.append("EndpointDescription array is null");
            } else {
                string.append("Number of EndpointDescrptions: " + endpointDescs.size());
                string.append("\n");
                for (EndpointDescription endpointDesc : endpointDescs) {
                    string.append(endpointDesc.toString());
                    string.append("\n");
                }
            }
            string.append("RuntimeDescriptions:" + this.runtimeDescMap.size());
            string.append("\n");
            for (ServiceRuntimeDescription runtimeDesc : this.runtimeDescMap.values()) {
                string.append(runtimeDesc.toString());
                string.append("\n");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for ServiceDescription");
            return string.toString();
        }
        return string.toString();
    }
}

