/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class URIResolverImpl
implements URIResolver {
    private final String HTTP_PROTOCOL = "http";
    private final String HTTPS_PROTOCOL = "https";
    private final String FILE_PROTOCOL = "file";
    private final String JAR_PROTOCOL = "jar";
    private ClassLoader classLoader;
    private static final Log log = LogFactory.getLog(URIResolverImpl.class);

    public URIResolverImpl() {
    }

    public URIResolverImpl(ClassLoader cl) {
        this.classLoader = cl;
    }

    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        String pathURIStr;
        InputStream is;
        block18: {
            log.info((Object)("resolveEntity: [" + namespace + "][" + schemaLocation + "][ " + baseUri + "]"));
            is = null;
            URI pathURI = null;
            pathURIStr = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Import location: " + schemaLocation + " parent document: " + baseUri));
            }
            if (baseUri != null) {
                try {
                    if (this.isAbsolute(schemaLocation)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Retrieving input stream for absolute schema location: " + schemaLocation));
                        }
                        is = this.getInputStreamForURI(schemaLocation);
                    } else {
                        pathURI = new URI(baseUri);
                        pathURIStr = schemaLocation;
                        if (pathURI.isAbsolute()) {
                            URL url;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Parent document is at absolute location: " + pathURI.toString()));
                            }
                            if ((url = new URL(baseUri)) != null) {
                                URI tempURI = new URI(url.getPath());
                                URI resolvedURI = tempURI.resolve(schemaLocation);
                                pathURIStr = this.constructPath(url, resolvedURI);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Resolved this path to imported document: " + pathURIStr));
                                }
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Parent document is at relative location: " + pathURI.toString()));
                            }
                            pathURI = pathURI.resolve(schemaLocation);
                            pathURIStr = pathURI.toString();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Resolved this path to imported document: " + pathURIStr));
                            }
                        }
                        is = this.isAbsolute(pathURIStr) ? this.getInputStreamForURI(pathURIStr) : this.classLoader.getResourceAsStream(pathURI.toString());
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)e);
                }
            }
        }
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("XSD input stream is null after resolving import for: " + schemaLocation + " from parent document: " + baseUri));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("XSD input stream is not null after resolving import for: " + schemaLocation + " from parent document: " + baseUri));
        }
        InputSource returnInputSource = new InputSource(is);
        returnInputSource.setSystemId(pathURIStr != null ? pathURIStr : schemaLocation);
        log.info((Object)("returnInputSource :" + returnInputSource.getSystemId()));
        return returnInputSource;
    }

    private boolean isAbsolute(String location) {
        boolean absolute = false;
        if (location.indexOf(":/") != -1) {
            absolute = true;
        } else if (location.indexOf(":\\") != -1) {
            absolute = true;
        } else if (location.indexOf("file:") != -1) {
            absolute = true;
        }
        return absolute;
    }

    private InputStream getInputStreamForURI(String uri) {
        URL streamURL = null;
        InputStream is = null;
        URI pathURI = null;
        try {
            streamURL = new URL(uri);
            is = streamURL.openStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null) {
            try {
                pathURI = new URI(uri);
                streamURL = pathURI.toURL();
                is = streamURL.openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(uri);
                streamURL = file.toURL();
                is = streamURL.openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return is;
    }

    private String constructPath(URL baseURL, URI resolvedURI) {
        String importLocation = null;
        URL url = null;
        try {
            if (baseURL.getProtocol() != null && (baseURL.getProtocol().equals("http") || baseURL.getProtocol().equals("https"))) {
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), resolvedURI.toString());
                importLocation = url.toString();
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals("file")) {
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), resolvedURI.toString());
                importLocation = url.toString();
            } else if (baseURL.getProtocol() != null && baseURL.getProtocol().equals("jar")) {
                importLocation = resolvedURI.toString();
                importLocation = importLocation.startsWith(":") ? "jar" + importLocation : "jar:" + importLocation;
            }
        }
        catch (MalformedURLException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("schemaImportError", resolvedURI.toString(), baseURL.toString()), e);
        }
        if (importLocation == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("schemaImportError", resolvedURI.toString(), baseURL.toString()));
        }
        return importLocation;
    }
}

