/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axis2.maven2.repo.ArchiveDeployer;
import org.apache.axis2.maven2.repo.Deployer;
import org.apache.axis2.maven2.repo.GeneratedAxis2Xml;
import org.apache.axis2.maven2.repo.Handler;
import org.apache.axis2.maven2.repo.JAXWSService;
import org.apache.axis2.maven2.repo.MessageHandler;
import org.apache.axis2.maven2.repo.Parameter;
import org.apache.axis2.maven2.repo.ServiceDescription;
import org.apache.axis2.maven2.repo.Transport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCreateRepositoryMojo
extends AbstractMojo {
    private Set<Artifact> projectArtifacts;
    private List<MavenProject> collectedProjects;
    private String servicesDirectory;
    private String modulesDirectory;
    private String jaxwsServicesDirectory;
    private File axis2xml;
    private GeneratedAxis2Xml generatedAxis2xml;
    private String configurationDirectory;
    private boolean useDependencies;
    private boolean useModules;
    private boolean generateFileLists;
    private boolean stripServiceVersion;
    private boolean stripModuleVersion;
    private boolean includeModules;
    private String modules;
    private boolean includeServices;
    private String services;
    private JAXWSService[] jaxwsServices;
    private ServiceDescription[] serviceDescriptions;

    protected abstract String getScope();

    protected abstract File getInputDirectory();

    protected abstract File getOutputDirectory();

    protected abstract File[] getClassDirectories();

    private static void applyParameters(OMElement parentElement, Parameter[] parameters) {
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            OMElement parameterElement = null;
            Iterator it = parentElement.getChildrenWithLocalName("parameter");
            while (it.hasNext()) {
                OMElement candidate = (OMElement)it.next();
                if (!candidate.getAttributeValue(new QName("name")).equals(parameter.getName())) continue;
                parameterElement = candidate;
                break;
            }
            if (parameterElement == null) {
                parameterElement = parentElement.getOMFactory().createOMElement("parameter", null, (OMContainer)parentElement);
                parameterElement.addAttribute("name", parameter.getName(), null);
            }
            parameterElement.setText(parameter.getValue());
        }
    }

    private static void addMessageHandlers(OMElement root, MessageHandler[] handlers, String localName) {
        if (handlers == null) {
            return;
        }
        OMElement parent = root.getFirstChildWithName(new QName(localName + "s"));
        for (MessageHandler handler : handlers) {
            OMElement element = parent.getOMFactory().createOMElement(localName, null, (OMContainer)parent);
            element.addAttribute("contentType", handler.getContentType(), null);
            element.addAttribute("class", handler.getClassName(), null);
        }
    }

    private static void processTransports(OMElement root, Transport[] transports, String localName) {
        if (transports == null) {
            return;
        }
        for (Transport transport : transports) {
            Iterator it = root.getChildrenWithLocalName(localName);
            while (it.hasNext()) {
                OMElement transportElement = (OMElement)it.next();
                if (!transportElement.getAttributeValue(new QName("name")).equals(transport.getName())) continue;
                AbstractCreateRepositoryMojo.applyParameters(transportElement, transport.getParameters());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File targetDirectory;
        Log log = this.getLog();
        File inputDirectory = this.getInputDirectory();
        File outputDirectory = this.getOutputDirectory();
        if (inputDirectory.exists()) {
            log.info((CharSequence)("Copying files from " + inputDirectory));
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(inputDirectory);
            ds.scan();
            for (String relativePath : ds.getIncludedFiles()) {
                try {
                    FileUtils.copyFile((File)new File(inputDirectory, relativePath), (File)new File(outputDirectory, relativePath));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to copy " + relativePath, (Exception)ex);
                }
            }
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        if (this.useDependencies) {
            artifacts.addAll(this.projectArtifacts);
        }
        if (this.useModules) {
            for (MavenProject project : this.collectedProjects) {
                artifacts.add(project.getArtifact());
                artifacts.addAll(project.getAttachedArtifacts());
            }
        }
        if (this.includeModules || this.includeServices) {
            FilterArtifacts filter = new FilterArtifacts();
            filter.addFilter((ArtifactsFilter)new ScopeFilter(this.getScope(), null));
            if (this.includeModules && this.includeServices) {
                filter.addFilter((ArtifactsFilter)new TypeFilter("aar,mar", null));
            } else if (this.includeModules) {
                filter.addFilter((ArtifactsFilter)new TypeFilter("mar", null));
            }
            try {
                artifacts = filter.filter(artifacts);
            }
            catch (ArtifactFilterException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
            this.selectArtifacts(artifacts, this.modules, "mar");
            this.selectArtifacts(artifacts, this.services, "aar");
            HashMap<String, ArchiveDeployer> deployers = new HashMap<String, ArchiveDeployer>();
            deployers.put("aar", new ArchiveDeployer(outputDirectory, this.servicesDirectory, "services.list", this.generateFileLists, this.stripServiceVersion));
            deployers.put("mar", new ArchiveDeployer(outputDirectory, this.modulesDirectory, "modules.list", this.generateFileLists, this.stripModuleVersion));
            for (Artifact artifact : artifacts) {
                File file = artifact.getFile();
                if (file == null || file.isDirectory()) {
                    throw new MojoFailureException("Artifact " + artifact.getId() + " not available. This typically means that it is part of the reactor but that the package phase has not been executed.");
                }
                String type = artifact.getType();
                ArchiveDeployer deployer = (ArchiveDeployer)deployers.get(type);
                if (deployer == null) {
                    throw new MojoExecutionException("No deployer found for artifact type " + type);
                }
                deployer.deploy(log, artifact);
            }
            for (ArchiveDeployer deployer : deployers.values()) {
                deployer.finish(log);
            }
        }
        if (this.jaxwsServices != null) {
            targetDirectory = new File(outputDirectory, this.jaxwsServicesDirectory);
            for (JAXWSService service : this.jaxwsServices) {
                String jarName = service.getName() + ".jar";
                try {
                    JarArchiver archiver = new JarArchiver();
                    archiver.setDestFile(new File(targetDirectory, jarName));
                    String[] packages = service.getPackages();
                    String[] includes = new String[packages.length];
                    for (int i = 0; i < packages.length; ++i) {
                        includes[i] = packages[i].replace('.', '/') + "/**/*.class";
                    }
                    for (File classDirectory : this.getClassDirectories()) {
                        archiver.addDirectory(classDirectory, includes, new String[0]);
                    }
                    if (service.getResourcesDirectory() != null) {
                        archiver.addDirectory(service.getResourcesDirectory());
                    }
                    archiver.createArchive();
                }
                catch (ArchiverException ex) {
                    throw new MojoExecutionException("Failed to build " + jarName, (Exception)((Object)ex));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Failed to build " + jarName, (Exception)ex);
                }
            }
        }
        if (this.serviceDescriptions != null) {
            File parentDirectory = new File(outputDirectory, this.servicesDirectory);
            for (ServiceDescription serviceDescription : this.serviceDescriptions) {
                File servicesFile = new File(serviceDescription.getDirectory(), "services.xml");
                try {
                    File metaInfDirectory;
                    try (FileInputStream in = new FileInputStream(servicesFile);){
                        OMDocument doc = OMXMLBuilderFactory.createOMBuilder((InputStream)in).getDocument();
                        Iterator it = doc.getOMDocumentElement().getChildrenWithLocalName("service");
                        if (!it.hasNext()) {
                            throw new MojoFailureException("No service found in " + servicesFile);
                        }
                        String[] serviceElement = (String[])it.next();
                        if (it.hasNext()) {
                            throw new MojoFailureException(servicesFile + " contains more than one service");
                        }
                        String serviceName = serviceElement.getAttributeValue(new QName("name"));
                        log.info((CharSequence)("Building service " + serviceName));
                        metaInfDirectory = new File(new File(parentDirectory, serviceName), "META-INF");
                        metaInfDirectory.mkdirs();
                        if (serviceDescription.getScope() != null) {
                            serviceElement.addAttribute("scope", serviceDescription.getScope(), null);
                        }
                        AbstractCreateRepositoryMojo.applyParameters((OMElement)serviceElement, serviceDescription.getParameters());
                        try (FileOutputStream out = new FileOutputStream(new File(metaInfDirectory, "services.xml"));){
                            doc.serialize((OutputStream)out);
                        }
                    }
                    DirectoryScanner ds = new DirectoryScanner();
                    ds.setBasedir(serviceDescription.getDirectory());
                    ds.setExcludes(new String[]{"services.xml"});
                    ds.scan();
                    for (String relativePath : ds.getIncludedFiles()) {
                        try {
                            FileUtils.copyFile((File)new File(serviceDescription.getDirectory(), relativePath), (File)new File(metaInfDirectory, relativePath));
                        }
                        catch (IOException ex) {
                            throw new MojoExecutionException("Failed to copy " + relativePath, (Exception)ex);
                        }
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                }
                catch (XMLStreamException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                }
            }
        }
        if (this.generatedAxis2xml != null || this.axis2xml != null) {
            targetDirectory = this.configurationDirectory == null ? outputDirectory : new File(outputDirectory, this.configurationDirectory);
            targetDirectory.mkdirs();
            File axis2xmlFile = new File(targetDirectory, "axis2.xml");
            if (this.axis2xml != null) {
                log.info((CharSequence)"Copying axis2.xml");
                try {
                    FileUtils.copyFile((File)this.axis2xml, (File)axis2xmlFile);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error copying axis2.xml file: " + ex.getMessage(), (Exception)ex);
                }
            }
            log.info((CharSequence)"Generating axis2.xml");
            try {
                FilterArtifacts filter = new FilterArtifacts();
                filter.addFilter((ArtifactsFilter)new ScopeFilter(this.getScope(), null));
                filter.addFilter((ArtifactsFilter)new TypeFilter("jar", null));
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Artifact artifact : filter.filter(this.projectArtifacts)) {
                    urls.add(artifact.getFile().toURI().toURL());
                }
                URLClassLoader classLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]));
                InputStream in = classLoader.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
                if (in == null) {
                    throw new MojoFailureException("The default axis2.xml file could not be found");
                }
                try {
                    OMDocument axis2xmlDoc = OMXMLBuilderFactory.createOMBuilder((InputStream)in).getDocument();
                    OMElement root = axis2xmlDoc.getOMDocumentElement();
                    Object[] it = root.getDescendants(false);
                    while (it.hasNext()) {
                        OMElement element;
                        String classAttr;
                        OMNode node = (OMNode)it.next();
                        if (!(node instanceof OMElement) || (classAttr = (element = (OMElement)node).getAttributeValue(new QName("class"))) == null) continue;
                        try {
                            classLoader.loadClass(classAttr);
                        }
                        catch (ClassNotFoundException ex) {
                            it.remove();
                        }
                    }
                    AbstractCreateRepositoryMojo.applyParameters(root, this.generatedAxis2xml.getParameters());
                    AbstractCreateRepositoryMojo.processTransports(root, this.generatedAxis2xml.getTransportReceivers(), "transportReceiver");
                    AbstractCreateRepositoryMojo.processTransports(root, this.generatedAxis2xml.getTransportSenders(), "transportSender");
                    AbstractCreateRepositoryMojo.addMessageHandlers(root, this.generatedAxis2xml.getMessageBuilders(), "messageBuilder");
                    AbstractCreateRepositoryMojo.addMessageHandlers(root, this.generatedAxis2xml.getMessageFormatters(), "messageFormatter");
                    if (this.generatedAxis2xml.getHandlers() != null) {
                        for (Handler handler : this.generatedAxis2xml.getHandlers()) {
                            boolean handlerInserted = false;
                            Iterator phaseOrderIterator = root.getChildrenWithLocalName("phaseOrder");
                            block44: while (phaseOrderIterator.hasNext()) {
                                OMElement phaseOrder = (OMElement)phaseOrderIterator.next();
                                if (!phaseOrder.getAttributeValue(new QName("type")).equals(handler.getFlow())) continue;
                                Iterator phaseIterator = phaseOrder.getChildrenWithLocalName("phase");
                                while (phaseIterator.hasNext()) {
                                    OMElement phase = (OMElement)phaseIterator.next();
                                    if (!phase.getAttributeValue(new QName("name")).equals(handler.getPhase())) continue;
                                    OMElement handlerElement = axis2xmlDoc.getOMFactory().createOMElement("handler", null, (OMContainer)phase);
                                    handlerElement.addAttribute("name", handler.getName(), null);
                                    handlerElement.addAttribute("class", handler.getClassName(), null);
                                    handlerInserted = true;
                                    break block44;
                                }
                                break block44;
                            }
                            if (handlerInserted) continue;
                            throw new MojoFailureException("Flow " + handler.getFlow() + " and phase " + handler.getPhase() + " not found");
                        }
                    }
                    if (this.generatedAxis2xml.getModules() != null) {
                        for (String module : this.generatedAxis2xml.getModules()) {
                            axis2xmlDoc.getOMFactory().createOMElement("module", null, (OMContainer)root).addAttribute("ref", module, null);
                        }
                    }
                    if (this.generatedAxis2xml.getDeployers() != null) {
                        for (Deployer deployer : this.generatedAxis2xml.getDeployers()) {
                            OMElement deployerElement = axis2xmlDoc.getOMFactory().createOMElement("deployer", null, (OMContainer)root);
                            deployerElement.addAttribute("extension", deployer.getExtension(), null);
                            deployerElement.addAttribute("directory", deployer.getDirectory(), null);
                            deployerElement.addAttribute("class", deployer.getClassName(), null);
                        }
                    }
                    try (FileOutputStream out = new FileOutputStream(axis2xmlFile);){
                        axis2xmlDoc.serialize((OutputStream)out);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (ArtifactFilterException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            catch (XMLStreamException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
    }

    private void selectArtifacts(Set<Artifact> artifacts, String list, String type) throws MojoFailureException {
        if (list != null) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)list, (String)","))));
            Iterator<Artifact> it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = it.next();
                if (!artifact.getType().equals(type) || set.remove(artifact.getArtifactId())) continue;
                it.remove();
            }
            if (!set.isEmpty()) {
                throw new MojoFailureException("The following " + type + " artifacts have not been found: " + set);
            }
        }
    }
}

