/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.saaj.util.SAAJDataSource;

public class AttachmentPartImpl
extends AttachmentPart {
    private DataHandler dataHandler;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private String attachmentFile;
    private OMText omText;
    private boolean isAttachmentReferenced;

    public boolean matches(MimeHeaders headers) {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.mimeHeaders.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!hdr.getValue().equalsIgnoreCase(values[j])) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean isAttachmentReferenced() {
        return this.isAttachmentReferenced;
    }

    public void setAttachmentReferenced(boolean attachmentReferenced) {
        this.isAttachmentReferenced = attachmentReferenced;
    }

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)bout);
        }
        catch (Exception ex) {
            throw new SOAPException((Throwable)ex);
        }
        return bout.size();
    }

    public void clearContent() {
        this.dataHandler = null;
        this.omText = null;
    }

    public Object getContent() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No content is present in this AttachmentPart");
        }
        try {
            String contentType = this.dataHandler.getContentType();
            if (contentType.equals("text/xml") || contentType.equals("application/xml")) {
                StreamSource streamSource = new StreamSource();
                streamSource.setInputStream(this.dataHandler.getInputStream());
                return streamSource;
            }
            if (contentType.equals("text/plain") || contentType.equals("text/html")) {
                return (String)this.dataHandler.getContent();
            }
            try {
                return this.dataHandler.getContent();
            }
            catch (Exception e) {
                return this.dataHandler.getDataSource().getInputStream();
            }
        }
        catch (IOException e) {
            throw new SOAPException(e.getMessage());
        }
    }

    public void setContent(Object object, String contentType) {
        this.setMimeHeader("Content-Type", contentType);
        if (object instanceof String) {
            try {
                String s = (String)object;
                ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
                SAAJDataSource source = new SAAJDataSource(bais, 16384, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                Object contentObject = object;
            }
            catch (IOException io) {
                throw new IllegalArgumentException("Illegal Argument");
            }
        } else if (object instanceof InputStream) {
            try {
                SAAJDataSource source = new SAAJDataSource((InputStream)object, -1, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                Object contentObject = null;
            }
            catch (IOException io) {
                throw new IllegalArgumentException("Illegal Argument");
            }
        } else if (object instanceof StreamSource) {
            try {
                SAAJDataSource source = new SAAJDataSource(((StreamSource)object).getInputStream(), 16384, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                Object contentObject = null;
            }
            catch (IOException io) {
                throw new IllegalArgumentException("Illegal Argument");
            }
        } else if (object instanceof BufferedImage) {
            try {
                this.dataHandler = new DataHandler(object, contentType);
                Object contentObject = null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if (object instanceof byte[]) {
            try {
                Object contentObject = null;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])object);
                SAAJDataSource source = new SAAJDataSource(bais, 16384, contentType, true);
                this.extractFilename(source);
                this.dataHandler = new DataHandler((DataSource)source);
                contentObject = object;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Illegal Argument");
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No Content present in the Attachment part");
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler datahandler) {
        if (datahandler == null) {
            throw new IllegalArgumentException("Cannot set null DataHandler");
        }
        this.dataHandler = datahandler;
        this.setMimeHeader("Content-Type", datahandler.getContentType());
        this.omText = DOOMAbstractFactory.getOMFactory().createOMText((Object)datahandler, true);
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        this.mimeHeaders.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public InputStream getBase64Content() throws SOAPException {
        try {
            if (this.dataHandler == null) {
                throw new SOAPException();
            }
            return this.dataHandler.getInputStream();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public InputStream getRawContent() throws SOAPException {
        try {
            if (this.dataHandler == null) {
                throw new SOAPException("No content set");
            }
            return this.dataHandler.getInputStream();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public byte[] getRawContentBytes() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("Content is null");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.dataHandler.writeTo((OutputStream)bout);
        }
        catch (Exception ex) {
            throw new SOAPException((Throwable)ex);
        }
        return bout.toByteArray();
    }

    public void setBase64Content(InputStream content, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException("Content is null");
        }
        try {
            int size = content.available();
            PushbackInputStream pushbackInputStream = size > 0 ? new PushbackInputStream(content, size) : new PushbackInputStream(content);
            if (!this.isValidBase64Encoding(pushbackInputStream)) {
                throw new SOAPException("Not a valid Base64 encoding");
            }
            this.setContent(pushbackInputStream, contentType);
        }
        catch (Exception ex) {
            throw new SOAPException((Throwable)ex);
        }
    }

    private boolean isValidBase64Encoding(PushbackInputStream pushbackInputStream) {
        try {
            int size = pushbackInputStream.available();
            if (size == 0) {
                return true;
            }
            byte[] buffer = new byte[size];
            int read = pushbackInputStream.read(buffer, 0, size);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(buffer);
            String contentString = ((Object)outputStream).toString();
            ((OutputStream)outputStream).close();
            pushbackInputStream.unread(buffer, 0, read);
            return Base64.isValidBase64Encoding((String)contentString);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setRawContent(InputStream content, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException("content is null");
        }
        this.setContent(content, contentType);
    }

    public void setRawContentBytes(byte[] content, int offset, int len, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException("Content is null");
        }
        this.setContent(content, contentType);
    }

    public OMText getOMText() throws SOAPException {
        if (this.omText == null) {
            throw new SOAPException("OMText set to null");
        }
        return this.omText;
    }

    public TextImpl getText(DocumentImpl doc) {
        return new TextImpl(doc, this.omText.getText(), doc.getOMFactory());
    }

    protected void setAttachmentFile(String path) {
        this.attachmentFile = path;
    }

    public void detachAttachmentFile() {
        this.attachmentFile = null;
    }

    public String getAttachmentFile() {
        return this.attachmentFile;
    }

    private void extractFilename(SAAJDataSource source) {
        if (source.getDiskCacheFile() != null) {
            String path = source.getDiskCacheFile().getAbsolutePath();
            this.setAttachmentFile(path);
        }
    }
}

