/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalResponder
extends AbstractHandler
implements TransportSender {
    protected static final Log log = LogFactory.getLog(LocalResponder.class);
    private OutputStream out;

    public LocalResponder(OutputStream response) {
        this.out = response;
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block10: {
            msgContext.setDoingMTOM(TransportUtils.doWriteMTOM((MessageContext)msgContext));
            msgContext.setDoingSwA(TransportUtils.doWriteSwA((MessageContext)msgContext));
            EndpointReference epr = null;
            if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                epr = msgContext.getTo();
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response - " + msgContext.getEnvelope().toString()));
                }
                if (epr != null) {
                    if (!epr.hasNoneAddress()) {
                        TransportUtils.writeMessage((MessageContext)msgContext, (OutputStream)this.out);
                    }
                    break block10;
                }
                if (msgContext.getOperationContext() != null && msgContext.getOperationContext().getMessageContexts() != null) {
                    MessageContext proxyInMessageContext = msgContext.getOperationContext().getMessageContext("In");
                    if (proxyInMessageContext == null) break block10;
                    MessageContext initialMessageContext = (MessageContext)proxyInMessageContext.getProperty("IN_MESSAGE_CONTEXT");
                    if (initialMessageContext != null) {
                        this.handleResponse(msgContext, initialMessageContext);
                        break block10;
                    }
                    this.out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
                    if (this.out != null) {
                        TransportUtils.writeMessage((MessageContext)msgContext, (OutputStream)this.out);
                        break block10;
                    }
                    throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
                }
                this.out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
                if (this.out != null) {
                    TransportUtils.writeMessage((MessageContext)msgContext, (OutputStream)this.out);
                    break block10;
                }
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error sending response", (Throwable)axisFault);
            }
        }
        TransportUtils.setResponseWritten((MessageContext)msgContext, (boolean)true);
        return Handler.InvocationResponse.CONTINUE;
    }

    private void handleResponse(MessageContext proxyOutMessageContext, MessageContext initialMessageContext) throws AxisFault {
        MessageContext inMessageContext = initialMessageContext.getOperationContext().getMessageContext("In");
        Map initialPropertyMap = initialMessageContext.getProperties();
        initialMessageContext.setProperties(initialPropertyMap);
        inMessageContext.setEnvelope(this.getEnvelope(proxyOutMessageContext));
        inMessageContext.setAxisServiceGroup(initialMessageContext.getAxisServiceGroup());
        inMessageContext.setAxisService(initialMessageContext.getAxisService());
        inMessageContext.setAxisOperation(initialMessageContext.getAxisOperation());
        inMessageContext.setAxisMessage(initialMessageContext.getAxisOperation().getMessage("Out"));
        inMessageContext.setIncomingTransportName("local");
        inMessageContext.setServiceContext(initialMessageContext.getServiceContext());
        inMessageContext.setServerSide(true);
        inMessageContext.setProperty("TRANSPORT_OUT", initialMessageContext.getProperty("TRANSPORT_OUT"));
        inMessageContext.setProperty("OutTransportInfo", initialMessageContext.getProperty("OutTransportInfo"));
        inMessageContext.setTransportIn(initialMessageContext.getTransportIn());
        inMessageContext.setTransportOut(initialMessageContext.getTransportOut());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting AxisServiceGroup - " + initialMessageContext.getAxisServiceGroup()));
            log.debug((Object)("Setting AxisService - " + initialMessageContext.getAxisService()));
            log.debug((Object)("Setting AxisOperation - " + initialMessageContext.getAxisOperation()));
            log.debug((Object)("Setting AxisMessage - " + initialMessageContext.getAxisOperation().getMessage("Out")));
            log.debug((Object)"Setting Incoming Transport name - local");
            log.debug((Object)("Setting Service Context " + initialMessageContext.getServiceGroupContext().toString()));
            log.debug((Object)"Setting ServerSide to true");
            log.debug((Object)("Setting TRANSPORT_OUT property to " + initialMessageContext.getProperty("TRANSPORT_OUT")));
            log.debug((Object)("Setting OutTransportInfo property to " + initialMessageContext.getProperty("OutTransportInfo")));
            log.debug((Object)("Setting TransportIn - " + initialMessageContext.getTransportIn()));
            log.debug((Object)("Setting TransportOut - " + initialMessageContext.getTransportOut()));
            log.debug((Object)("Setting ReplyTo - " + initialMessageContext.getReplyTo()));
            log.debug((Object)("Setting FaultTo - " + initialMessageContext.getFaultTo()));
        }
        inMessageContext.setProperty("messageType", initialMessageContext.getProperty("messageType"));
        if (initialMessageContext.getMessageID() != null) {
            inMessageContext.setRelationships(new RelatesTo[]{new RelatesTo(initialMessageContext.getMessageID())});
        }
        inMessageContext.setReplyTo(initialMessageContext.getReplyTo());
        inMessageContext.setFaultTo(initialMessageContext.getFaultTo());
        AxisEngine.receive((MessageContext)inMessageContext);
    }

    private SOAPEnvelope getEnvelope(MessageContext messageContext) throws AxisFault {
        StAXBuilder builder;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransportUtils.writeMessage((MessageContext)messageContext, (OutputStream)out);
        ByteArrayInputStream bs = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader streamReader = new InputStreamReader(bs);
        try {
            builder = BuilderUtil.getBuilder((Reader)streamReader);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        return (SOAPEnvelope)builder.getDocumentElement();
    }
}

