/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.tcp.TCPOutTransportInfo;
import org.apache.axis2.util.MessageProcessorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPTransportSender
extends AbstractTransportSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        if (targetEPR != null) {
            Map<String, String> params = this.getURLParameters(targetEPR);
            int timeout = -1;
            if (params.containsKey("timeout")) {
                timeout = Integer.parseInt(params.get("timeout"));
            }
            Socket socket = this.openTCPConnection(targetEPR, timeout);
            msgContext.setProperty("transport.tcp.outputSocket", (Object)socket);
            String contentType = params.get("contentType");
            if (contentType == null) {
                contentType = "text/xml";
            }
            try {
                this.writeOut(msgContext, socket, contentType);
                if (!msgContext.getOptions().isUseSeparateListener() && !msgContext.isServerSide()) {
                    this.waitForReply(msgContext, socket, contentType);
                }
            }
            catch (IOException e) {
                this.handleException("Error while sending a TCP request", e);
            }
        } else if (outTransportInfo != null && outTransportInfo instanceof TCPOutTransportInfo) {
            TCPOutTransportInfo outInfo = (TCPOutTransportInfo)outTransportInfo;
            try {
                this.writeOut(msgContext, outInfo.getSocket(), outInfo.getContentType());
            }
            catch (IOException e) {
                this.handleException("Error while sending a TCP response", e);
            }
            finally {
                this.closeConnection(outInfo.getSocket());
            }
        }
    }

    private void writeOut(MessageContext msgContext, Socket socket, String contentType) throws IOException {
        MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
        format.setContentType(contentType);
        byte[] payload = messageFormatter.getBytes(msgContext, format);
        OutputStream out = socket.getOutputStream();
        out.write(payload);
        out.flush();
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
        Object socketObj = msgContext.getProperty("transport.tcp.outputSocket");
        if (socketObj != null) {
            this.closeConnection((Socket)socketObj);
        }
    }

    private void waitForReply(MessageContext msgContext, Socket socket, String contentType) throws AxisFault {
        if (!(msgContext.getAxisOperation() instanceof OutInAxisOperation) && msgContext.getProperty("piggybackMessage") == null) {
            return;
        }
        try {
            MessageContext responseMsgCtx = this.createResponseMessageContext(msgContext);
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)socket.getInputStream(), (String)contentType);
            responseMsgCtx.setEnvelope(envelope);
            AxisEngine.receive((MessageContext)responseMsgCtx);
        }
        catch (Exception e) {
            this.handleException("Error while processing response", e);
        }
    }

    private Map<String, String> getURLParameters(String url) throws AxisFault {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            URI tcpUrl = new URI(url);
            String query = tcpUrl.getQuery();
            if (query != null) {
                String[] paramStrings;
                for (String p : paramStrings = query.split("&")) {
                    int index = p.indexOf(61);
                    params.put(p.substring(0, index), p.substring(index + 1));
                }
            }
            return params;
        }
        catch (URISyntaxException e) {
            this.handleException("Malformed tcp url", e);
            return null;
        }
    }

    private Socket openTCPConnection(String url, int timeout) throws AxisFault {
        try {
            URI tcpUrl = new URI(url);
            if (!tcpUrl.getScheme().equals("tcp")) {
                throw new Exception("Invalid protocol prefix : " + tcpUrl.getScheme());
            }
            InetSocketAddress address = new InetSocketAddress(tcpUrl.getHost(), tcpUrl.getPort());
            Socket socket = new Socket();
            if (timeout != -1) {
                socket.setSoTimeout(timeout);
            }
            socket.connect(address);
            return socket;
        }
        catch (Exception e) {
            this.handleException("Error while opening TCP connection to : " + url, e);
            return null;
        }
    }

    private void closeConnection(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while closing a TCP socket", (Throwable)e);
        }
    }
}

