/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.webapp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.ForbidSessionCreationWrapper;
import org.apache.axis2.webapp.Action;
import org.apache.axis2.webapp.ActionHandler;
import org.apache.axis2.webapp.ActionResult;
import org.apache.axis2.webapp.AdminActions;
import org.apache.axis2.webapp.CSRFPreventionResponseWrapper;
import org.apache.axis2.webapp.CSRFTokenCache;
import org.apache.axis2.webapp.Status;
import org.apache.axis2.webapp.StatusCache;

public class AxisAdminServlet
extends AxisServlet {
    private static final long serialVersionUID = -6740625806509755370L;
    private final Random random = new SecureRandom();
    private final Map<String, ActionHandler> actionHandlers = new HashMap();

    private boolean axisSecurityEnabled() {
        Parameter parameter = this.configContext.getAxisConfiguration().getParameter("disableAdminSecurity");
        return parameter == null || !"true".equals(parameter.getValue());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            action = "index";
        } else if (pathInfo.charAt(0) == '/') {
            action = pathInfo.substring(1);
        } else {
            response.sendError(404);
            return;
        }
        ActionHandler actionHandler = (ActionHandler)this.actionHandlers.get(action);
        if (actionHandler != null) {
            if (actionHandler.isMethodAllowed(request.getMethod())) {
                Status status;
                StatusCache statusCache;
                String statusKey;
                if (!actionHandler.isSessionCreationAllowed()) {
                    request = new ForbidSessionCreationWrapper(request);
                }
                HttpSession session = request.getSession(false);
                if (actionHandler.isCSRFTokenRequired()) {
                    boolean tokenValid;
                    if (session == null) {
                        tokenValid = false;
                    } else {
                        CSRFTokenCache tokenCache = (CSRFTokenCache)session.getAttribute(CSRFTokenCache.class.getName());
                        if (tokenCache == null) {
                            tokenValid = false;
                        } else {
                            String token = request.getParameter("token");
                            boolean bl = tokenValid = token != null && tokenCache.isValid(token);
                        }
                    }
                    if (!tokenValid) {
                        response.sendError(403, "No valid CSRF token found in request");
                        return;
                    }
                }
                request.setAttribute("servicePath", (Object)this.configContext.getServicePath());
                if (session != null && (statusKey = request.getParameter("status")) != null && (statusCache = (StatusCache)session.getAttribute(StatusCache.class.getName())) != null && (status = statusCache.get(statusKey)) != null) {
                    request.setAttribute("status", (Object)status);
                }
                ActionResult result = actionHandler.handle(request, this.axisSecurityEnabled());
                result.process(request, (HttpServletResponse)new CSRFPreventionResponseWrapper(request, response, this.actionHandlers, this.random));
            } else {
                response.sendError(405);
            }
        } else {
            response.sendError(404);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        this.configContext = (ConfigurationContext)servletContext.getAttribute("CONFIGURATION_CONTEXT");
        servletContext.setAttribute(this.getClass().getName(), (Object)this);
        AdminActions actions = new AdminActions(this.configContext);
        for (Method method : actions.getClass().getMethods()) {
            Action actionAnnotation = method.getAnnotation(Action.class);
            if (actionAnnotation == null) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || parameterTypes[0] != HttpServletRequest.class || !ActionResult.class.isAssignableFrom(method.getReturnType())) {
                throw new ServletException("Invalid method signature");
            }
            this.actionHandlers.put(actionAnnotation.name(), new ActionHandler((Object)actions, method, actionAnnotation.authorizationRequired(), actionAnnotation.post(), actionAnnotation.sessionCreationAllowed()));
        }
        this.servletConfig = config;
    }

    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }
}

