/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.wsdl2code;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.maven2.wsdl2code.NamespaceURIMapping;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class WSDL2CodeMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactFactory artifactFactory;
    private List pluginArtifacts;
    private File wsdlFile;
    private File outputDirectory;
    private String packageName;
    private String language;
    private String databindingName;
    private String portName;
    private String serviceName;
    private String syncMode;
    private boolean generateServerSide;
    private boolean generateTestcase;
    private boolean generateServicesXml;
    private boolean generateAllClasses;
    private boolean unpackClasses;
    private boolean generateServerSideInterface = false;
    private String repositoryPath = null;
    private String externalMapping = null;
    private String wsdlVersion = null;
    private String targetSourceFolderLocation = null;
    private String targetResourcesFolderLocation = null;
    private boolean unwrap = false;
    private boolean allPorts = false;
    private boolean backwardCompatible = false;
    private boolean flattenFiles = false;
    private boolean skipMessageReceiver = false;
    private boolean skipBuildXML = false;
    private boolean skipWSDL = false;
    private boolean overWrite = false;
    private boolean suppressPrefixes = false;
    private Properties options;
    private String namespaceToPackages = null;
    private NamespaceURIMapping[] namespaceURIs = null;
    private static final InheritedArtifact[] inheritedArtifacts = new InheritedArtifact[]{new InheritedArtifact("org.apache.ws.commons.axiom", "axiom-api"), new InheritedArtifact("org.apache.ws.commons.axiom", "axiom-impl"), new InheritedArtifact("org.apache.ws.commons", "neethi"), new InheritedArtifact("wsdl4j", "wsdl4j"), new InheritedArtifact("commons-httpclient", "commons-httpclient")};
    private static final InheritedArtifact[] adbArtifacts = new InheritedArtifact[]{new InheritedArtifact("org.apache.axis2", "axis2-adb")};
    private static final InheritedArtifact[] xbeanArtifacts = new InheritedArtifact[]{new InheritedArtifact("org.apache.axis2", "axis2-xmlbeans"), new InheritedArtifact("xmlbeans", "xbean")};

    private Map fillOptionMap() throws MojoFailureException {
        HashMap<String, CommandLineOption> optionMap = new HashMap<String, CommandLineOption>();
        optionMap.put("uri", new CommandLineOption("uri", this.getStringArray(this.wsdlFile.getPath())));
        optionMap.put("o", new CommandLineOption("o", this.getStringArray(this.outputDirectory.getPath())));
        optionMap.put("d", new CommandLineOption("d", this.getStringArray(this.databindingName)));
        if ("async".equals(this.syncMode)) {
            optionMap.put("a", new CommandLineOption("a", new String[0]));
        } else if ("sync".equals(this.syncMode)) {
            optionMap.put("s", new CommandLineOption("s", new String[0]));
        } else if (!"both".equals(this.syncMode)) {
            throw new MojoFailureException("Invalid syncMode: " + this.syncMode + ", expected either of 'sync', 'async' or 'both'.");
        }
        optionMap.put("p", new CommandLineOption("p", this.getStringArray(this.packageName)));
        optionMap.put("l", new CommandLineOption("l", this.getStringArray(this.language)));
        if (this.generateServerSide) {
            optionMap.put("ss", new CommandLineOption("ss", new String[0]));
            if (this.generateServicesXml) {
                optionMap.put("sd", new CommandLineOption("sd", new String[0]));
            }
            if (this.generateAllClasses) {
                optionMap.put("g", new CommandLineOption("g", new String[0]));
            }
        }
        if (this.generateTestcase) {
            optionMap.put("t", new CommandLineOption("t", new String[0]));
        }
        if (this.unpackClasses) {
            optionMap.put("u", new CommandLineOption("u", new String[0]));
        }
        if (this.generateServerSideInterface) {
            optionMap.put("ssi", new CommandLineOption("ssi", new String[0]));
        }
        if (this.unwrap) {
            optionMap.put("uw", new CommandLineOption("uw", new String[0]));
        }
        if (this.allPorts) {
            optionMap.put("ap", new CommandLineOption("ap", new String[0]));
        }
        if (this.backwardCompatible) {
            optionMap.put("b", new CommandLineOption("b", new String[0]));
        }
        if (this.flattenFiles) {
            optionMap.put("f", new CommandLineOption("f", new String[0]));
        }
        if (this.skipMessageReceiver) {
            optionMap.put("noMessageReceiver", new CommandLineOption("noMessageReceiver", new String[0]));
        }
        if (this.skipBuildXML) {
            optionMap.put("noBuildXML", new CommandLineOption("noBuildXML", new String[0]));
        }
        if (this.skipWSDL) {
            optionMap.put("noWSDL", new CommandLineOption("noWSDL", new String[0]));
        }
        if (this.overWrite) {
            optionMap.put("or", new CommandLineOption("or", new String[0]));
        }
        if (this.suppressPrefixes) {
            optionMap.put("sp", new CommandLineOption("sp", new String[0]));
        }
        if (this.repositoryPath != null) {
            optionMap.put("r", new CommandLineOption("r", new String[]{this.repositoryPath}));
        }
        if (this.externalMapping != null) {
            optionMap.put("em", new CommandLineOption("em", new String[]{this.externalMapping}));
        }
        if (this.wsdlVersion != null) {
            optionMap.put("wv", new CommandLineOption("wv", new String[]{this.wsdlVersion}));
        }
        if (this.targetSourceFolderLocation != null) {
            optionMap.put("S", new CommandLineOption("S", new String[]{this.targetSourceFolderLocation}));
        }
        if (this.targetResourcesFolderLocation != null) {
            optionMap.put("R", new CommandLineOption("R", new String[]{this.targetResourcesFolderLocation}));
        }
        Iterator<Map.Entry<Object, Object>> iterator = this.options.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = "E" + entry.getKey();
            String value = (String)entry.getValue();
            optionMap.put(key, new CommandLineOption(key, new String[]{value}));
        }
        optionMap.put("sn", new CommandLineOption("sn", new String[]{this.serviceName}));
        optionMap.put("pn", new CommandLineOption("pn", new String[]{this.portName}));
        if (this.namespaceToPackages != null || this.namespaceURIs != null) {
            optionMap.put("ns2p", new CommandLineOption("ns2p", new String[]{this.getNamespaceToPackagesMap()}));
        }
        return optionMap;
    }

    private String getNamespaceToPackagesMap() throws MojoFailureException {
        StringBuffer sb = new StringBuffer();
        if (this.namespaceToPackages != null) {
            sb.append(this.namespaceToPackages);
        }
        if (this.namespaceURIs != null) {
            for (int i = 0; i < this.namespaceURIs.length; ++i) {
                NamespaceURIMapping mapping = this.namespaceURIs[i];
                String uri = mapping.getUri();
                if (uri == null) {
                    throw new MojoFailureException("A namespace to package mapping requires an uri child element.");
                }
                String uriPackageName = mapping.getPackageName();
                if (uriPackageName == null) {
                    throw new MojoFailureException("A namespace to package mapping requires a packageName child element.");
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(uri);
                sb.append('=');
                sb.append(uriPackageName);
            }
        }
        return sb.length() != 0 ? sb.toString() : null;
    }

    private String[] getStringArray(String value) {
        String[] values = new String[]{value};
        return values;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.fixCompileSourceRoots();
        this.fixDependencies();
        this.showDependencies();
        Map commandLineOptions = this.fillOptionMap();
        CommandLineOptionParser parser = new CommandLineOptionParser(commandLineOptions);
        try {
            new CodeGenerationEngine(parser).generate();
        }
        catch (CodeGenerationException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            t.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void showDependencies() {
        Artifact artifact;
        Log log = this.getLog();
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((CharSequence)"The projects dependency artifacts are: ");
        Iterator iter = this.project.getDependencyArtifacts().iterator();
        while (iter.hasNext()) {
            artifact = (Artifact)iter.next();
            log.debug((CharSequence)("    " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getScope() + ":" + artifact.getType()));
        }
        log.debug((CharSequence)"The projects transitive artifacts are: ");
        iter = this.project.getArtifacts().iterator();
        while (iter.hasNext()) {
            artifact = (Artifact)iter.next();
            log.debug((CharSequence)("    " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getScope() + ":" + artifact.getType()));
        }
    }

    private Artifact findArtifact(Collection pCollection, String pGroupId, String pArtifactId) {
        Iterator iter = pCollection.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!pGroupId.equals(artifact.getGroupId()) || !pArtifactId.equals(artifact.getArtifactId())) continue;
            return artifact;
        }
        return null;
    }

    private InheritedArtifact[] getInheritedArtifacts() {
        ArrayList<InheritedArtifact> list = new ArrayList<InheritedArtifact>();
        list.addAll(Arrays.asList(inheritedArtifacts));
        if ("adb".equals(this.databindingName)) {
            list.addAll(Arrays.asList(adbArtifacts));
        } else if ("xmlbeans".equals(this.databindingName)) {
            list.addAll(Arrays.asList(xbeanArtifacts));
        }
        return list.toArray(new InheritedArtifact[list.size()]);
    }

    private InheritedArtifact getInheritedArtifact(InheritedArtifact[] pInheritedArtifacts, Artifact pArtifact) {
        for (int i = 0; i < pInheritedArtifacts.length; ++i) {
            InheritedArtifact iArtifact = pInheritedArtifacts[i];
            if (!iArtifact.getGroupId().equals(pArtifact.getGroupId()) || !iArtifact.getArtifactId().equals(pArtifact.getArtifactId())) continue;
            return iArtifact;
        }
        return null;
    }

    private void fixDependencies() {
        HashSet<Artifact> set = new HashSet<Artifact>(this.project.getDependencyArtifacts());
        InheritedArtifact[] inhArtifacts = this.getInheritedArtifacts();
        Iterator iter = this.pluginArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            InheritedArtifact iArtifact = this.getInheritedArtifact(inhArtifacts, artifact);
            if (iArtifact == null) continue;
            iArtifact.setAdded();
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            if (this.findArtifact(this.project.getArtifacts(), groupId, artifactId) == null) {
                this.getLog().debug((CharSequence)("Adding artifact " + groupId + ":" + artifactId));
                Artifact artfct = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, artifact.getVersion(), artifact.getType(), artifact.getClassifier());
                artfct.setScope("compile");
                set.add(artfct);
                continue;
            }
            this.getLog().debug((CharSequence)("The artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " is already present " + " in the project and will not be added."));
        }
        this.project.setDependencyArtifacts(set);
    }

    private void fixCompileSourceRoots() {
        File srcDir = new File(this.outputDirectory, "src");
        this.project.addCompileSourceRoot(srcDir.getPath());
    }

    private static class InheritedArtifact {
        private final String groupId;
        private final String artifactId;
        private boolean added;

        InheritedArtifact(String pGroupId, String pArtifactId) {
            this.groupId = pGroupId;
            this.artifactId = pArtifactId;
        }

        String getGroupId() {
            return this.groupId;
        }

        String getArtifactId() {
            return this.artifactId;
        }

        boolean isAdded() {
            return this.added;
        }

        void setAdded() {
            if (this.added) {
                throw new IllegalStateException("This artifact was already added: " + this.groupId + ":" + this.artifactId);
            }
        }
    }
}

