/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.wsdl2code;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.maven.shared.NamespaceMapping;
import org.apache.axis2.maven.shared.NamespaceMappingUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWSDL2CodeMojo
extends AbstractMojo {
    private MavenProject project;
    private String wsdlFile;
    private String packageName;
    private String language;
    private String databindingName;
    private String jibxBindingFile;
    private String portName;
    private String serviceName;
    private String syncMode;
    private boolean generateServerSide;
    private boolean generateTestcase;
    private boolean generateServicesXml;
    private boolean generateAllClasses;
    private boolean unpackClasses;
    private boolean generateServerSideInterface = false;
    private String repositoryPath = null;
    private File externalMapping = null;
    private String wsdlVersion;
    private String targetSourceFolderLocation;
    private String targetResourcesFolderLocation = null;
    private boolean unwrap = false;
    private boolean allPorts = false;
    private boolean backwardCompatible = false;
    private boolean flattenFiles = false;
    private boolean skipMessageReceiver = false;
    private boolean skipBuildXML = false;
    private boolean skipWSDL = false;
    private boolean overWrite = false;
    private boolean suppressPrefixes = false;
    private Properties options;
    private String namespaceToPackages = null;
    private NamespaceMapping[] namespaceMappings;
    private NamespaceMapping[] namespaceURIs = null;
    private String encoding;

    private CodeGenConfiguration buildConfiguration() throws CodeGenerationException, MojoFailureException {
        File file;
        CodeGenConfiguration config = new CodeGenConfiguration();
        if (this.wsdlFile.indexOf(":") == -1 && !(file = new File(this.wsdlFile)).isAbsolute()) {
            this.wsdlFile = this.project.getBasedir() + File.separator + this.wsdlFile;
        }
        config.setOutputLocation(this.getOutputDirectory());
        config.setDatabindingType(this.databindingName);
        if ("jibx".equals(this.databindingName)) {
            config.getProperties().put("bindingfile", this.jibxBindingFile);
        }
        if ("async".equals(this.syncMode)) {
            config.setSyncOn(false);
            config.setAsyncOn(true);
        } else if ("sync".equals(this.syncMode)) {
            config.setSyncOn(true);
            config.setAsyncOn(false);
        } else if ("both".equals(this.syncMode)) {
            config.setSyncOn(true);
            config.setAsyncOn(true);
        } else {
            throw new MojoFailureException("Invalid syncMode: " + this.syncMode + ", expected either of 'sync', 'async' or 'both'.");
        }
        config.setPackageName(this.packageName);
        config.setOutputLanguage(this.language);
        config.setServerSide(this.generateServerSide);
        config.setGenerateDeployementDescriptor(this.generateServicesXml);
        config.setGenerateAll(this.generateAllClasses);
        config.setWriteTestCase(this.generateTestcase);
        config.setPackClasses(!this.unpackClasses);
        config.setServerSideInterface(this.generateServerSideInterface);
        config.setParametersWrapped(!this.unwrap);
        config.setAllPorts(this.allPorts);
        config.setBackwordCompatibilityMode(this.backwardCompatible);
        config.setFlattenFiles(this.flattenFiles);
        config.setSkipMessageReceiver(this.skipMessageReceiver);
        config.setSkipBuildXML(this.skipBuildXML);
        config.setSkipWriteWSDLs(this.skipWSDL);
        config.setOverride(this.overWrite);
        config.setSuppressPrefixesMode(this.suppressPrefixes);
        config.setRepositoryPath(this.repositoryPath);
        config.setTypeMappingFile(this.externalMapping);
        config.setWSDLVersion(this.wsdlVersion);
        config.setSourceLocation(this.targetSourceFolderLocation);
        if (this.targetResourcesFolderLocation != null) {
            config.setResourceLocation(this.targetResourcesFolderLocation);
        }
        if (this.options != null) {
            config.getProperties().putAll(this.options);
        }
        config.setServiceName(this.serviceName);
        config.setPortName(this.portName);
        config.setUri2PackageNameMap(this.getNamespaceToPackagesMap());
        config.setOutputEncoding(this.encoding);
        config.loadWsdl(this.wsdlFile);
        return config;
    }

    private Map<String, String> getNamespaceToPackagesMap() throws MojoFailureException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.namespaceToPackages != null) {
            for (String pair : this.namespaceToPackages.trim().split(",")) {
                String[] values = pair.split("=");
                map.put(values[0].trim(), values[1].trim());
            }
        }
        NamespaceMappingUtil.addToMap((NamespaceMapping[])this.namespaceURIs, map);
        NamespaceMappingUtil.addToMap((NamespaceMapping[])this.namespaceMappings, map);
        return map;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        File outputDirectory = this.getOutputDirectory();
        outputDirectory.mkdirs();
        this.addSourceRoot(this.project, new File(outputDirectory, this.targetSourceFolderLocation));
        try {
            new CodeGenerationEngine(this.buildConfiguration()).generate();
        }
        catch (CodeGenerationException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            t.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected abstract File getOutputDirectory();

    protected abstract void addSourceRoot(MavenProject var1, File var2);
}

