/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.pubsub;

import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.pubsub.PubsubReceiver;
import org.apache.spark.streaming.pubsub.SparkGCPCredentials;
import org.apache.spark.streaming.pubsub.SparkPubsubMessage;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\t1\u0011!\u0003U;cgV\u0014\u0017J\u001c9vi\u0012\u001bFO]3b[*\u00111\u0001B\u0001\u0007aV\u00147/\u001e2\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\rq\u0011cE\u0007\u0002\u001f)\u0011\u0001\u0003B\u0001\bIN$(/Z1n\u0013\t\u0011rB\u0001\u000bSK\u000e,\u0017N^3s\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011!c\u00159be.\u0004VOY:vE6+7o]1hK\"A\u0001\u0004\u0001B\u0001B\u0003%!$\u0001\u0003`gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011}\u0001!Q1A\u0005\u0002\u0001\nq\u0001\u001d:pU\u0016\u001cG/F\u0001\"!\t\u0011\u0003F\u0004\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9C%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014%\u0011!a\u0003A!A!\u0002\u0013\t\u0013\u0001\u00039s_*,7\r\u001e\u0011\t\u00119\u0002!Q1A\u0005\u0002=\nQ\u0001^8qS\u000e,\u0012\u0001\r\t\u0004GE\n\u0013B\u0001\u001a%\u0005\u0019y\u0005\u000f^5p]\"AA\u0007\u0001B\u0001B\u0003%\u0001'\u0001\u0004u_BL7\r\t\u0005\tm\u0001\u0011)\u0019!C\u0001A\u0005a1/\u001e2tGJL\u0007\u000f^5p]\"A\u0001\b\u0001B\u0001B\u0003%\u0011%A\u0007tk\n\u001c8M]5qi&|g\u000e\t\u0005\tu\u0001\u0011)\u0019!C\u0001w\u0005Q1M]3eK:$\u0018.\u00197\u0016\u0003q\u0002\"\u0001F\u001f\n\u0005y\u0012!aE*qCJ\\wi\u0011)De\u0016$WM\u001c;jC2\u001c\b\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0017\r\u0014X\rZ3oi&\fG\u000e\t\u0005\t\u0005\u0002\u0011)\u0019!C\u0001\u0007\u0006iql\u001d;pe\u0006<W\rT3wK2,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002J\r\na1\u000b^8sC\u001e,G*\u001a<fY\"A1\n\u0001B\u0001B\u0003%A)\u0001\b`gR|'/Y4f\u0019\u00164X\r\u001c\u0011\t\u00115\u0003!Q1A\u0005\u00029\u000bq\"Y;u_\u0006\u001b7N\\8xY\u0016$w-Z\u000b\u0002\u001fB\u00111\u0005U\u0005\u0003#\u0012\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003P\u0003A\tW\u000f^8BG.twn\u001e7fI\u001e,\u0007\u0005C\u0003V\u0001\u0011\u0005a+\u0001\u0004=S:LGO\u0010\u000b\t/bK&l\u0017/^=B\u0011A\u0003\u0001\u0005\u00061Q\u0003\rA\u0007\u0005\u0006?Q\u0003\r!\t\u0005\u0006]Q\u0003\r\u0001\r\u0005\u0006mQ\u0003\r!\t\u0005\u0006uQ\u0003\r\u0001\u0010\u0005\u0006\u0005R\u0003\r\u0001\u0012\u0005\u0006\u001bR\u0003\ra\u0014\u0005\u0006A\u0002!\t%Y\u0001\fO\u0016$(+Z2fSZ,'\u000fF\u0001c!\r\u0019gmE\u0007\u0002I*\u0011Q\rB\u0001\te\u0016\u001cW-\u001b<fe&\u0011q\r\u001a\u0002\t%\u0016\u001cW-\u001b<fe\u0002")
public class PubsubInputDStream
extends ReceiverInputDStream<SparkPubsubMessage> {
    private final String project;
    private final Option<String> topic;
    private final String subscription;
    private final SparkGCPCredentials credential;
    private final StorageLevel _storageLevel;
    private final boolean autoAcknowledge;

    public String project() {
        return this.project;
    }

    public Option<String> topic() {
        return this.topic;
    }

    public String subscription() {
        return this.subscription;
    }

    public SparkGCPCredentials credential() {
        return this.credential;
    }

    public StorageLevel _storageLevel() {
        return this._storageLevel;
    }

    public boolean autoAcknowledge() {
        return this.autoAcknowledge;
    }

    public Receiver<SparkPubsubMessage> getReceiver() {
        return new PubsubReceiver(this.project(), this.topic(), this.subscription(), this.credential(), this._storageLevel(), this.autoAcknowledge());
    }

    public PubsubInputDStream(StreamingContext _ssc, String project, Option<String> topic, String subscription, SparkGCPCredentials credential, StorageLevel _storageLevel, boolean autoAcknowledge) {
        this.project = project;
        this.topic = topic;
        this.subscription = subscription;
        this.credential = credential;
        this._storageLevel = _storageLevel;
        this.autoAcknowledge = autoAcknowledge;
        super(_ssc, ClassTag$.MODULE$.apply(SparkPubsubMessage.class));
    }
}

