/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.pubsub;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.api.services.pubsub.model.Subscription;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import java.util.List;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.pubsub.ConnectionUtils$;
import org.apache.spark.streaming.pubsub.SparkGCPCredentials;
import org.apache.spark.streaming.pubsub.SparkPubsubMessage;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0001\u0003\u0001\ta!A\u0004)vEN,(MU3dK&4XM\u001d\u0006\u0003\u0007\u0011\ta\u0001];cgV\u0014'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002E\u0002\u000f#Mi\u0011a\u0004\u0006\u0003!\u0011\t\u0001B]3dK&4XM]\u0005\u0003%=\u0011\u0001BU3dK&4XM\u001d\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011!c\u00159be.\u0004VOY:vE6+7o]1hK\"A\u0001\u0004\u0001B\u0001B\u0003%!$A\u0004qe>TWm\u0019;\u0004\u0001A\u00111$\t\b\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%H\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!;!AQ\u0005\u0001B\u0001B\u0003%a%A\u0003u_BL7\rE\u0002\u001dOiI!\u0001K\u000f\u0003\r=\u0003H/[8o\u0011!Q\u0003A!A!\u0002\u0013Q\u0012\u0001D:vEN\u001c'/\u001b9uS>t\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0015\r\u0014X\rZ3oi&\fG\u000e\u0005\u0002\u0015]%\u0011qF\u0001\u0002\u0014'B\f'o[$D!\u000e\u0013X\rZ3oi&\fGn\u001d\u0005\nc\u0001\u0011\t\u0011)A\u0005ea\nAb\u001d;pe\u0006<W\rT3wK2\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0004\u0002\u000fM$xN]1hK&\u0011q\u0007\u000e\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0005\u0003cEA\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaO\u0001\u0010CV$x.Q2l]><H.\u001a3hKB\u0011A\u0004P\u0005\u0003{u\u0011qAQ8pY\u0016\fg\u000eC\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\b\u0003\n\u001bE)\u0012$H!\t!\u0002\u0001C\u0003\u0019}\u0001\u0007!\u0004C\u0003&}\u0001\u0007a\u0005C\u0003+}\u0001\u0007!\u0004C\u0003-}\u0001\u0007Q\u0006C\u00032}\u0001\u0007!\u0007C\u0003;}\u0001\u00071\bC\u0004J\u0001\t\u0007I\u0011\u0001&\u0002\u0011\u0005\u0003\u0006k\u0018(B\u001b\u0016+\u0012a\u0013\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bA\u0001\\1oO*\t\u0001+\u0001\u0003kCZ\f\u0017B\u0001\u0012N\u0011\u0019\u0019\u0006\u0001)A\u0005\u0017\u0006I\u0011\t\u0015)`\u001d\u0006kU\t\t\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u00031Ie*\u0013+`\u0005\u0006\u001b5j\u0014$G+\u00059\u0006C\u0001\u000fY\u0013\tIVDA\u0002J]RDaa\u0017\u0001!\u0002\u00139\u0016!D%O\u0013R{&)Q\"L\u001f\u001a3\u0005\u0005C\u0004^\u0001\t\u0007I\u0011\u0001,\u0002\u00175\u000b\u0005l\u0018\"B\u0007.{eI\u0012\u0005\u0007?\u0002\u0001\u000b\u0011B,\u0002\u00195\u000b\u0005l\u0018\"B\u0007.{eI\u0012\u0011\t\u000f\u0005\u0004!\u0019!C\u0001-\u0006YQ*\u0011-`\u001b\u0016\u001b6+Q$F\u0011\u0019\u0019\u0007\u0001)A\u0005/\u0006aQ*\u0011-`\u001b\u0016\u001b6+Q$FA!AQ\r\u0001EC\u0002\u0013\u0005a-\u0001\u0004dY&,g\u000e^\u000b\u0002OB\u0011\u0001N]\u0007\u0002S*\u00111A\u001b\u0006\u0003W2\f\u0001b]3sm&\u001cWm\u001d\u0006\u0003[:\f1!\u00199j\u0015\ty\u0007/\u0001\u0004h_><G.\u001a\u0006\u0002c\u0006\u00191m\\7\n\u0005ML'A\u0002)vEN,(\r\u0003\u0005v\u0001!\u0005\t\u0015)\u0003h\u0003\u001d\u0019G.[3oi\u0002Bqa\u001e\u0001C\u0002\u0013\u0005\u00010A\bqe>TWm\u0019;Gk2dg*Y7f+\u0005Q\u0002B\u0002>\u0001A\u0003%!$\u0001\tqe>TWm\u0019;Gk2dg*Y7fA!9A\u0010\u0001b\u0001\n\u0003A\u0018\u0001F:vEN\u001c'/\u001b9uS>tg)\u001e7m\u001d\u0006lW\r\u0003\u0004\u007f\u0001\u0001\u0006IAG\u0001\u0016gV\u00147o\u0019:jaRLwN\u001c$vY2t\u0015-\\3!\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007\tqa\u001c8Ti\u0006\u0014H\u000f\u0006\u0002\u0002\u0006A\u0019A$a\u0002\n\u0007\u0005%QD\u0001\u0003V]&$\bbBA\u0007\u0001\u0011\u0005\u00111A\u0001\be\u0016\u001cW-\u001b<f\u0011\u001d\t\t\u0002\u0001C!\u0003\u0007\taa\u001c8Ti>\u0004\b")
public class PubsubReceiver
extends Receiver<SparkPubsubMessage> {
    private final Option<String> topic;
    private final SparkGCPCredentials credential;
    private final boolean autoAcknowledge;
    private final String APP_NAME;
    private final int INIT_BACKOFF;
    private final int MAX_BACKOFF;
    private final int MAX_MESSAGE;
    private Pubsub client;
    private final String projectFullName;
    private final String subscriptionFullName;
    private volatile boolean bitmap$0;

    private Pubsub client$lzycompute() {
        PubsubReceiver pubsubReceiver = this;
        synchronized (pubsubReceiver) {
            if (!this.bitmap$0) {
                this.client = new Pubsub.Builder((HttpTransport)ConnectionUtils$.MODULE$.transport(), (JsonFactory)ConnectionUtils$.MODULE$.jacksonFactory(), (HttpRequestInitializer)new RetryHttpInitializer(this.credential.provider(), this.APP_NAME())).setApplicationName(this.APP_NAME()).build();
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.credential = null;
            return this.client;
        }
    }

    public String APP_NAME() {
        return this.APP_NAME;
    }

    public int INIT_BACKOFF() {
        return this.INIT_BACKOFF;
    }

    public int MAX_BACKOFF() {
        return this.MAX_BACKOFF;
    }

    public int MAX_MESSAGE() {
        return this.MAX_MESSAGE;
    }

    public Pubsub client() {
        return this.bitmap$0 ? this.client : this.client$lzycompute();
    }

    public String projectFullName() {
        return this.projectFullName;
    }

    public String subscriptionFullName() {
        return this.subscriptionFullName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onStart() {
        Object object2;
        Option<String> option = this.topic;
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
            object2 = BoxedUnit.UNIT;
        } else {
            Object object;
            Some some = (Some)option;
            String t = (String)some.x();
            Subscription sub = new Subscription();
            sub.setTopic(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/topics/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectFullName(), t})));
            try {
                object = this.client().projects().subscriptions().create(this.subscriptionFullName(), sub).execute();
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof GoogleJsonResponseException) {
                    BoxedUnit boxedUnit2;
                    GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)throwable2;
                    if (googleJsonResponseException.getDetails().getCode() == ConnectionUtils$.MODULE$.ALREADY_EXISTS()) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.reportError("Failed to create subscription", (Throwable)googleJsonResponseException);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                } else {
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option2.get();
                    this.reportError("Failed to create subscription", e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
            }
            object2 = object;
        }
        new Thread(this){
            private final /* synthetic */ PubsubReceiver $outer;

            public void run() {
                this.$outer.receive();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive() {
        pullRequest = new PullRequest().setMaxMessages(Predef$.MODULE$.int2Integer(this.MAX_MESSAGE())).setReturnImmediately(Predef$.MODULE$.boolean2Boolean(false));
        backoff = this.INIT_BACKOFF();
        while (true) {
            if (!this.isStopped()) ** GOTO lbl-1000
            return;
lbl-1000:
            // 1 sources

            {
                pullResponse = (PullResponse)this.client().projects().subscriptions().pull(this.subscriptionFullName(), pullRequest).execute();
                receivedMessages = pullResponse.getReceivedMessages();
                if (receivedMessages == null) {
                    v0 /* !! */  = BoxedUnit.UNIT;
                } else {
                    this.store(((LinearSeqLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(receivedMessages).asScala()).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * WARNING - void declaration
                         */
                        public final SparkPubsubMessage apply(ReceivedMessage x) {
                            void var2_2;
                            SparkPubsubMessage sm = new SparkPubsubMessage();
                            sm.message_$eq(x.getMessage());
                            sm.ackId_$eq(x.getAckId());
                            return var2_2;
                        }
                    }, List$.MODULE$.canBuildFrom())).iterator());
                    if (this.autoAcknowledge) {
                        ackRequest = new AcknowledgeRequest();
                        ackRequest.setAckIds((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(receivedMessages).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ReceivedMessage x) {
                                return x.getAckId();
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).asJava());
                        v0 /* !! */  = this.client().projects().subscriptions().acknowledge(this.subscriptionFullName(), ackRequest).execute();
                    } else {
                        v0 /* !! */  = BoxedUnit.UNIT;
                    }
                }
                backoff = this.INIT_BACKOFF();
                continue;
            }
            break;
        }
    }

    public void onStop() {
    }

    public PubsubReceiver(String project, Option<String> topic, String subscription, SparkGCPCredentials credential, StorageLevel storageLevel, boolean autoAcknowledge) {
        this.topic = topic;
        this.credential = credential;
        this.autoAcknowledge = autoAcknowledge;
        super(storageLevel);
        this.APP_NAME = "sparkstreaming-pubsub-receiver";
        this.INIT_BACKOFF = 100;
        this.MAX_BACKOFF = 10000;
        this.MAX_MESSAGE = 1000;
        this.projectFullName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"projects/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        this.subscriptionFullName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/subscriptions/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectFullName(), subscription}));
    }
}

