/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.transforms.io;

import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.examples.complete.datatokenization.options.DataTokenizationOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteResult;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizationBigTableIO {
    private static final Logger LOG = LoggerFactory.getLogger(TokenizationBigTableIO.class);
    private final DataTokenizationOptions options;

    public TokenizationBigTableIO(DataTokenizationOptions options) {
        this.options = options;
    }

    public PDone write(PCollection<Row> input, Schema schema) {
        return (PDone)((PCollection)((PCollection)input.apply("ConvertToBigTableFormat", (PTransform)ParDo.of((DoFn)new TransformToBigTableFormat(schema)))).apply("WriteToBigTable", (PTransform)BigtableIO.write().withProjectId(this.options.getBigTableProjectId()).withInstanceId(this.options.getBigTableInstanceId()).withTableId(this.options.getBigTableTableId()).withWriteResults())).apply("LogRowCount", (PTransform)new LogSuccessfulRows());
    }

    public static interface BigTableOptions
    extends PipelineOptions {
        @Description(value="Id of the project where the Cloud BigTable instance to write into is located.")
        public String getBigTableProjectId();

        public void setBigTableProjectId(String var1);

        @Description(value="Id of the Cloud BigTable instance to write into.")
        public String getBigTableInstanceId();

        public void setBigTableInstanceId(String var1);

        @Description(value="Id of the Cloud BigTable table to write into.")
        public String getBigTableTableId();

        public void setBigTableTableId(String var1);

        @Description(value="Column name to use as a key in Cloud BigTable.")
        public String getBigTableKeyColumnName();

        public void setBigTableKeyColumnName(String var1);

        @Description(value="Column family name to use in Cloud BigTable.")
        public String getBigTableColumnFamilyName();

        public void setBigTableColumnFamilyName(String var1);
    }

    static class LogSuccessfulRows
    extends PTransform<PCollection<BigtableWriteResult>, PDone> {
        LogSuccessfulRows() {
        }

        public PDone expand(PCollection<BigtableWriteResult> input) {
            input.apply((PTransform)ParDo.of((DoFn)new DoFn<BigtableWriteResult, Void>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element BigtableWriteResult in) {
                    LOG.info("Successfully wrote {} rows.", (Object)in.getRowsWritten());
                }
            }));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    static class TransformToBigTableFormat
    extends DoFn<Row, KV<ByteString, Iterable<Mutation>>> {
        private final Schema schema;

        TransformToBigTableFormat(Schema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element Row in, DoFn.OutputReceiver<KV<ByteString, Iterable<Mutation>>> out, DoFn.ProcessContext c) {
            DataTokenizationOptions options = (DataTokenizationOptions)c.getPipelineOptions().as(DataTokenizationOptions.class);
            Set mutations = this.schema.getFields().stream().map(Schema.Field::getName).filter(fieldName -> !Objects.equals(fieldName, options.getBigTableKeyColumnName())).map(fieldName -> Pair.of((Object)fieldName, (Object)in.getString(fieldName))).map(pair -> Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName(options.getBigTableColumnFamilyName()).setColumnQualifier(ByteString.copyFrom((String)((String)pair.getKey()), (Charset)StandardCharsets.UTF_8)).setValue(ByteString.copyFrom((String)((String)pair.getValue()), (Charset)StandardCharsets.UTF_8)).setTimestampMicros(System.currentTimeMillis() * 1000L).build()).build()).collect(Collectors.toSet());
            String columnName = in.getString(options.getBigTableKeyColumnName());
            if (columnName != null) {
                ByteString key = ByteString.copyFrom((String)columnName, (Charset)StandardCharsets.UTF_8);
                out.output((Object)KV.of((Object)key, mutations));
            }
        }
    }
}

