/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import com.google.auto.value.AutoValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_CsvConverters_LineToFailsafeJson;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_CsvConverters_ReadCsv;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.examples.complete.datatokenization.utils.SchemasUtils;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConverters {
    private static final Logger LOG = LoggerFactory.getLogger(CsvConverters.class);
    private static final String SUCCESSFUL_TO_JSON_COUNTER = "SuccessfulToJsonCounter";
    private static final String FAILED_TO_JSON_COUNTER = "FailedToJsonCounter";
    private static JsonParser jsonParser = new JsonParser();

    static String buildJsonString(@Nullable List<String> headers, List<String> values, @Nullable String jsonSchemaString) throws Exception {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        if (jsonSchemaString != null) {
            JsonArray jsonSchema = jsonParser.parse(jsonSchemaString).getAsJsonArray();
            writer.beginObject();
            block20: for (int i = 0; i < jsonSchema.size(); ++i) {
                JsonObject jsonObject = jsonSchema.get(i).getAsJsonObject();
                String type = jsonObject.get("type").getAsString().toUpperCase();
                writer.name(jsonObject.get("name").getAsString());
                switch (type) {
                    case "LONG": {
                        writer.value(Long.parseLong(values.get(i)));
                        continue block20;
                    }
                    case "DOUBLE": {
                        writer.value(Double.parseDouble(values.get(i)));
                        continue block20;
                    }
                    case "INTEGER": {
                        writer.value((long)Integer.parseInt(values.get(i)));
                        continue block20;
                    }
                    case "SHORT": {
                        writer.value((long)Short.parseShort(values.get(i)));
                        continue block20;
                    }
                    case "BYTE": {
                        writer.value((long)Byte.parseByte(values.get(i)));
                        continue block20;
                    }
                    case "FLOAT": {
                        writer.value(Float.parseFloat(values.get(i)));
                        continue block20;
                    }
                    case "TEXT": 
                    case "KEYWORD": 
                    case "STRING": {
                        writer.value(values.get(i));
                        continue block20;
                    }
                    default: {
                        LOG.error("Invalid data type, got: " + type);
                        throw new RuntimeException("Invalid data type, got: " + type);
                    }
                }
            }
            writer.endObject();
            writer.close();
            return stringWriter.toString();
        }
        if (headers != null) {
            writer.beginObject();
            for (int i = 0; i < headers.size(); ++i) {
                writer.name(headers.get(i));
                writer.value(values.get(i));
            }
            writer.endObject();
            writer.close();
            return stringWriter.toString();
        }
        LOG.error("No headers or schema specified");
        throw new RuntimeException("No headers or schema specified");
    }

    public static CSVFormat getCsvFormat(String formatString, @Nullable String delimiter) {
        CSVFormat format = CSVFormat.Predefined.valueOf((String)formatString).getFormat();
        if (delimiter != null) {
            return format.withDelimiter(delimiter.charAt(0));
        }
        return format;
    }

    static class GetCsvHeadersFn
    extends DoFn<FileIO.ReadableFile, String> {
        private final TupleTag<String> headerTag;
        private final TupleTag<String> linesTag;
        private CSVFormat csvFormat;

        GetCsvHeadersFn(TupleTag<String> headerTag, TupleTag<String> linesTag, String csvFormat, String delimiter) {
            this.headerTag = headerTag;
            this.linesTag = linesTag;
            this.csvFormat = CsvConverters.getCsvFormat(csvFormat, delimiter);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context, DoFn.MultiOutputReceiver outputReceiver) {
            String headers;
            FileIO.ReadableFile f = (FileIO.ReadableFile)context.element();
            List<String> records = null;
            String delimiter = String.valueOf(this.csvFormat.getDelimiter());
            try {
                String csvFileString = f.readFullyAsUTF8String();
                StringReader reader = new StringReader(csvFileString);
                CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)this.csvFormat.withFirstRecordAsHeader());
                records = parser.getRecords().stream().map(i -> String.join((CharSequence)delimiter, (Iterable<? extends CharSequence>)i)).collect(Collectors.toList());
                headers = String.join((CharSequence)delimiter, parser.getHeaderNames());
            }
            catch (IOException ioe) {
                LOG.error("Headers do not match, consistency cannot be guaranteed");
                throw new RuntimeException("Could not read Csv headers: " + ioe.getMessage());
            }
            outputReceiver.get(this.headerTag).output((Object)headers);
            records.forEach(r -> outputReceiver.get(this.linesTag).output(r));
        }
    }

    @AutoValue
    public static abstract class ReadCsv
    extends PTransform<PBegin, PCollectionTuple> {
        public static Builder newBuilder() {
            return new AutoValue_CsvConverters_ReadCsv.Builder();
        }

        public abstract String csvFormat();

        @Nullable
        public abstract String delimiter();

        public abstract Boolean hasHeaders();

        public abstract String inputFileSpec();

        public abstract TupleTag<String> headerTag();

        public abstract TupleTag<String> lineTag();

        public PCollectionTuple expand(PBegin input) {
            if (this.hasHeaders().booleanValue()) {
                return (PCollectionTuple)((PCollection)((PCollection)input.apply("MatchFilePattern", (PTransform)FileIO.match().filepattern(this.inputFileSpec()))).apply("ReadMatches", (PTransform)FileIO.readMatches())).apply("ReadCsvWithHeaders", (PTransform)ParDo.of((DoFn)new GetCsvHeadersFn(this.headerTag(), this.lineTag(), this.csvFormat(), this.delimiter())).withOutputTags(this.headerTag(), TupleTagList.of(this.lineTag())));
            }
            return PCollectionTuple.of(this.lineTag(), (PCollection)((PCollection)input.apply("ReadCsvWithoutHeaders", (PTransform)TextIO.read().from(this.inputFileSpec()))));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setCsvFormat(String var1);

            public abstract Builder setDelimiter(@Nullable String var1);

            public abstract Builder setHasHeaders(Boolean var1);

            public abstract Builder setInputFileSpec(String var1);

            public abstract Builder setHeaderTag(TupleTag<String> var1);

            public abstract Builder setLineTag(TupleTag<String> var1);

            abstract ReadCsv autoBuild();

            public ReadCsv build() {
                ReadCsv readCsv = this.autoBuild();
                Preconditions.checkArgument((readCsv.inputFileSpec() != null ? 1 : 0) != 0, (Object)"Input file spec must be provided.");
                Preconditions.checkArgument((readCsv.csvFormat() != null ? 1 : 0) != 0, (Object)"Csv format must not be null.");
                Preconditions.checkArgument((readCsv.hasHeaders() != null ? 1 : 0) != 0, (Object)"Header information must be provided.");
                return readCsv;
            }
        }
    }

    static class LineToFailsafeElementFn
    extends DoFn<String, FailsafeElement<String, String>> {
        LineToFailsafeElementFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            String message = (String)context.element();
            context.output(FailsafeElement.of(message, message));
        }
    }

    public static class FailsafeElementToJsonFn
    extends DoFn<FailsafeElement<String, String>, FailsafeElement<String, String>> {
        @Nullable
        public final String jsonSchema;
        public final String delimiter;
        public final TupleTag<FailsafeElement<String, String>> udfDeadletterTag;
        @Nullable
        private final PCollectionView<String> headersView;
        private Counter successCounter = Metrics.counter(FailsafeElementToJsonFn.class, (String)"SuccessfulToJsonCounter");
        private Counter failedCounter = Metrics.counter(FailsafeElementToJsonFn.class, (String)"FailedToJsonCounter");

        FailsafeElementToJsonFn(PCollectionView<String> headersView, String jsonSchema, String delimiter, TupleTag<FailsafeElement<String, String>> udfDeadletterTag) {
            this.headersView = headersView;
            this.jsonSchema = jsonSchema;
            this.delimiter = delimiter;
            this.udfDeadletterTag = udfDeadletterTag;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            FailsafeElement element = (FailsafeElement)context.element();
            List<String> header = null;
            if (this.headersView != null) {
                header = Arrays.asList(((String)context.sideInput(this.headersView)).split(this.delimiter));
            }
            List<String> record = Arrays.asList(((String)element.getOriginalPayload()).split(this.delimiter));
            try {
                String json = CsvConverters.buildJsonString(header, record, this.jsonSchema);
                context.output(FailsafeElement.of((String)element.getOriginalPayload(), json));
                this.successCounter.inc();
            }
            catch (Exception e) {
                this.failedCounter.inc();
                context.output(this.udfDeadletterTag, FailsafeElement.of(element).setErrorMessage(e.getMessage()).setStacktrace(Throwables.getStackTraceAsString((Throwable)e)));
            }
        }
    }

    @AutoValue
    public static abstract class LineToFailsafeJson
    extends PTransform<PCollectionTuple, PCollectionTuple> {
        public static Builder newBuilder() {
            return new AutoValue_CsvConverters_LineToFailsafeJson.Builder();
        }

        public abstract String delimiter();

        @Nullable
        public abstract String jsonSchemaPath();

        @Nullable
        public abstract String jsonSchema();

        public abstract TupleTag<String> headerTag();

        public abstract TupleTag<String> lineTag();

        public abstract TupleTag<FailsafeElement<String, String>> udfOutputTag();

        public abstract TupleTag<FailsafeElement<String, String>> udfDeadletterTag();

        public PCollectionTuple expand(PCollectionTuple lines) {
            PCollectionView headersView = null;
            PCollection lineFailsafeElements = (PCollection)lines.get(this.lineTag()).apply("LineToFailsafeElement", (PTransform)ParDo.of((DoFn)new LineToFailsafeElementFn()));
            String schemaPath = this.jsonSchemaPath();
            if (schemaPath != null || this.jsonSchema() != null) {
                String schema = schemaPath != null ? SchemasUtils.getGcsFileAsString(schemaPath) : this.jsonSchema();
                return (PCollectionTuple)lineFailsafeElements.apply("LineToDocumentUsingSchema", (PTransform)ParDo.of((DoFn)new FailsafeElementToJsonFn((PCollectionView<String>)headersView, schema, this.delimiter(), this.udfDeadletterTag())).withOutputTags(this.udfOutputTag(), TupleTagList.of(this.udfDeadletterTag())));
            }
            final PCollectionView finalHeadersView = headersView = (PCollectionView)((PCollection)lines.get(this.headerTag()).apply(Sample.any((long)1L))).apply((PTransform)View.asSingleton());
            lines.get(this.headerTag()).apply("CheckHeaderConsistency", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    String headers = (String)c.sideInput(finalHeadersView);
                    if (!((String)c.element()).equals(headers)) {
                        LOG.error("Headers do not match, consistency cannot be guaranteed");
                        throw new RuntimeException("Headers do not match, consistency cannot be guaranteed");
                    }
                }
            }).withSideInputs(new PCollectionView[]{finalHeadersView}));
            return (PCollectionTuple)lineFailsafeElements.apply("LineToDocumentWithHeaders", (PTransform)ParDo.of((DoFn)new FailsafeElementToJsonFn((PCollectionView<String>)headersView, this.jsonSchemaPath(), this.delimiter(), this.udfDeadletterTag())).withSideInputs(new PCollectionView[]{headersView}).withOutputTags(this.udfOutputTag(), TupleTagList.of(this.udfDeadletterTag())));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setDelimiter(String var1);

            public abstract Builder setJsonSchemaPath(String var1);

            public abstract Builder setJsonSchema(String var1);

            public abstract Builder setHeaderTag(TupleTag<String> var1);

            public abstract Builder setLineTag(TupleTag<String> var1);

            public abstract Builder setUdfOutputTag(TupleTag<FailsafeElement<String, String>> var1);

            public abstract Builder setUdfDeadletterTag(TupleTag<FailsafeElement<String, String>> var1);

            public abstract LineToFailsafeJson build();
        }
    }

    public static class DelimiterFactory
    implements DefaultValueFactory<String> {
        public String create(PipelineOptions options) {
            CSVFormat csvFormat = CsvConverters.getCsvFormat(((CsvPipelineOptions)options.as(CsvPipelineOptions.class)).getCsvFormat(), null);
            return String.valueOf(csvFormat.getDelimiter());
        }
    }

    public static interface CsvPipelineOptions
    extends PipelineOptions {
        @Description(value="Pattern to where data lives, ex: gs://mybucket/somepath/*.csv")
        public String getInputFileSpec();

        public void setInputFileSpec(String var1);

        @Description(value="If file(s) contain headers")
        public Boolean getContainsHeaders();

        public void setContainsHeaders(Boolean var1);

        @Description(value="Deadletter table for failed inserts in form: <project-id>:<dataset>.<table>")
        public String getDeadletterTable();

        public void setDeadletterTable(String var1);

        @Description(value="Delimiting character. Default: use delimiter provided in csvFormat")
        @Default.InstanceFactory(value=DelimiterFactory.class)
        public String getDelimiter();

        public void setDelimiter(String var1);

        @Description(value="Csv format according to Apache Commons CSV format. Default is: Apache Commons CSV default\nhttps://static.javadoc.io/org.apache.commons/commons-csv/1.7/org/apache/commons/csv/CSVFormat.html#DEFAULT\nMust match format names exactly found at: https://static.javadoc.io/org.apache.commons/commons-csv/1.7/org/apache/commons/csv/CSVFormat.Predefined.html")
        @Default.String(value="Default")
        public String getCsvFormat();

        public void setCsvFormat(String var1);

        @Description(value="Optional: Path to JSON schema, ex gs://path/to/schema. ")
        public String getJsonSchemaPath();

        public void setJsonSchemaPath(String var1);

        @Description(value="Set to true if number of files is in the tens of thousands. Default: false")
        @Default.Boolean(value=false)
        public Boolean getLargeNumFiles();

        public void setLargeNumFiles(Boolean var1);
    }
}

