/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_ErrorConverters_WriteErrorsToTextIO;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_ErrorConverters_WriteStringMessageErrors;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_ErrorConverters_WriteStringMessageErrorsAsCsv;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ErrorConverters {

    @AutoValue
    public static abstract class WriteErrorsToTextIO<T, V>
    extends PTransform<PCollection<FailsafeElement<T, V>>, PDone> {
        public static <T, V> Builder<T, V> newBuilder() {
            return new AutoValue_ErrorConverters_WriteErrorsToTextIO.Builder();
        }

        public abstract String errorWritePath();

        public abstract SerializableFunction<FailsafeElement<T, V>, String> translateFunction();

        public abstract @Nullable Duration windowDuration();

        public PDone expand(PCollection<FailsafeElement<T, V>> pCollection) {
            PCollection formattedErrorRows = (PCollection)pCollection.apply("GetFormattedErrorRow", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(this.translateFunction()));
            if (pCollection.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                if (this.windowDuration() == null) {
                    throw new RuntimeException("Unbounded input requires window interval to be set");
                }
                return (PDone)((PCollection)formattedErrorRows.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)this.windowDuration())))).apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1).withWindowedWrites());
            }
            return (PDone)formattedErrorRows.apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1));
        }

        @AutoValue.Builder
        public static abstract class Builder<T, V> {
            public abstract Builder<T, V> setErrorWritePath(String var1);

            public abstract Builder<T, V> setTranslateFunction(SerializableFunction<FailsafeElement<T, V>, String> var1);

            public abstract Builder<T, V> setWindowDuration(@Nullable Duration var1);

            abstract SerializableFunction<FailsafeElement<T, V>, String> translateFunction();

            abstract WriteErrorsToTextIO<T, V> autoBuild();

            public WriteErrorsToTextIO<T, V> build() {
                Preconditions.checkNotNull(this.translateFunction(), (Object)"translateFunction is required.");
                return this.autoBuild();
            }
        }
    }

    public static class FailedStringToTableRowFn
    extends DoFn<FailsafeElement<String, String>, TableRow> {
        private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS");

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            FailsafeElement failsafeElement = (FailsafeElement)context.element();
            String message = (String)failsafeElement.getOriginalPayload();
            String timestamp = TIMESTAMP_FORMATTER.print((ReadableInstant)context.timestamp().toDateTime(DateTimeZone.UTC));
            TableRow failedRow = new TableRow().set("timestamp", (Object)timestamp).set("errorMessage", (Object)failsafeElement.getErrorMessage()).set("stacktrace", (Object)failsafeElement.getStacktrace());
            if (message != null) {
                failedRow.set("payloadString", (Object)message).set("payloadBytes", (Object)message.getBytes(StandardCharsets.UTF_8));
            }
            context.output((Object)failedRow);
        }
    }

    @AutoValue
    public static abstract class WriteStringMessageErrors
    extends PTransform<PCollection<FailsafeElement<String, String>>, WriteResult> {
        public static Builder newBuilder() {
            return new AutoValue_ErrorConverters_WriteStringMessageErrors.Builder();
        }

        public abstract String getErrorRecordsTable();

        public abstract String getErrorRecordsTableSchema();

        public WriteResult expand(PCollection<FailsafeElement<String, String>> failedRecords) {
            return (WriteResult)((PCollection)failedRecords.apply("FailedRecordToTableRow", (PTransform)ParDo.of((DoFn)new FailedStringToTableRowFn()))).apply("WriteFailedRecordsToBigQuery", (PTransform)BigQueryIO.writeTableRows().to(this.getErrorRecordsTable()).withJsonSchema(this.getErrorRecordsTableSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setErrorRecordsTable(String var1);

            public abstract Builder setErrorRecordsTableSchema(String var1);

            public abstract WriteStringMessageErrors build();
        }
    }

    public static class FailedStringToCsvRowFn
    extends DoFn<FailsafeElement<String, String>, String> {
        private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS");
        private final String csvDelimiter;

        public FailedStringToCsvRowFn(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        public FailedStringToCsvRowFn() {
            this.csvDelimiter = ",";
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            FailsafeElement failsafeElement = (FailsafeElement)context.element();
            ArrayList<String> outputRow = new ArrayList<String>();
            String message = (String)failsafeElement.getOriginalPayload();
            String timestamp = TIMESTAMP_FORMATTER.print((ReadableInstant)context.timestamp().toDateTime(DateTimeZone.UTC));
            outputRow.add(timestamp);
            outputRow.add((String)MoreObjects.firstNonNull((Object)failsafeElement.getErrorMessage(), (Object)""));
            if (message != null) {
                outputRow.add(message);
            }
            context.output((Object)String.join((CharSequence)this.csvDelimiter, outputRow));
        }
    }

    @AutoValue
    public static abstract class WriteStringMessageErrorsAsCsv
    extends PTransform<PCollection<FailsafeElement<String, String>>, PDone> {
        public static Builder newBuilder() {
            return new AutoValue_ErrorConverters_WriteStringMessageErrorsAsCsv.Builder();
        }

        public abstract String errorWritePath();

        public abstract String csvDelimiter();

        public abstract @Nullable Duration windowDuration();

        public PDone expand(PCollection<FailsafeElement<String, String>> pCollection) {
            PCollection formattedErrorRows = (PCollection)pCollection.apply("GetFormattedErrorRow", (PTransform)ParDo.of((DoFn)new FailedStringToCsvRowFn(this.csvDelimiter())));
            if (pCollection.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                if (this.windowDuration() != null) {
                    formattedErrorRows = (PCollection)formattedErrorRows.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)this.windowDuration())));
                }
                return (PDone)formattedErrorRows.apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1).withWindowedWrites());
            }
            return (PDone)formattedErrorRows.apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setErrorWritePath(String var1);

            public abstract Builder setCsvDelimiter(String var1);

            public abstract Builder setWindowDuration(@Nullable Duration var1);

            public abstract WriteStringMessageErrorsAsCsv build();
        }
    }
}

