/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FailsafeElementCoder<OriginalT, CurrentT>
extends CustomCoder<FailsafeElement<OriginalT, CurrentT>> {
    private static final NullableCoder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private final Coder<OriginalT> originalPayloadCoder;
    private final Coder<CurrentT> currentPayloadCoder;

    private FailsafeElementCoder(Coder<OriginalT> originalPayloadCoder, Coder<CurrentT> currentPayloadCoder) {
        this.originalPayloadCoder = originalPayloadCoder;
        this.currentPayloadCoder = currentPayloadCoder;
    }

    public Coder<OriginalT> getOriginalPayloadCoder() {
        return this.originalPayloadCoder;
    }

    public Coder<CurrentT> getCurrentPayloadCoder() {
        return this.currentPayloadCoder;
    }

    public static <OriginalT, CurrentT> FailsafeElementCoder<OriginalT, CurrentT> of(Coder<OriginalT> originalPayloadCoder, Coder<CurrentT> currentPayloadCoder) {
        return new FailsafeElementCoder<OriginalT, CurrentT>(originalPayloadCoder, currentPayloadCoder);
    }

    public void encode(FailsafeElement<OriginalT, CurrentT> value, OutputStream outStream) throws IOException {
        if (value == null) {
            throw new CoderException("The FailsafeElementCoder cannot encode a null object!");
        }
        this.originalPayloadCoder.encode(value.getOriginalPayload(), outStream);
        this.currentPayloadCoder.encode(value.getPayload(), outStream);
        STRING_CODER.encode((Object)value.getErrorMessage(), outStream);
        STRING_CODER.encode((Object)value.getStacktrace(), outStream);
    }

    public FailsafeElement<OriginalT, CurrentT> decode(InputStream inStream) throws IOException {
        Object originalPayload = this.originalPayloadCoder.decode(inStream);
        Object currentPayload = this.currentPayloadCoder.decode(inStream);
        @Nullable String errorMessage = (String)STRING_CODER.decode(inStream);
        @Nullable String stacktrace = (String)STRING_CODER.decode(inStream);
        return FailsafeElement.of(originalPayload, currentPayload).setErrorMessage(errorMessage).setStacktrace(stacktrace);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.originalPayloadCoder, this.currentPayloadCoder);
    }

    public TypeDescriptor<FailsafeElement<OriginalT, CurrentT>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<FailsafeElement<OriginalT, CurrentT>>(){}.where(new TypeParameter<OriginalT>(){}, this.originalPayloadCoder.getEncodedTypeDescriptor()).where(new TypeParameter<CurrentT>(){}, this.currentPayloadCoder.getEncodedTypeDescriptor());
    }
}

