/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.injector;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.PubsubScopes;
import com.google.api.services.pubsub.model.Topic;
import java.io.IOException;
import java.util.Collection;
import org.apache.beam.examples.complete.game.injector.RetryHttpInitializerWrapper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class InjectorUtils {
    private static final String APP_NAME = "injector";

    InjectorUtils() {
    }

    public static Pubsub getClient(HttpTransport httpTransport, JsonFactory jsonFactory) throws IOException {
        Preconditions.checkNotNull((Object)httpTransport);
        Preconditions.checkNotNull((Object)jsonFactory);
        GoogleCredential credential = GoogleCredential.getApplicationDefault((HttpTransport)httpTransport, (JsonFactory)jsonFactory);
        if (credential.createScopedRequired()) {
            credential = credential.createScoped((Collection)PubsubScopes.all());
        }
        if (credential.getClientAuthentication() != null) {
            System.out.println("\n***Warning! You are not using service account credentials to authenticate.\nYou need to use service account credentials for this example,\nsince user-level credentials do not have enough pubsub quota,\nand so you will run out of PubSub quota very quickly.\nSee https://developers.google.com/identity/protocols/application-default-credentials.");
            System.exit(1);
        }
        RetryHttpInitializerWrapper initializer = new RetryHttpInitializerWrapper((Credential)credential);
        return new Pubsub.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)initializer).setApplicationName(APP_NAME).build();
    }

    public static Pubsub getClient() throws IOException {
        return InjectorUtils.getClient(Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    public static String getFullyQualifiedTopicName(String project, String topic) {
        return String.format("projects/%s/topics/%s", project, topic);
    }

    public static void createTopic(Pubsub client, String fullTopicName) throws IOException {
        block2: {
            System.out.println("fullTopicName " + fullTopicName);
            try {
                client.projects().topics().get(fullTopicName).execute();
            }
            catch (GoogleJsonResponseException e) {
                if (e.getStatusCode() != 404) break block2;
                Topic topic = (Topic)client.projects().topics().create(fullTopicName, new Topic()).execute();
                System.out.printf("Topic %s was created.%n", topic.getName());
            }
        }
    }
}

