/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

public class WriteToBigQuery<InputT>
extends PTransform<PCollection<InputT>, PDone> {
    protected String projectId;
    protected String datasetId;
    protected String tableName;
    protected Map<String, FieldInfo<InputT>> fieldInfo;

    public WriteToBigQuery() {
    }

    public WriteToBigQuery(String projectId, String datasetId, String tableName, Map<String, FieldInfo<InputT>> fieldInfo) {
        this.projectId = projectId;
        this.datasetId = datasetId;
        this.tableName = tableName;
        this.fieldInfo = fieldInfo;
    }

    protected TableSchema getSchema() {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        for (Map.Entry<String, FieldInfo<InputT>> entry : this.fieldInfo.entrySet()) {
            String key = entry.getKey();
            FieldInfo<InputT> fcnInfo = entry.getValue();
            String bqType = fcnInfo.getFieldType();
            fields.add(new TableFieldSchema().setName(key).setType(bqType));
        }
        return new TableSchema().setFields(fields);
    }

    public PDone expand(PCollection<InputT> teamAndScore) {
        ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)BigQueryIO.writeTableRows().to(WriteToBigQuery.getTable(this.projectId, this.datasetId, this.tableName)).withSchema(this.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        return PDone.in((Pipeline)teamAndScore.getPipeline());
    }

    static TableReference getTable(String projectId, String datasetId, String tableName) {
        TableReference table = new TableReference();
        table.setDatasetId(datasetId);
        table.setProjectId(projectId);
        table.setTableId(tableName);
        return table;
    }

    protected class BuildRowFn
    extends DoFn<InputT, TableRow> {
        protected BuildRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            TableRow row = new TableRow();
            for (Map.Entry entry : WriteToBigQuery.this.fieldInfo.entrySet()) {
                String key = entry.getKey();
                FieldInfo fcnInfo = entry.getValue();
                FieldFn fcn = fcnInfo.getFieldFn();
                row.set(key, fcn.apply(c, window));
            }
            c.output((Object)row);
        }
    }

    public static class FieldInfo<InputT>
    implements Serializable {
        private String fieldType;
        private FieldFn<InputT> fieldFn;

        public FieldInfo(String fieldType, FieldFn<InputT> fieldFn) {
            this.fieldType = fieldType;
            this.fieldFn = fieldFn;
        }

        String getFieldType() {
            return this.fieldType;
        }

        FieldFn<InputT> getFieldFn() {
            return this.fieldFn;
        }
    }

    public static interface FieldFn<InputT>
    extends Serializable {
        public Object apply(DoFn.ProcessContext var1, BoundedWindow var2);
    }
}

