/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets.transforms.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;

class BigQueryMyData {
    BigQueryMyData() {
    }

    @DefaultCoder(value=AvroCoder.class)
    static class MyData {
        String myString;
        Long myInt64;
        Double myFloat64;
        BigDecimal myNumeric;
        Boolean myBoolean;
        byte[] myBytes;
        String myDate;
        String myDateTime;
        String myTime;
        String myTimestamp;
        String myGeography;
        List<Long> myArray;
        MyStruct myStruct;

        MyData() {
        }

        public static MyData fromTableRow(TableRow row) {
            MyData data = new MyData();
            data.myString = (String)row.get((Object)"string_field");
            data.myInt64 = Long.parseLong((String)row.get((Object)"int64_field"));
            data.myFloat64 = (Double)row.get((Object)"float64_field");
            data.myNumeric = new BigDecimal((String)row.get((Object)"numeric_field"));
            data.myBoolean = (Boolean)row.get((Object)"bool_field");
            data.myBytes = Base64.getDecoder().decode((String)row.get((Object)"bytes_field"));
            data.myDate = LocalDate.parse((String)row.get((Object)"date_field")).toString();
            data.myDateTime = LocalDateTime.parse((String)row.get((Object)"datetime_field")).toString();
            data.myTime = LocalTime.parse((String)row.get((Object)"time_field")).toString();
            data.myTimestamp = Instant.parse(((String)row.get((Object)"timestamp_field")).replace(" UTC", "Z").replace(" ", "T")).toString();
            data.myGeography = (String)row.get((Object)"geography_field");
            data.myArray = ((List)row.get((Object)"array_field")).stream().map(element -> Long.parseLong((String)element)).collect(Collectors.toList());
            Map structValues = (Map)row.get((Object)"struct_field");
            data.myStruct = new MyStruct();
            data.myStruct.stringValue = (String)structValues.get("string_value");
            data.myStruct.int64Value = Long.parseLong((String)structValues.get("int64_value"));
            return data;
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    static class MyStruct {
        String stringValue;
        Long int64Value;

        MyStruct() {
        }
    }
}

