/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.transforms.io;

import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.examples.complete.datatokenization.options.DataTokenizationOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteResult;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizationBigTableIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TokenizationBigTableIO.class);
    private final @UnknownKeyFor @NonNull @Initialized DataTokenizationOptions options;

    public TokenizationBigTableIO(@UnknownKeyFor @NonNull @Initialized DataTokenizationOptions options) {
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized PDone write(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return (PDone)((PCollection)((PCollection)input.apply("ConvertToBigTableFormat", (PTransform)ParDo.of((DoFn)new TransformToBigTableFormat(schema)))).apply("WriteToBigTable", (PTransform)BigtableIO.write().withProjectId(this.options.getBigTableProjectId()).withInstanceId(this.options.getBigTableInstanceId()).withTableId(this.options.getBigTableTableId()).withWriteResults())).apply("LogRowCount", (PTransform)new LogSuccessfulRows());
    }

    public static interface BigTableOptions
    extends PipelineOptions {
        @Description(value="Id of the project where the Cloud BigTable instance to write into is located.")
        public @UnknownKeyFor @NonNull @Initialized String getBigTableProjectId();

        public void setBigTableProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Id of the Cloud BigTable instance to write into.")
        public @UnknownKeyFor @NonNull @Initialized String getBigTableInstanceId();

        public void setBigTableInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Id of the Cloud BigTable table to write into.")
        public @UnknownKeyFor @NonNull @Initialized String getBigTableTableId();

        public void setBigTableTableId(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Column name to use as a key in Cloud BigTable.")
        public @UnknownKeyFor @NonNull @Initialized String getBigTableKeyColumnName();

        public void setBigTableKeyColumnName(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Column family name to use in Cloud BigTable.")
        public @UnknownKeyFor @NonNull @Initialized String getBigTableColumnFamilyName();

        public void setBigTableColumnFamilyName(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    static class LogSuccessfulRows
    extends PTransform<PCollection<BigtableWriteResult>, PDone> {
        LogSuccessfulRows() {
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigtableWriteResult> input) {
            input.apply((PTransform)ParDo.of((DoFn)new DoFn<BigtableWriteResult, Void>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized BigtableWriteResult in) {
                    LOG.info("Successfully wrote {} rows.", (Object)in.getRowsWritten());
                }
            }));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    static class TransformToBigTableFormat
    extends DoFn<Row, KV<ByteString, Iterable<Mutation>>> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;

        TransformToBigTableFormat(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row in, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>>> out, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            DataTokenizationOptions options = (DataTokenizationOptions)c.getPipelineOptions().as(DataTokenizationOptions.class);
            Set mutations = this.schema.getFields().stream().map(Schema.Field::getName).filter(fieldName -> !Objects.equals(fieldName, options.getBigTableKeyColumnName())).map(fieldName -> Pair.of((Object)fieldName, (Object)in.getString(fieldName))).map(pair -> Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName(options.getBigTableColumnFamilyName()).setColumnQualifier(ByteString.copyFrom((String)((String)pair.getKey()), (Charset)StandardCharsets.UTF_8)).setValue(ByteString.copyFrom((String)((String)pair.getValue()), (Charset)StandardCharsets.UTF_8)).setTimestampMicros(System.currentTimeMillis() * 1000L).build()).build()).collect(Collectors.toSet());
            String columnName = in.getString(options.getBigTableKeyColumnName());
            if (columnName != null) {
                ByteString key = ByteString.copyFrom((String)columnName, (Charset)StandardCharsets.UTF_8);
                out.output((Object)KV.of((Object)key, mutations));
            }
        }
    }
}

