/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Collections;
import java.util.HashMap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KafkaWordCountAvro {
    static final @UnknownKeyFor @NonNull @Initialized String TOKENIZER_PATTERN = "[^\\p{L}]+";

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        HashMap<String, String> consumerConfig = new HashMap<String, String>();
        consumerConfig.put("auto.offset.reset", "earliest");
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply(KafkaIO.read().withBootstrapServers("kafka_server:9092").withTopicPartitions(Collections.singletonList(new TopicPartition("dataset", 0))).withKeyDeserializer(LongDeserializer.class).withValueDeserializer(StringDeserializer.class).withConsumerConfigUpdates(consumerConfig).withMaxNumRecords(5L).withoutMetadata())).apply((PTransform)Values.create())).apply("ExtractWords", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                for (String word : ((String)c.element()).split(KafkaWordCountAvro.TOKENIZER_PATTERN, 0)) {
                    if (word.isEmpty()) continue;
                    c.output((Object)word);
                }
            }
        }))).apply(Count.perElement())).apply("FormatResults", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<String, Long>, String>(){

            public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> input) {
                System.out.printf("key: %s, value: %d%n", input.getKey(), input.getValue());
                return (String)input.getKey() + ": " + input.getValue();
            }
        }))).apply((PTransform)TextIO.write().to("word-counts"));
        p.run().waitUntilFinish();
    }
}

