/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringDelegateCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfIdf {
    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized URI> listInputDocuments(@UnknownKeyFor @NonNull @Initialized Options options) throws @UnknownKeyFor @NonNull @Initialized URISyntaxException, @UnknownKeyFor @NonNull @Initialized IOException {
        HashSet<URI> uris;
        block3: {
            URI absoluteUri;
            block2: {
                URI baseUri = new URI(options.getInput());
                absoluteUri = baseUri.getScheme() != null ? baseUri : new URI("file", baseUri.getAuthority(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
                uris = new HashSet<URI>();
                if (!"file".equals(absoluteUri.getScheme())) break block2;
                File directory = new File(absoluteUri);
                for (String entry : (String[])Optional.fromNullable((Object)directory.list()).or((Object)new String[0])) {
                    File path = new File(directory, entry);
                    uris.add(path.toURI());
                }
                break block3;
            }
            if (!"gs".equals(absoluteUri.getScheme())) break block3;
            GcsUtil gcsUtil = ((GcsOptions)options.as(GcsOptions.class)).getGcsUtil();
            URI gcsUriGlob = new URI(absoluteUri.getScheme(), absoluteUri.getAuthority(), absoluteUri.getPath() + "*", absoluteUri.getQuery(), absoluteUri.getFragment());
            for (GcsPath entry : gcsUtil.expand(GcsPath.fromUri((URI)gcsUriGlob))) {
                uris.add(entry.toUri());
            }
        }
        return uris;
    }

    static void runTfIdf(@UnknownKeyFor @NonNull @Initialized Options options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        pipeline.getCoderRegistry().registerCoderForClass(URI.class, (Coder)StringDelegateCoder.of(URI.class));
        ((PCollection)((PCollection)pipeline.apply((PTransform)new ReadDocuments(TfIdf.listInputDocuments(options)))).apply((PTransform)new ComputeTfIdf())).apply((PTransform)new WriteTfIdf(options.getOutput()));
        pipeline.run().waitUntilFinish();
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        TfIdf.runTfIdf(options);
    }

    public static class WriteTfIdf
    extends PTransform<PCollection<KV<String, KV<URI, Double>>>, PDone> {
        private @UnknownKeyFor @NonNull @Initialized String output;

        public WriteTfIdf(@UnknownKeyFor @NonNull @Initialized String output) {
            this.output = output;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Double>>> wordToUriAndTfIdf) {
            return (PDone)((PCollection)wordToUriAndTfIdf.apply("Format", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, KV<URI, Double>>, String>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output((Object)String.format("%s,\t%s,\t%f", ((KV)c.element()).getKey(), ((KV)((KV)c.element()).getValue()).getKey(), ((KV)((KV)c.element()).getValue()).getValue()));
                }
            }))).apply((PTransform)TextIO.write().to(this.output).withSuffix(".csv"));
        }
    }

    public static class ComputeTfIdf
    extends PTransform<PCollection<KV<URI, String>>, PCollection<KV<String, KV<URI, Double>>>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ComputeTfIdf.class);

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized Double>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized String>> uriToContent) {
            final PCollectionView totalDocuments = (PCollectionView)((PCollection)((PCollection)((PCollection)uriToContent.apply("GetURIs", (PTransform)Keys.create())).apply("DistinctDocs", (PTransform)Distinct.create())).apply(Count.globally())).apply((PTransform)View.asSingleton());
            PCollection uriToWords = (PCollection)uriToContent.apply("SplitWords", (PTransform)ParDo.of((DoFn)new DoFn<KV<URI, String>, KV<URI, String>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    URI uri = (URI)((KV)c.element()).getKey();
                    String line = (String)((KV)c.element()).getValue();
                    for (String word : line.split("\\W+", -1)) {
                        if ("love".equalsIgnoreCase(word)) {
                            LOG.info("Found {}", (Object)word.toLowerCase());
                        }
                        if (word.isEmpty()) continue;
                        c.output((Object)KV.of((Object)uri, (Object)word.toLowerCase()));
                    }
                }
            }));
            PCollection wordToDocCount = (PCollection)((PCollection)((PCollection)uriToWords.apply("DistinctWords", (PTransform)Distinct.create())).apply((PTransform)Values.create())).apply("CountDocs", Count.perElement());
            PCollection uriToWordTotal = (PCollection)((PCollection)uriToWords.apply("GetURIs2", (PTransform)Keys.create())).apply("CountWords", Count.perElement());
            PCollection uriAndWordToCount = (PCollection)uriToWords.apply("CountWordDocPairs", Count.perElement());
            PCollection uriToWordAndCount = (PCollection)uriAndWordToCount.apply("ShiftKeys", (PTransform)ParDo.of((DoFn)new DoFn<KV<KV<URI, String>, Long>, KV<URI, KV<String, Long>>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    URI uri = (URI)((KV)((KV)c.element()).getKey()).getKey();
                    String word = (String)((KV)((KV)c.element()).getKey()).getValue();
                    Long occurrences = (Long)((KV)c.element()).getValue();
                    c.output((Object)KV.of((Object)uri, (Object)KV.of((Object)word, (Object)occurrences)));
                }
            }));
            final TupleTag wordTotalsTag = new TupleTag();
            final TupleTag wordCountsTag = new TupleTag();
            KeyedPCollectionTuple coGbkInput = KeyedPCollectionTuple.of((TupleTag)wordTotalsTag, (PCollection)uriToWordTotal).and(wordCountsTag, uriToWordAndCount);
            PCollection uriToWordAndCountAndTotal = (PCollection)coGbkInput.apply("CoGroupByUri", (PTransform)CoGroupByKey.create());
            PCollection wordToUriAndTf = (PCollection)uriToWordAndCountAndTotal.apply("ComputeTermFrequencies", (PTransform)ParDo.of((DoFn)new DoFn<KV<URI, CoGbkResult>, KV<String, KV<URI, Double>>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    URI uri = (URI)((KV)c.element()).getKey();
                    Long wordTotal = (Long)((CoGbkResult)((KV)c.element()).getValue()).getOnly(wordTotalsTag);
                    for (KV wordAndCount : ((CoGbkResult)((KV)c.element()).getValue()).getAll(wordCountsTag)) {
                        String word = (String)wordAndCount.getKey();
                        Long wordCount = (Long)wordAndCount.getValue();
                        Double termFrequency = wordCount.doubleValue() / wordTotal.doubleValue();
                        c.output((Object)KV.of((Object)word, (Object)KV.of((Object)uri, (Object)termFrequency)));
                    }
                }
            }));
            PCollection wordToDf = (PCollection)wordToDocCount.apply("ComputeDocFrequencies", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, Long>, KV<String, Double>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    String word = (String)((KV)c.element()).getKey();
                    Long documentCount = (Long)((KV)c.element()).getValue();
                    Long documentTotal = (Long)c.sideInput(totalDocuments);
                    Double documentFrequency = documentCount.doubleValue() / documentTotal.doubleValue();
                    c.output((Object)KV.of((Object)word, (Object)documentFrequency));
                }
            }).withSideInputs(new PCollectionView[]{totalDocuments}));
            final TupleTag tfTag = new TupleTag();
            final TupleTag dfTag = new TupleTag();
            PCollection wordToUriAndTfAndDf = (PCollection)KeyedPCollectionTuple.of((TupleTag)tfTag, (PCollection)wordToUriAndTf).and(dfTag, wordToDf).apply((PTransform)CoGroupByKey.create());
            PCollection wordToUriAndTfIdf = (PCollection)wordToUriAndTfAndDf.apply("ComputeTfIdf", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, CoGbkResult>, KV<String, KV<URI, Double>>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    String word = (String)((KV)c.element()).getKey();
                    Double df = (Double)((CoGbkResult)((KV)c.element()).getValue()).getOnly(dfTag);
                    for (KV uriAndTf : ((CoGbkResult)((KV)c.element()).getValue()).getAll(tfTag)) {
                        URI uri = (URI)uriAndTf.getKey();
                        Double tf = (Double)uriAndTf.getValue();
                        Double tfIdf = tf * Math.log(1.0 / df);
                        c.output((Object)KV.of((Object)word, (Object)KV.of((Object)uri, (Object)tfIdf)));
                    }
                }
            }));
            return wordToUriAndTfIdf;
        }
    }

    public static class ReadDocuments
    extends PTransform<PBegin, PCollection<KV<URI, String>>> {
        private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized URI> uris;

        public ReadDocuments(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized URI> uris) {
            this.uris = uris;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized URI, @UnknownKeyFor @NonNull @Initialized String>> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Pipeline pipeline = input.getPipeline();
            PCollectionList urisToLines = PCollectionList.empty((Pipeline)pipeline);
            for (URI uri : this.uris) {
                String uriString = "file".equals(uri.getScheme()) ? new File(uri).getPath() : uri.toString();
                PCollection oneUriToLines = ((PCollection)((PCollection)pipeline.apply("TextIO.Read(" + uriString + ")", (PTransform)TextIO.read().from(uriString))).apply("WithKeys(" + uriString + ")", (PTransform)WithKeys.of((Object)uri))).setCoder((Coder)KvCoder.of((Coder)StringDelegateCoder.of(URI.class), (Coder)StringUtf8Coder.of()));
                urisToLines = urisToLines.and(oneUriToLines);
            }
            return (PCollection)urisToLines.apply((PTransform)Flatten.pCollections());
        }
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Path to the directory or GCS prefix containing files to read from")
        @Default.String(value="gs://apache-beam-samples/shakespeare/")
        public @UnknownKeyFor @NonNull @Initialized String getInput();

        public void setInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Prefix of output URI to write to")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

