/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.injector;

import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PubsubMessage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.beam.examples.complete.game.injector.InjectorUtils;
import org.apache.beam.examples.complete.game.utils.GameConstants;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

class Injector {
    private static @UnknownKeyFor @NonNull @Initialized Pubsub pubsub;
    private static @UnknownKeyFor @NonNull @Initialized Random random;
    private static @UnknownKeyFor @NonNull @Initialized String topic;
    private static @UnknownKeyFor @NonNull @Initialized String project;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_QPS = 800;
    private static final @UnknownKeyFor @NonNull @Initialized int QPS_RANGE = 200;
    private static final @UnknownKeyFor @NonNull @Initialized int THREAD_SLEEP_MS = 500;
    private static final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized String> COLORS;
    private static final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized String> ANIMALS;
    private static @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized TeamInfo> liveTeams;
    private static final @UnknownKeyFor @NonNull @Initialized int NUM_ROBOTS = 20;
    private static final @UnknownKeyFor @NonNull @Initialized int ROBOT_PROBABILITY = 3;
    private static final @UnknownKeyFor @NonNull @Initialized int NUM_LIVE_TEAMS = 15;
    private static final @UnknownKeyFor @NonNull @Initialized int BASE_MEMBERS_PER_TEAM = 5;
    private static final @UnknownKeyFor @NonNull @Initialized int MEMBERS_PER_TEAM = 15;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_SCORE = 20;
    private static final @UnknownKeyFor @NonNull @Initialized int LATE_DATA_RATE = 600;
    private static final @UnknownKeyFor @NonNull @Initialized int BASE_DELAY_IN_MILLIS = 300000;
    private static final @UnknownKeyFor @NonNull @Initialized int FUZZY_DELAY_IN_MILLIS = 300000;
    private static final @UnknownKeyFor @NonNull @Initialized int BASE_TEAM_EXPIRATION_TIME_IN_MINS = 20;
    private static final @UnknownKeyFor @NonNull @Initialized int TEAM_EXPIRATION_TIME_IN_MINS = 20;

    Injector() {
    }

    private static @UnknownKeyFor @NonNull @Initialized String randomElement(@UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized String> list) {
        int index = random.nextInt(list.size());
        return list.get(index);
    }

    private static @UnknownKeyFor @NonNull @Initialized TeamInfo randomTeam(@UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized TeamInfo> list) {
        int index = random.nextInt(list.size());
        TeamInfo team = list.get(index);
        long currTime = System.currentTimeMillis();
        if (team.getEndTimeInMillis() < currTime || team.numMembers() == 0) {
            System.out.println("\nteam " + team + " is too old; replacing.");
            System.out.println("start time: " + team.getStartTimeInMillis() + ", end time: " + team.getEndTimeInMillis() + ", current time:" + currTime);
            Injector.removeTeam(index);
            return Injector.addLiveTeam();
        }
        return team;
    }

    private static synchronized @UnknownKeyFor @NonNull @Initialized TeamInfo addLiveTeam() {
        String teamName = Injector.randomElement(COLORS) + Injector.randomElement(ANIMALS);
        String robot = null;
        if (random.nextInt(3) == 0) {
            robot = "Robot-" + random.nextInt(20);
        }
        TeamInfo newTeam = new TeamInfo(teamName, System.currentTimeMillis(), robot);
        liveTeams.add(newTeam);
        System.out.println("[+" + newTeam + "]");
        return newTeam;
    }

    private static synchronized void removeTeam(@UnknownKeyFor @NonNull @Initialized int teamIndex) {
        TeamInfo removedTeam = liveTeams.remove(teamIndex);
        System.out.println("[-" + removedTeam + "]");
    }

    private static @UnknownKeyFor @NonNull @Initialized String generateEvent(@UnknownKeyFor @NonNull @Initialized Long currTime, @UnknownKeyFor @NonNull @Initialized int delayInMillis) {
        TeamInfo team = Injector.randomTeam(liveTeams);
        String teamName = team.getTeamName();
        int parseErrorRate = 900000;
        String robot = team.getRobot();
        String user = robot != null ? (random.nextInt(team.numMembers() / 2) == 0 ? robot : team.getRandomUser()) : team.getRandomUser();
        String event = user + "," + teamName + "," + random.nextInt(20);
        if (random.nextInt(900000) == 0) {
            System.out.println("Introducing a parse error.");
            event = "THIS LINE REPRESENTS CORRUPT DATA AND WILL CAUSE A PARSE ERROR";
        }
        return Injector.addTimeInfoToEvent(event, currTime, delayInMillis);
    }

    private static @UnknownKeyFor @NonNull @Initialized String addTimeInfoToEvent(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized Long currTime, @UnknownKeyFor @NonNull @Initialized int delayInMillis) {
        String eventTimeString = Long.toString((currTime - (long)delayInMillis) / 1000L * 1000L);
        String dateString = GameConstants.DATE_TIME_FORMATTER.print(currTime.longValue());
        message = message + "," + eventTimeString + "," + dateString;
        return message;
    }

    public static void publishData(@UnknownKeyFor @NonNull @Initialized int numMessages, @UnknownKeyFor @NonNull @Initialized int delayInMillis) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<PubsubMessage> pubsubMessages = new ArrayList<PubsubMessage>();
        for (int i = 0; i < Math.max(1, numMessages); ++i) {
            Long currTime = System.currentTimeMillis();
            String message = Injector.generateEvent(currTime, delayInMillis);
            PubsubMessage pubsubMessage = new PubsubMessage().encodeData(message.getBytes("UTF-8"));
            pubsubMessage.setAttributes((Map)ImmutableMap.of((Object)"timestamp_ms", (Object)Long.toString((currTime - (long)delayInMillis) / 1000L * 1000L)));
            if (delayInMillis != 0) {
                System.out.println(pubsubMessage.getAttributes());
                System.out.println("late data for: " + message);
            }
            pubsubMessages.add(pubsubMessage);
        }
        PublishRequest publishRequest = new PublishRequest();
        publishRequest.setMessages(pubsubMessages);
        pubsub.projects().topics().publish(topic, publishRequest).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishDataToFile(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized int numMessages, @UnknownKeyFor @NonNull @Initialized int delayInMillis) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fileName, true)), "UTF-8"));
        try {
            for (int i = 0; i < Math.max(1, numMessages); ++i) {
                Long currTime = System.currentTimeMillis();
                String message = Injector.generateEvent(currTime, delayInMillis);
                out.println(message);
            }
        }
        catch (Exception e) {
            System.err.print("Error in writing generated events to file");
            e.printStackTrace();
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (args.length < 3) {
            System.out.println("Usage: Injector project-name (topic-name|none) (filename|none)");
            System.exit(1);
        }
        boolean writeToFile = false;
        boolean writeToPubsub = true;
        project = args[0];
        String topicName = args[1];
        String fileName = args[2];
        if ("none".equalsIgnoreCase(topicName)) {
            writeToFile = true;
            writeToPubsub = false;
        }
        if (writeToPubsub) {
            pubsub = InjectorUtils.getClient();
            topic = InjectorUtils.getFullyQualifiedTopicName(project, topicName);
            InjectorUtils.createTopic(pubsub, topic);
            System.out.println("Injecting to topic: " + topic);
        } else {
            if ("none".equalsIgnoreCase(fileName)) {
                System.out.println("Filename not specified.");
                System.exit(1);
            }
            System.out.println("Writing to file: " + fileName);
        }
        System.out.println("Starting Injector");
        while (liveTeams.size() < 15) {
            Injector.addLiveTeam();
        }
        int i = 0;
        while (true) {
            int numMessages;
            int delayInMillis;
            if (Thread.activeCount() > 10) {
                System.err.println("I'm falling behind!");
            }
            if (i % 600 == 0) {
                delayInMillis = 300000 + random.nextInt(300000);
                numMessages = 1;
                System.out.println("DELAY(" + delayInMillis + ", " + numMessages + ")");
            } else {
                System.out.print(".");
                delayInMillis = 0;
                numMessages = 800 + random.nextInt(200);
            }
            if (writeToFile) {
                Injector.publishDataToFile(fileName, numMessages, delayInMillis);
            } else {
                new Thread(() -> {
                    try {
                        Injector.publishData(numMessages, delayInMillis);
                    }
                    catch (IOException e) {
                        System.err.println(e);
                    }
                }).start();
            }
            Thread.sleep(500L);
            ++i;
        }
    }

    static {
        random = new Random();
        COLORS = new ArrayList<String>(Arrays.asList("Magenta", "AliceBlue", "Almond", "Amaranth", "Amber", "Amethyst", "AndroidGreen", "AntiqueBrass", "Fuchsia", "Ruby", "AppleGreen", "Apricot", "Aqua", "ArmyGreen", "Asparagus", "Auburn", "Azure", "Banana", "Beige", "Bisque", "BarnRed", "BattleshipGrey"));
        ANIMALS = new ArrayList<String>(Arrays.asList("Echidna", "Koala", "Wombat", "Marmot", "Quokka", "Kangaroo", "Dingo", "Numbat", "Emu", "Wallaby", "CaneToad", "Bilby", "Possum", "Cassowary", "Kookaburra", "Platypus", "Bandicoot", "Cockatoo", "Antechinus"));
        liveTeams = new ArrayList();
    }

    private static class TeamInfo {
        @UnknownKeyFor @NonNull @Initialized String teamName;
        @UnknownKeyFor @NonNull @Initialized long startTimeInMillis;
        @UnknownKeyFor @NonNull @Initialized int expirationPeriod;
        @UnknownKeyFor @NonNull @Initialized String robot;
        @UnknownKeyFor @NonNull @Initialized int numMembers;

        private TeamInfo(@UnknownKeyFor @NonNull @Initialized String teamName, @UnknownKeyFor @NonNull @Initialized long startTimeInMillis, @UnknownKeyFor @NonNull @Initialized String robot) {
            this.teamName = teamName;
            this.startTimeInMillis = startTimeInMillis;
            this.expirationPeriod = random.nextInt(20) + 20;
            this.robot = robot;
            this.numMembers = random.nextInt(15) + 5;
        }

        @UnknownKeyFor @NonNull @Initialized String getTeamName() {
            return this.teamName;
        }

        @UnknownKeyFor @NonNull @Initialized String getRobot() {
            return this.robot;
        }

        @UnknownKeyFor @NonNull @Initialized long getStartTimeInMillis() {
            return this.startTimeInMillis;
        }

        @UnknownKeyFor @NonNull @Initialized long getEndTimeInMillis() {
            return this.startTimeInMillis + (long)this.expirationPeriod * 60L * 1000L;
        }

        @UnknownKeyFor @NonNull @Initialized String getRandomUser() {
            int userNum = random.nextInt(this.numMembers);
            return "user" + userNum + "_" + this.teamName;
        }

        @UnknownKeyFor @NonNull @Initialized int numMembers() {
            return this.numMembers;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "(" + this.teamName + ", num members: " + this.numMembers() + ", starting at: " + this.startTimeInMillis + ", expires in: " + this.expirationPeriod + ", robot: " + this.robot + ")";
        }
    }
}

