/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.kafkatopubsub.kafka.consumer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.examples.complete.kafkatopubsub.options.KafkaToPubsubOptions;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.gson.JsonObject;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.gson.JsonParser;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Utils.class);

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> getKafkaCredentialsFromVault(@UnknownKeyFor @NonNull @Initialized String secretStoreUrl, @UnknownKeyFor @NonNull @Initialized String token) {
        HashMap<String, Map<String, String>> credentialMap = new HashMap<String, Map<String, String>>();
        JsonObject credentials = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(secretStoreUrl);
            request.addHeader("X-Vault-Token", token);
            HttpResponse response = client.execute((HttpUriRequest)request);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            credentials = JsonParser.parseString((String)json).getAsJsonObject().get("data").getAsJsonObject().getAsJsonObject("data");
        }
        catch (IOException e) {
            LOG.error("Failed to retrieve credentials from Vault.", (Throwable)e);
        }
        if (credentials != null) {
            credentialMap.put("kafka", new HashMap());
            if (credentials.has("username") && credentials.has("password")) {
                ((Map)credentialMap.get("kafka")).put("username", credentials.get("username").getAsString());
                ((Map)credentialMap.get("kafka")).put("password", credentials.get("password").getAsString());
            } else {
                LOG.warn("There are no username and/or password for Kafka in Vault.Trying to initiate an unauthorized connection.");
            }
        }
        return credentialMap;
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> configureKafka(@Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> props) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (props != null && props.containsKey("username") && props.containsKey("password")) {
            config.put("sasl.mechanism", ScramMechanism.SCRAM_SHA_512.mechanismName());
            config.put("sasl.jaas.config", String.format("org.apache.kafka.common.security.scram.ScramLoginModule required username=\"%s\" password=\"%s\";", props.get("username"), props.get("password")));
        }
        return config;
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configureSsl(@UnknownKeyFor @NonNull @Initialized KafkaToPubsubOptions options) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("ssl.truststore.location", options.getTruststorePath());
        config.put("ssl.keystore.location", options.getKeystorePath());
        config.put("ssl.truststore.password", options.getTruststorePassword());
        config.put("ssl.keystore.password", options.getKeystorePassword());
        config.put("ssl.key.password", options.getKeyPassword());
        return config;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isSslSpecified(@UnknownKeyFor @NonNull @Initialized KafkaToPubsubOptions options) {
        return options.getTruststorePath() != null || options.getTruststorePassword() != null || options.getKeystorePath() != null || options.getKeyPassword() != null;
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parseKafkaConsumerConfig(@Nullable @UnknownKeyFor @Initialized String kafkaConsumerConfig) {
        if (kafkaConsumerConfig == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(kafkaConsumerConfig.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1]));
    }
}

