/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryTornadoes {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryTornadoes.class);
    private static final @UnknownKeyFor @NonNull @Initialized String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";

    public static void applyBigQueryTornadoes(@UnknownKeyFor @NonNull @Initialized Pipeline p, @UnknownKeyFor @NonNull @Initialized Options options) {
        BigQueryIO.TypedRead bigqueryIO;
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        fields.add(new TableFieldSchema().setName("month").setType("INTEGER"));
        fields.add(new TableFieldSchema().setName("tornado_count").setType("INTEGER"));
        TableSchema schema = new TableSchema().setFields(fields);
        if (!options.getInputQuery().isEmpty()) {
            bigqueryIO = BigQueryIO.readTableRows().fromQuery(options.getInputQuery()).usingStandardSql().withMethod(options.getReadMethod());
        } else {
            bigqueryIO = BigQueryIO.readTableRows().from(options.getInput()).withMethod(options.getReadMethod());
            if (options.getReadMethod() == BigQueryIO.TypedRead.Method.DIRECT_READ) {
                bigqueryIO = bigqueryIO.withSelectedFields((List)Lists.newArrayList((Object[])new String[]{"month", "tornado"}));
            }
        }
        PCollection rowsFromBigQuery = (PCollection)p.apply((PTransform)bigqueryIO);
        ((PCollection)rowsFromBigQuery.apply((PTransform)new CountTornadoes())).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(options.getCreateDisposition()).withWriteDisposition(options.getWriteDisposition()).withMethod(options.getWriteMethod()));
    }

    public static void runBigQueryTornadoes(@UnknownKeyFor @NonNull @Initialized Options options) {
        LOG.info("Running BigQuery Tornadoes with options " + options.toString());
        Pipeline p = Pipeline.create((PipelineOptions)options);
        BigQueryTornadoes.applyBigQueryTornadoes(p, options);
        p.run().waitUntilFinish();
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        BigQueryTornadoes.runBigQueryTornadoes(options);
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="clouddataflow-readonly:samples.weather_stations")
        public @UnknownKeyFor @NonNull @Initialized String getInput();

        public void setInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="SQL Query to read from, will be used if Input is not set.")
        @Default.String(value="")
        public @UnknownKeyFor @NonNull @Initialized String getInputQuery();

        public void setInputQuery(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Read method to use to read from BigQuery")
        @Default.Enum(value="EXPORT")
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.Method getReadMethod();

        public void setReadMethod(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.Method var1);

        @Description(value="Write method to use to write to BigQuery")
        @Default.Enum(value="DEFAULT")
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.Method getWriteMethod();

        public void setWriteMethod(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.Method var1);

        @Description(value="Write disposition to use to write to BigQuery")
        @Default.Enum(value="WRITE_TRUNCATE")
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition getWriteDisposition();

        public void setWriteDisposition(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition var1);

        @Description(value="Create disposition to use to write to BigQuery")
        @Default.Enum(value="CREATE_IF_NEEDED")
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition getCreateDisposition();

        public void setCreateDisposition(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition var1);

        @Description(value="BigQuery table to write to, specified as <project_id>:<dataset_id>.<table_id>. The dataset must already exist.")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    static class CountTornadoes
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        CountTornadoes() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> rows) {
            PCollection tornadoes = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractTornadoesFn()));
            PCollection tornadoCounts = (PCollection)tornadoes.apply(Count.perElement());
            PCollection results = (PCollection)tornadoCounts.apply((PTransform)ParDo.of((DoFn)new FormatCountsFn()));
            return results;
        }
    }

    static class FormatCountsFn
    extends DoFn<KV<Integer, Long>, TableRow> {
        FormatCountsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = new TableRow().set("month", ((KV)c.element()).getKey()).set("tornado_count", ((KV)c.element()).getValue());
            c.output((Object)row);
        }
    }

    static class ExtractTornadoesFn
    extends DoFn<TableRow, Integer> {
        ExtractTornadoesFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = (TableRow)c.element();
            if (((Boolean)row.get((Object)"tornado")).booleanValue()) {
                c.output((Object)Integer.parseInt((String)row.get((Object)"month")));
            }
        }
    }
}

