/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import org.apache.beam.examples.VendorToPassengerDTO;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KafkaPassengerCountJson {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        KafkaStreamingOptions options = (KafkaStreamingOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(KafkaStreamingOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        HashMap<String, String> consumerConfig = new HashMap<String, String>();
        consumerConfig.put("auto.offset.reset", "earliest");
        final ObjectMapper om = new ObjectMapper();
        ((PCollection)((PCollection)((PCollection)((PCollection)p.apply("ReadFromKafka", KafkaIO.read().withBootstrapServers(options.getKafkaHost()).withTopicPartitions(Collections.singletonList(new TopicPartition("NYCTaxi1000_simple", 0))).withKeyDeserializer(StringDeserializer.class).withValueDeserializer(StringDeserializer.class).withConsumerConfigUpdates(consumerConfig).withMaxNumRecords(998L).withoutMetadata())).apply("CreateValues", (PTransform)Values.create())).apply("ExtractData", (PTransform)ParDo.of((DoFn)new DoFn<String, KV<Integer, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized JsonProcessingException {
                VendorToPassengerDTO result = (VendorToPassengerDTO)om.readValue((String)c.element(), (TypeReference)new TypeReference<VendorToPassengerDTO>(){});
                c.output((Object)KV.of((Object)result.getVendorIdField(), (Object)result.getPassengerCountField()));
            }
        }))).apply("Sum passengers per vendor", (PTransform)Combine.perKey((CombineFnBase.GlobalCombineFn)Sum.ofIntegers()))).apply("FormatResults", (PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, Integer>, KV<Integer, Integer>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Integer>> out) {
                System.out.printf("Vendor: %s, Passengers: %s%n", ((KV)c.element()).getKey(), ((KV)c.element()).getValue());
                out.output((Object)((KV)c.element()));
            }
        }));
        p.run().waitUntilFinish();
    }

    public static interface KafkaStreamingOptions
    extends PipelineOptions {
        @Description(value="Kafka server host")
        @Default.String(value="kafka_server:9092")
        public @UnknownKeyFor @NonNull @Initialized String getKafkaHost();

        public void setKafkaHost(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

