/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Latest;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestExample {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        Instant baseInstant = Instant.now().minus((ReadableDuration)Duration.standardSeconds((long)10L));
        PCollection numbers = (PCollection)pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{4, 3, 2, 1}));
        PCollection withTimestamps = (PCollection)numbers.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)duration -> baseInstant.plus((ReadableDuration)Duration.standardSeconds((long)duration.intValue()))));
        PCollection latest = (PCollection)numbers.apply(Latest.globally());
        PCollection latestTimestamped = (PCollection)withTimestamps.apply(Latest.globally());
        latest.apply((PTransform)ParDo.of(new LogOutput("Latest element (without timestamps): ")));
        latestTimestamped.apply((PTransform)ParDo.of(new LogOutput("Latest element (with timestamps): ")));
        pipeline.run();
    }

    static class LogOutput<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LogOutput.class);
        private final @UnknownKeyFor @NonNull @Initialized String prefix;

        public LogOutput(@UnknownKeyFor @NonNull @Initialized String prefix) {
            this.prefix = prefix;
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            LOG.info(this.prefix + c.element());
            c.output(c.element());
        }
    }
}

