/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionExample {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        CoderProvider coderProvider = CoderProviders.fromStaticMethods(Student.class, StudentCoder.class);
        pipeline.getCoderRegistry().registerCoderProvider(coderProvider);
        PCollection students = (PCollection)pipeline.apply((PTransform)Create.of((Object)Student.of("Amy", 88), (Object[])new Student[]{Student.of("Bob", 87), Student.of("Chris", 49), Student.of("Dylan", 62), Student.of("Ellen", 78), Student.of("Francis", 53), Student.of("Gagan", 43), Student.of("Holly", 59), Student.of("Irene", 22), Student.of("Jack", 19), Student.of("Kelly", 74), Student.of("Loris", 43), Student.of("Megan", 13), Student.of("Nemo", 97), Student.of("Omar", 50), Student.of("Patty", 58), Student.of("Qi", 31), Student.of("Raj", 40), Student.of("Sandy", 20), Student.of("Tina", 0), Student.of("Uma", 97), Student.of("Vicky", 41), Student.of("Wendy", 62), Student.of("Xin", 59), Student.of("Yvonne", 57), Student.of("Zane", 89)}));
        PCollectionList studentsByPercentile = (PCollectionList)students.apply((PTransform)Partition.of((int)10, (Partition.PartitionFn)new Partition.PartitionFn<Student>(){

            public @UnknownKeyFor @NonNull @Initialized int partitionFor(@UnknownKeyFor @NonNull @Initialized Student student, @UnknownKeyFor @NonNull @Initialized int numPartitions) {
                return student.getPercentile() * numPartitions / 100;
            }
        }));
        PCollection fortiethPercentile = studentsByPercentile.get(4);
        fortiethPercentile.apply((PTransform)ParDo.of(new LogOutput("Fortieth percentile: ")));
        pipeline.run();
    }

    static class LogOutput<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LogOutput.class);
        private final @UnknownKeyFor @NonNull @Initialized String prefix;

        public LogOutput(@UnknownKeyFor @NonNull @Initialized String prefix) {
            this.prefix = prefix;
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            LOG.info(this.prefix + c.element());
            c.output(c.element());
        }
    }

    static class StudentCoder
    extends Coder<Student> {
        StudentCoder() {
        }

        public static @UnknownKeyFor @NonNull @Initialized StudentCoder of() {
            return new StudentCoder();
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Student student, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String serializableStudent = student.getName() + "," + student.getPercentile();
            outStream.write(serializableStudent.getBytes(StandardCharsets.UTF_8));
        }

        public @UnknownKeyFor @NonNull @Initialized Student decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            String serializableStudent = buffer.toString(StandardCharsets.UTF_8.name());
            String[] fields = serializableStudent.split(",", -1);
            return Student.of(fields[0], Integer.parseInt(fields[1]));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() {
        }
    }

    static class Student {
        private @UnknownKeyFor @NonNull @Initialized String name = "";
        private @UnknownKeyFor @NonNull @Initialized int percentile;

        private Student() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        public @UnknownKeyFor @NonNull @Initialized int getPercentile() {
            return this.percentile;
        }

        public static @UnknownKeyFor @NonNull @Initialized Student of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized int percentile) {
            Student student = new Student();
            student.name = name;
            student.percentile = percentile;
            return student;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name + " (" + this.percentile + ")";
        }
    }
}

