/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowExample {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        List<String> inputData = Arrays.asList("foo", "bar", "foo", "foo");
        List<Long> timestamps = Arrays.asList(Duration.standardSeconds((long)15L).getMillis(), Duration.standardSeconds((long)30L).getMillis(), Duration.standardSeconds((long)45L).getMillis(), Duration.standardSeconds((long)90L).getMillis());
        PCollection items = (PCollection)pipeline.apply((PTransform)Create.timestamped(inputData, timestamps));
        PCollection windowedItems = (PCollection)items.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))));
        PCollection windowedCounts = (PCollection)windowedItems.apply(Count.perElement());
        windowedCounts.apply((PTransform)ParDo.of(new LogOutput("PCollection elements after Count transform: ")));
        pipeline.run();
    }

    static class LogOutput<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(LogOutput.class);
        private final @UnknownKeyFor @NonNull @Initialized String prefix;

        public LogOutput(@UnknownKeyFor @NonNull @Initialized String prefix) {
            this.prefix = prefix;
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            LOG.info(this.prefix + c.element());
            c.output(c.element());
        }
    }
}

