/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.Collections;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.ExampleUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StreamingWordExtract {
    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized IOException {
        StreamingWordExtractOptions options = (StreamingWordExtractOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(StreamingWordExtractOptions.class);
        options.setStreaming(true);
        options.setBigQuerySchema(StringToRowConverter.getSchema());
        ExampleUtils exampleUtils = new ExampleUtils(options);
        exampleUtils.setup();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        String tableSpec = options.getProject() + ":" + options.getBigQueryDataset() + "." + options.getBigQueryTable();
        ((PCollection)((PCollection)((PCollection)((PCollection)pipeline.apply("ReadLines", (PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new ExtractWords()))).apply((PTransform)ParDo.of((DoFn)new Uppercase()))).apply((PTransform)ParDo.of((DoFn)new StringToRowConverter()))).apply((PTransform)BigQueryIO.writeTableRows().to(tableSpec).withSchema(StringToRowConverter.getSchema()));
        PipelineResult result = pipeline.run();
        exampleUtils.waitToFinish(result);
    }

    public static interface StreamingWordExtractOptions
    extends ExampleOptions,
    ExampleBigQueryTableOptions,
    StreamingOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://apache-beam-samples/shakespeare/kinglear.txt")
        public @UnknownKeyFor @NonNull @Initialized String getInputFile();

        public void setInputFile(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    static class StringToRowConverter
    extends DoFn<String, TableRow> {
        StringToRowConverter() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output((Object)new TableRow().set("string_field", c.element()));
        }

        static @UnknownKeyFor @NonNull @Initialized TableSchema getSchema() {
            return new TableSchema().setFields(Collections.singletonList(new TableFieldSchema().setName("string_field").setType("STRING")));
        }
    }

    static class Uppercase
    extends DoFn<String, String> {
        Uppercase() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output((Object)((String)c.element()).toUpperCase());
        }
    }

    static class ExtractWords
    extends DoFn<String, String> {
        ExtractWords() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            String[] words;
            for (String word : words = ((String)c.element()).split("[^\\p{L}]+", -1)) {
                if (word.isEmpty()) continue;
                c.output((Object)word);
            }
        }
    }
}

