/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import com.google.auto.value.AutoValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_CsvConverters_LineToFailsafeJson;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_CsvConverters_ReadCsv;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.examples.complete.datatokenization.utils.SchemasUtils;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConverters {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CsvConverters.class);
    private static final @UnknownKeyFor @NonNull @Initialized String SUCCESSFUL_TO_JSON_COUNTER = "SuccessfulToJsonCounter";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_TO_JSON_COUNTER = "FailedToJsonCounter";
    private static @UnknownKeyFor @NonNull @Initialized JsonParser jsonParser = new JsonParser();

    static @UnknownKeyFor @NonNull @Initialized String buildJsonString(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> headers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> values, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String jsonSchemaString) throws @UnknownKeyFor @NonNull @Initialized Exception {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        if (jsonSchemaString != null) {
            JsonArray jsonSchema = jsonParser.parse(jsonSchemaString).getAsJsonArray();
            writer.beginObject();
            block20: for (int i = 0; i < jsonSchema.size(); ++i) {
                JsonObject jsonObject = jsonSchema.get(i).getAsJsonObject();
                String type = jsonObject.get("type").getAsString().toUpperCase();
                writer.name(jsonObject.get("name").getAsString());
                switch (type) {
                    case "LONG": {
                        writer.value(Long.parseLong(values.get(i)));
                        continue block20;
                    }
                    case "DOUBLE": {
                        writer.value(Double.parseDouble(values.get(i)));
                        continue block20;
                    }
                    case "INTEGER": {
                        writer.value((long)Integer.parseInt(values.get(i)));
                        continue block20;
                    }
                    case "SHORT": {
                        writer.value((long)Short.parseShort(values.get(i)));
                        continue block20;
                    }
                    case "BYTE": {
                        writer.value((long)Byte.parseByte(values.get(i)));
                        continue block20;
                    }
                    case "FLOAT": {
                        writer.value(Float.parseFloat(values.get(i)));
                        continue block20;
                    }
                    case "TEXT": 
                    case "KEYWORD": 
                    case "STRING": {
                        writer.value(values.get(i));
                        continue block20;
                    }
                    default: {
                        LOG.error("Invalid data type, got: " + type);
                        throw new RuntimeException("Invalid data type, got: " + type);
                    }
                }
            }
            writer.endObject();
            writer.close();
            return stringWriter.toString();
        }
        if (headers != null) {
            writer.beginObject();
            for (int i = 0; i < headers.size(); ++i) {
                writer.name(headers.get(i));
                writer.value(values.get(i));
            }
            writer.endObject();
            writer.close();
            return stringWriter.toString();
        }
        LOG.error("No headers or schema specified");
        throw new RuntimeException("No headers or schema specified");
    }

    public static @UnknownKeyFor @NonNull @Initialized CSVFormat getCsvFormat(@UnknownKeyFor @NonNull @Initialized String formatString, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String delimiter) {
        CSVFormat format = CSVFormat.Predefined.valueOf((String)formatString).getFormat();
        if (delimiter != null) {
            return format.withDelimiter(delimiter.charAt(0));
        }
        return format;
    }

    static class GetCsvHeadersFn
    extends DoFn<FileIO.ReadableFile, String> {
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> headerTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> linesTag;
        private @UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat;

        GetCsvHeadersFn(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> headerTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> linesTag, @UnknownKeyFor @NonNull @Initialized String csvFormat, @UnknownKeyFor @NonNull @Initialized String delimiter) {
            this.headerTag = headerTag;
            this.linesTag = linesTag;
            this.csvFormat = CsvConverters.getCsvFormat(csvFormat, delimiter);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver) {
            String headers;
            FileIO.ReadableFile f = (FileIO.ReadableFile)context.element();
            List<String> records = null;
            String delimiter = String.valueOf(this.csvFormat.getDelimiter());
            try {
                String csvFileString = f.readFullyAsUTF8String();
                StringReader reader = new StringReader(csvFileString);
                CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)this.csvFormat.withFirstRecordAsHeader());
                records = parser.getRecords().stream().map(i -> String.join((CharSequence)delimiter, (Iterable<? extends CharSequence>)i)).collect(Collectors.toList());
                headers = String.join((CharSequence)delimiter, parser.getHeaderNames());
            }
            catch (IOException ioe) {
                LOG.error("Headers do not match, consistency cannot be guaranteed");
                throw new RuntimeException("Could not read Csv headers: " + ioe.getMessage());
            }
            outputReceiver.get(this.headerTag).output((Object)headers);
            records.forEach(r -> outputReceiver.get(this.linesTag).output(r));
        }
    }

    @AutoValue
    public static abstract class ReadCsv
    extends PTransform<PBegin, PCollectionTuple> {
        public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
            return new AutoValue_CsvConverters_ReadCsv.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String csvFormat();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String delimiter();

        public abstract @UnknownKeyFor @NonNull @Initialized Boolean hasHeaders();

        public abstract @UnknownKeyFor @NonNull @Initialized String inputFileSpec();

        public abstract @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> headerTag();

        public abstract @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> lineTag();

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            if (this.hasHeaders().booleanValue()) {
                return (PCollectionTuple)((PCollection)((PCollection)input.apply("MatchFilePattern", (PTransform)FileIO.match().filepattern(this.inputFileSpec()))).apply("ReadMatches", (PTransform)FileIO.readMatches())).apply("ReadCsvWithHeaders", (PTransform)ParDo.of((DoFn)new GetCsvHeadersFn(this.headerTag(), this.lineTag(), this.csvFormat(), this.delimiter())).withOutputTags(this.headerTag(), TupleTagList.of(this.lineTag())));
            }
            return PCollectionTuple.of(this.lineTag(), (PCollection)((PCollection)input.apply("ReadCsvWithoutHeaders", (PTransform)TextIO.read().from(this.inputFileSpec()))));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCsvFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setHasHeaders(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInputFileSpec(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setHeaderTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLineTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadCsv autoBuild();

            public @UnknownKeyFor @NonNull @Initialized ReadCsv build() {
                ReadCsv readCsv = this.autoBuild();
                Preconditions.checkArgument((readCsv.inputFileSpec() != null ? 1 : 0) != 0, (Object)"Input file spec must be provided.");
                Preconditions.checkArgument((readCsv.csvFormat() != null ? 1 : 0) != 0, (Object)"Csv format must not be null.");
                Preconditions.checkArgument((readCsv.hasHeaders() != null ? 1 : 0) != 0, (Object)"Header information must be provided.");
                return readCsv;
            }
        }
    }

    static class LineToFailsafeElementFn
    extends DoFn<String, FailsafeElement<String, String>> {
        LineToFailsafeElementFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            String message = (String)context.element();
            context.output(FailsafeElement.of(message, message));
        }
    }

    public static class FailsafeElementToJsonFn
    extends DoFn<FailsafeElement<String, String>, FailsafeElement<String, String>> {
        @javax.annotation.Nullable
        public final @UnknownKeyFor @Nullable @Initialized String jsonSchema;
        public final @UnknownKeyFor @NonNull @Initialized String delimiter;
        public final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> udfDeadletterTag;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> headersView;
        private @UnknownKeyFor @NonNull @Initialized Counter successCounter = Metrics.counter(FailsafeElementToJsonFn.class, (String)"SuccessfulToJsonCounter");
        private @UnknownKeyFor @NonNull @Initialized Counter failedCounter = Metrics.counter(FailsafeElementToJsonFn.class, (String)"FailedToJsonCounter");

        FailsafeElementToJsonFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> headersView, @UnknownKeyFor @NonNull @Initialized String jsonSchema, @UnknownKeyFor @NonNull @Initialized String delimiter, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> udfDeadletterTag) {
            this.headersView = headersView;
            this.jsonSchema = jsonSchema;
            this.delimiter = delimiter;
            this.udfDeadletterTag = udfDeadletterTag;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            FailsafeElement element = (FailsafeElement)context.element();
            List<String> header = null;
            if (this.headersView != null) {
                header = Arrays.asList(((String)context.sideInput(this.headersView)).split(this.delimiter));
            }
            List<String> record = Arrays.asList(((String)element.getOriginalPayload()).split(this.delimiter));
            try {
                String json = CsvConverters.buildJsonString(header, record, this.jsonSchema);
                context.output(FailsafeElement.of((String)element.getOriginalPayload(), json));
                this.successCounter.inc();
            }
            catch (Exception e) {
                this.failedCounter.inc();
                context.output(this.udfDeadletterTag, FailsafeElement.of(element).setErrorMessage(e.getMessage()).setStacktrace(Throwables.getStackTraceAsString((Throwable)e)));
            }
        }
    }

    @AutoValue
    public static abstract class LineToFailsafeJson
    extends PTransform<PCollectionTuple, PCollectionTuple> {
        public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
            return new AutoValue_CsvConverters_LineToFailsafeJson.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String delimiter();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String jsonSchemaPath();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String jsonSchema();

        public abstract @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> headerTag();

        public abstract @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> lineTag();

        public abstract @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> udfOutputTag();

        public abstract @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> udfDeadletterTag();

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionTuple lines) {
            PCollectionView headersView = null;
            PCollection lineFailsafeElements = (PCollection)lines.get(this.lineTag()).apply("LineToFailsafeElement", (PTransform)ParDo.of((DoFn)new LineToFailsafeElementFn()));
            String schemaPath = this.jsonSchemaPath();
            if (schemaPath != null || this.jsonSchema() != null) {
                String schema = schemaPath != null ? SchemasUtils.getGcsFileAsString(schemaPath) : this.jsonSchema();
                return (PCollectionTuple)lineFailsafeElements.apply("LineToDocumentUsingSchema", (PTransform)ParDo.of((DoFn)new FailsafeElementToJsonFn((PCollectionView<String>)headersView, schema, this.delimiter(), this.udfDeadletterTag())).withOutputTags(this.udfOutputTag(), TupleTagList.of(this.udfDeadletterTag())));
            }
            final PCollectionView finalHeadersView = headersView = (PCollectionView)((PCollection)lines.get(this.headerTag()).apply(Sample.any((long)1L))).apply((PTransform)View.asSingleton());
            lines.get(this.headerTag()).apply("CheckHeaderConsistency", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    String headers = (String)c.sideInput(finalHeadersView);
                    if (!((String)c.element()).equals(headers)) {
                        LOG.error("Headers do not match, consistency cannot be guaranteed");
                        throw new RuntimeException("Headers do not match, consistency cannot be guaranteed");
                    }
                }
            }).withSideInputs(new PCollectionView[]{finalHeadersView}));
            return (PCollectionTuple)lineFailsafeElements.apply("LineToDocumentWithHeaders", (PTransform)ParDo.of((DoFn)new FailsafeElementToJsonFn((PCollectionView<String>)headersView, this.jsonSchemaPath(), this.delimiter(), this.udfDeadletterTag())).withSideInputs(new PCollectionView[]{headersView}).withOutputTags(this.udfOutputTag(), TupleTagList.of(this.udfDeadletterTag())));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJsonSchemaPath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setJsonSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setHeaderTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLineTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUdfOutputTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setUdfDeadletterTag(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized LineToFailsafeJson build();
        }
    }

    public static class DelimiterFactory
    implements DefaultValueFactory<String> {
        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            CSVFormat csvFormat = CsvConverters.getCsvFormat(((CsvPipelineOptions)options.as(CsvPipelineOptions.class)).getCsvFormat(), null);
            return String.valueOf(csvFormat.getDelimiter());
        }
    }

    public static interface CsvPipelineOptions
    extends PipelineOptions {
        @Description(value="Pattern to where data lives, ex: gs://mybucket/somepath/*.csv")
        public @UnknownKeyFor @NonNull @Initialized String getInputFileSpec();

        public void setInputFileSpec(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="If file(s) contain headers")
        public @UnknownKeyFor @NonNull @Initialized Boolean getContainsHeaders();

        public void setContainsHeaders(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        @Description(value="Deadletter table for failed inserts in form: <project-id>:<dataset>.<table>")
        public @UnknownKeyFor @NonNull @Initialized String getDeadletterTable();

        public void setDeadletterTable(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Delimiting character. Default: use delimiter provided in csvFormat")
        @Default.InstanceFactory(value=DelimiterFactory.class)
        public @UnknownKeyFor @NonNull @Initialized String getDelimiter();

        public void setDelimiter(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Csv format according to Apache Commons CSV format. Default is: Apache Commons CSV default\nhttps://static.javadoc.io/org.apache.commons/commons-csv/1.7/org/apache/commons/csv/CSVFormat.html#DEFAULT\nMust match format names exactly found at: https://static.javadoc.io/org.apache.commons/commons-csv/1.7/org/apache/commons/csv/CSVFormat.Predefined.html")
        @Default.String(value="Default")
        public @UnknownKeyFor @NonNull @Initialized String getCsvFormat();

        public void setCsvFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Optional: Path to JSON schema, ex gs://path/to/schema. ")
        public @UnknownKeyFor @NonNull @Initialized String getJsonSchemaPath();

        public void setJsonSchemaPath(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Set to true if number of files is in the tens of thousands. Default: false")
        @Default.Boolean(value=false)
        public @UnknownKeyFor @NonNull @Initialized Boolean getLargeNumFiles();

        public void setLargeNumFiles(@UnknownKeyFor @NonNull @Initialized Boolean var1);
    }
}

