/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_ErrorConverters_WriteErrorsToTextIO;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_ErrorConverters_WriteStringMessageErrors;
import org.apache.beam.examples.complete.datatokenization.utils.AutoValue_ErrorConverters_WriteStringMessageErrorsAsCsv;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ErrorConverters {

    @AutoValue
    public static abstract class WriteErrorsToTextIO<@UnknownKeyFor T, @UnknownKeyFor V>
    extends PTransform<PCollection<FailsafeElement<T, V>>, PDone> {
        public static <T, V> @UnknownKeyFor @NonNull @Initialized Builder<T, V> newBuilder() {
            return new AutoValue_ErrorConverters_WriteErrorsToTextIO.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String errorWritePath();

        public abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized FailsafeElement<T, V>, @UnknownKeyFor @NonNull @Initialized String> translateFunction();

        public abstract @Nullable @UnknownKeyFor @Initialized Duration windowDuration();

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FailsafeElement<T, V>> pCollection) {
            PCollection formattedErrorRows = (PCollection)pCollection.apply("GetFormattedErrorRow", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(this.translateFunction()));
            if (pCollection.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                if (this.windowDuration() == null) {
                    throw new RuntimeException("Unbounded input requires window interval to be set");
                }
                return (PDone)((PCollection)formattedErrorRows.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)this.windowDuration())))).apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1).withWindowedWrites());
            }
            return (PDone)formattedErrorRows.apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1));
        }

        @AutoValue.Builder
        public static abstract class Builder<@UnknownKeyFor T, @UnknownKeyFor V> {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T, V> setErrorWritePath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T, V> setTranslateFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized FailsafeElement<T, V>, @UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T, V> setWindowDuration(@Nullable @UnknownKeyFor @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized FailsafeElement<T, V>, @UnknownKeyFor @NonNull @Initialized String> translateFunction();

            abstract @UnknownKeyFor @NonNull @Initialized WriteErrorsToTextIO<T, V> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized WriteErrorsToTextIO<T, V> build() {
                Preconditions.checkNotNull(this.translateFunction(), (Object)"translateFunction is required.");
                return this.autoBuild();
            }
        }
    }

    public static class FailedStringToTableRowFn
    extends DoFn<FailsafeElement<String, String>, TableRow> {
        private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS");

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            FailsafeElement failsafeElement = (FailsafeElement)context.element();
            String message = (String)failsafeElement.getOriginalPayload();
            String timestamp = TIMESTAMP_FORMATTER.print((ReadableInstant)context.timestamp().toDateTime(DateTimeZone.UTC));
            TableRow failedRow = new TableRow().set("timestamp", (Object)timestamp).set("errorMessage", (Object)failsafeElement.getErrorMessage()).set("stacktrace", (Object)failsafeElement.getStacktrace());
            if (message != null) {
                failedRow.set("payloadString", (Object)message).set("payloadBytes", (Object)message.getBytes(StandardCharsets.UTF_8));
            }
            context.output((Object)failedRow);
        }
    }

    @AutoValue
    public static abstract class WriteStringMessageErrors
    extends PTransform<PCollection<FailsafeElement<String, String>>, WriteResult> {
        public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
            return new AutoValue_ErrorConverters_WriteStringMessageErrors.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getErrorRecordsTable();

        public abstract @UnknownKeyFor @NonNull @Initialized String getErrorRecordsTableSchema();

        public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> failedRecords) {
            return (WriteResult)((PCollection)failedRecords.apply("FailedRecordToTableRow", (PTransform)ParDo.of((DoFn)new FailedStringToTableRowFn()))).apply("WriteFailedRecordsToBigQuery", (PTransform)BigQueryIO.writeTableRows().to(this.getErrorRecordsTable()).withJsonSchema(this.getErrorRecordsTableSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorRecordsTable(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorRecordsTableSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized WriteStringMessageErrors build();
        }
    }

    public static class FailedStringToCsvRowFn
    extends DoFn<FailsafeElement<String, String>, String> {
        private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSS");
        private final @UnknownKeyFor @NonNull @Initialized String csvDelimiter;

        public FailedStringToCsvRowFn(@UnknownKeyFor @NonNull @Initialized String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        public FailedStringToCsvRowFn() {
            this.csvDelimiter = ",";
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            FailsafeElement failsafeElement = (FailsafeElement)context.element();
            ArrayList<String> outputRow = new ArrayList<String>();
            String message = (String)failsafeElement.getOriginalPayload();
            String timestamp = TIMESTAMP_FORMATTER.print((ReadableInstant)context.timestamp().toDateTime(DateTimeZone.UTC));
            outputRow.add(timestamp);
            outputRow.add((String)MoreObjects.firstNonNull((Object)failsafeElement.getErrorMessage(), (Object)""));
            if (message != null) {
                outputRow.add(message);
            }
            context.output((Object)String.join((CharSequence)this.csvDelimiter, outputRow));
        }
    }

    @AutoValue
    public static abstract class WriteStringMessageErrorsAsCsv
    extends PTransform<PCollection<FailsafeElement<String, String>>, PDone> {
        public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
            return new AutoValue_ErrorConverters_WriteStringMessageErrorsAsCsv.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String errorWritePath();

        public abstract @UnknownKeyFor @NonNull @Initialized String csvDelimiter();

        public abstract @Nullable @UnknownKeyFor @Initialized Duration windowDuration();

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FailsafeElement<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> pCollection) {
            PCollection formattedErrorRows = (PCollection)pCollection.apply("GetFormattedErrorRow", (PTransform)ParDo.of((DoFn)new FailedStringToCsvRowFn(this.csvDelimiter())));
            if (pCollection.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                if (this.windowDuration() != null) {
                    formattedErrorRows = (PCollection)formattedErrorRows.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)this.windowDuration())));
                }
                return (PDone)formattedErrorRows.apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1).withWindowedWrites());
            }
            return (PDone)formattedErrorRows.apply((PTransform)TextIO.write().to(this.errorWritePath()).withNumShards(1));
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorWritePath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCsvDelimiter(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setWindowDuration(@Nullable @UnknownKeyFor @Initialized Duration var1);

            public abstract @UnknownKeyFor @NonNull @Initialized WriteStringMessageErrorsAsCsv build();
        }
    }
}

