/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FailsafeElementCoder<@UnknownKeyFor OriginalT, @UnknownKeyFor CurrentT>
extends CustomCoder<FailsafeElement<OriginalT, CurrentT>> {
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private final @UnknownKeyFor @NonNull @Initialized Coder<OriginalT> originalPayloadCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<CurrentT> currentPayloadCoder;

    private FailsafeElementCoder(@UnknownKeyFor @NonNull @Initialized Coder<OriginalT> originalPayloadCoder, @UnknownKeyFor @NonNull @Initialized Coder<CurrentT> currentPayloadCoder) {
        this.originalPayloadCoder = originalPayloadCoder;
        this.currentPayloadCoder = currentPayloadCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<OriginalT> getOriginalPayloadCoder() {
        return this.originalPayloadCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<CurrentT> getCurrentPayloadCoder() {
        return this.currentPayloadCoder;
    }

    public static <OriginalT, CurrentT> @UnknownKeyFor @NonNull @Initialized FailsafeElementCoder<OriginalT, CurrentT> of(@UnknownKeyFor @NonNull @Initialized Coder<OriginalT> originalPayloadCoder, @UnknownKeyFor @NonNull @Initialized Coder<CurrentT> currentPayloadCoder) {
        return new FailsafeElementCoder<OriginalT, CurrentT>(originalPayloadCoder, currentPayloadCoder);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized FailsafeElement<OriginalT, CurrentT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("The FailsafeElementCoder cannot encode a null object!");
        }
        this.originalPayloadCoder.encode(value.getOriginalPayload(), outStream);
        this.currentPayloadCoder.encode(value.getPayload(), outStream);
        STRING_CODER.encode((Object)value.getErrorMessage(), outStream);
        STRING_CODER.encode((Object)value.getStacktrace(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized FailsafeElement<OriginalT, CurrentT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object originalPayload = this.originalPayloadCoder.decode(inStream);
        Object currentPayload = this.currentPayloadCoder.decode(inStream);
        @Nullable String errorMessage = (String)STRING_CODER.decode(inStream);
        @Nullable String stacktrace = (String)STRING_CODER.decode(inStream);
        return FailsafeElement.of(originalPayload, currentPayload).setErrorMessage(errorMessage).setStacktrace(stacktrace);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Arrays.asList(this.originalPayloadCoder, this.currentPayloadCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized FailsafeElement<OriginalT, CurrentT>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<FailsafeElement<OriginalT, CurrentT>>(){}.where(new TypeParameter<OriginalT>(){}, this.originalPayloadCoder.getEncodedTypeDescriptor()).where(new TypeParameter<CurrentT>(){}, this.currentPayloadCoder.getEncodedTypeDescriptor());
    }
}

