/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WriteToBigQuery<@UnknownKeyFor InputT>
extends PTransform<PCollection<InputT>, PDone> {
    protected @UnknownKeyFor @NonNull @Initialized String projectId;
    protected @UnknownKeyFor @NonNull @Initialized String datasetId;
    protected @UnknownKeyFor @NonNull @Initialized String tableName;
    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldInfo<InputT>> fieldInfo;

    public WriteToBigQuery() {
    }

    public WriteToBigQuery(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldInfo<InputT>> fieldInfo) {
        this.projectId = projectId;
        this.datasetId = datasetId;
        this.tableName = tableName;
        this.fieldInfo = fieldInfo;
    }

    protected @UnknownKeyFor @NonNull @Initialized TableSchema getSchema() {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        for (Map.Entry<String, FieldInfo<InputT>> entry : this.fieldInfo.entrySet()) {
            String key = entry.getKey();
            FieldInfo<InputT> fcnInfo = entry.getValue();
            String bqType = fcnInfo.getFieldType();
            fields.add(new TableFieldSchema().setName(key).setType(bqType));
        }
        return new TableSchema().setFields(fields);
    }

    public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> teamAndScore) {
        ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)BigQueryIO.writeTableRows().to(WriteToBigQuery.getTable(this.projectId, this.datasetId, this.tableName)).withSchema(this.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        return PDone.in((Pipeline)teamAndScore.getPipeline());
    }

    static @UnknownKeyFor @NonNull @Initialized TableReference getTable(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableName) {
        TableReference table = new TableReference();
        table.setDatasetId(datasetId);
        table.setProjectId(projectId);
        table.setTableId(tableName);
        return table;
    }

    protected class BuildRowFn
    extends DoFn<InputT, TableRow> {
        protected BuildRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            TableRow row = new TableRow();
            for (Map.Entry entry : WriteToBigQuery.this.fieldInfo.entrySet()) {
                String key = entry.getKey();
                FieldInfo fcnInfo = entry.getValue();
                FieldFn fcn = fcnInfo.getFieldFn();
                row.set(key, fcn.apply(c, window));
            }
            c.output((Object)row);
        }
    }

    public static class FieldInfo<@UnknownKeyFor InputT>
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized String fieldType;
        private @UnknownKeyFor @NonNull @Initialized FieldFn<InputT> fieldFn;

        public FieldInfo(@UnknownKeyFor @NonNull @Initialized String fieldType, @UnknownKeyFor @NonNull @Initialized FieldFn<InputT> fieldFn) {
            this.fieldType = fieldType;
            this.fieldFn = fieldFn;
        }

        @UnknownKeyFor @NonNull @Initialized String getFieldType() {
            return this.fieldType;
        }

        @UnknownKeyFor @NonNull @Initialized FieldFn<InputT> getFieldFn() {
            return this.fieldFn;
        }
    }

    public static interface FieldFn<@UnknownKeyFor InputT>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized Object apply(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext var1, @UnknownKeyFor @NonNull @Initialized BoundedWindow var2);
    }
}

