/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CombinePerKeyExamples {
    private static final @UnknownKeyFor @NonNull @Initialized String SHAKESPEARE_TABLE = "publicdata:samples.shakespeare";
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_WORD_LENGTH = 9;

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        CombinePerKeyExamples.runCombinePerKeyExamples(options);
    }

    static void runCombinePerKeyExamples(@UnknownKeyFor @NonNull @Initialized Options options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        fields.add(new TableFieldSchema().setName("word").setType("STRING"));
        fields.add(new TableFieldSchema().setName("all_plays").setType("STRING"));
        TableSchema schema = new TableSchema().setFields(fields);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()))).apply((PTransform)new PlaysForWord())).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="publicdata:samples.shakespeare")
        public @UnknownKeyFor @NonNull @Initialized String getInput();

        public void setInput(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Table to write to, specified as <project_id>:<dataset_id>.<table_id>. The dataset_id must already exist")
        @Validation.Required
        public @UnknownKeyFor @NonNull @Initialized String getOutput();

        public void setOutput(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    public static class ConcatWords
    implements SerializableFunction<Iterable<String>, String> {
        public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> input) {
            StringBuilder all = new StringBuilder();
            for (String item : input) {
                if (item.isEmpty()) continue;
                if (all.length() == 0) {
                    all.append(item);
                    continue;
                }
                all.append(",");
                all.append(item);
            }
            return all.toString();
        }
    }

    static class PlaysForWord
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        PlaysForWord() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> rows) {
            PCollection words = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractLargeWordsFn()));
            PCollection wordAllPlays = (PCollection)words.apply((PTransform)Combine.perKey((SerializableFunction)new ConcatWords()));
            PCollection results = (PCollection)wordAllPlays.apply((PTransform)ParDo.of((DoFn)new FormatShakespeareOutputFn()));
            return results;
        }
    }

    static class FormatShakespeareOutputFn
    extends DoFn<KV<String, String>, TableRow> {
        FormatShakespeareOutputFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = new TableRow().set("word", ((KV)c.element()).getKey()).set("all_plays", ((KV)c.element()).getValue());
            c.output((Object)row);
        }
    }

    static class ExtractLargeWordsFn
    extends DoFn<TableRow, KV<String, String>> {
        private final @UnknownKeyFor @NonNull @Initialized Counter smallerWords = Metrics.counter(ExtractLargeWordsFn.class, (String)"smallerWords");

        ExtractLargeWordsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = (TableRow)c.element();
            String playName = (String)row.get((Object)"corpus");
            String word = (String)row.get((Object)"word");
            if (word.length() >= 9) {
                c.output((Object)KV.of((Object)word, (Object)playName));
            } else {
                this.smallerWords.inc();
            }
        }
    }
}

