/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets.transforms.io.gcp.bigquery;

import java.util.Arrays;
import org.apache.beam.examples.snippets.transforms.io.gcp.bigquery.BigQueryMyData;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryReadFromTableWithBigQueryStorageAPI {
    BigQueryReadFromTableWithBigQueryStorageAPI() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollection< @UnknownKeyFor @NonNull @Initialized BigQueryMyData.MyData> readFromTableWithBigQueryStorageAPI(@UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        PCollection rows = (PCollection)((PCollection)pipeline.apply("Read from BigQuery table", (PTransform)BigQueryIO.readTableRows().from(String.format("%s:%s.%s", project, dataset, table)).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withSelectedFields(Arrays.asList("string_field", "int64_field", "float64_field", "numeric_field", "bool_field", "bytes_field", "date_field", "datetime_field", "time_field", "timestamp_field", "geography_field", "array_field", "struct_field")))).apply("TableRows to MyData", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(BigQueryMyData.MyData.class)).via(BigQueryMyData.MyData::fromTableRow));
        return rows;
    }
}

