/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.utils;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.utils.ExecutableFile;
import org.apache.beam.examples.subprocess.utils.FileUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallingSubProcessUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CallingSubProcessUtils.class);
    static @UnknownKeyFor @NonNull @Initialized boolean initCompleted = false;
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> downloadedFiles = Sets.newConcurrentHashSet();
    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Semaphore> semaphores = new ConcurrentHashMap<String, Semaphore>();

    private CallingSubProcessUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration configuration, @UnknownKeyFor @NonNull @Initialized String binaryName) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (!semaphores.containsKey(binaryName)) {
            CallingSubProcessUtils.initSemaphore(configuration.getConcurrency(), binaryName);
        }
        Set<String> set = downloadedFiles;
        synchronized (set) {
            if (!downloadedFiles.contains(binaryName)) {
                FileUtils.createDirectoriesOnWorker(configuration);
                LOG.info("Calling filesetup to move Executables to worker.");
                ExecutableFile executableFile = new ExecutableFile(configuration, binaryName);
                FileUtils.copyFileFromGCSToWorker(executableFile);
                downloadedFiles.add(binaryName);
            }
        }
    }

    public static synchronized void initSemaphore(@UnknownKeyFor @NonNull @Initialized Integer permits, @UnknownKeyFor @NonNull @Initialized String binaryName) {
        if (!semaphores.containsKey(binaryName)) {
            LOG.info(String.format(String.format("Initialized Semaphore for binary %s ", binaryName), new Object[0]));
            semaphores.put(binaryName, new Semaphore(permits));
        }
    }

    private static void aquireSemaphore(@UnknownKeyFor @NonNull @Initialized String binaryName) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (!semaphores.containsKey(binaryName)) {
            throw new IllegalStateException("Semaphore is NULL, check init logic in @Setup.");
        }
        try {
            semaphores.get(binaryName).acquire();
        }
        catch (InterruptedException ex) {
            LOG.error("Interupted during aquire", (Throwable)ex);
        }
    }

    private static void releaseSemaphore(@UnknownKeyFor @NonNull @Initialized String binaryName) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (!semaphores.containsKey(binaryName)) {
            throw new IllegalStateException("Semaphore is NULL, check init logic in @Setup.");
        }
        semaphores.get(binaryName).release();
    }

    public static class Permit
    implements AutoCloseable {
        private @UnknownKeyFor @NonNull @Initialized String binaryName;

        public Permit(@UnknownKeyFor @NonNull @Initialized String binaryName) {
            this.binaryName = binaryName;
            CallingSubProcessUtils.aquireSemaphore(binaryName);
        }

        @Override
        public void close() {
            CallingSubProcessUtils.releaseSemaphore(this.binaryName);
        }
    }
}

