/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.beam.it.cassandra.CassandraResourceManagerException;
import org.apache.beam.it.cassandra.CassandraResourceManagerUtils;
import org.apache.beam.it.common.ResourceManager;
import org.apache.beam.it.common.utils.ExceptionUtils;
import org.apache.beam.it.testcontainers.TestContainerResourceManager;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class CassandraResourceManager
extends TestContainerResourceManager<GenericContainer<?>>
implements ResourceManager {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CassandraResourceManager.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_CASSANDRA_CONTAINER_NAME = "cassandra";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_CASSANDRA_CONTAINER_TAG = "4.1.0";
    private static final @UnknownKeyFor @NonNull @Initialized int CASSANDRA_INTERNAL_PORT = 9042;
    private final @UnknownKeyFor @NonNull @Initialized CqlSession cassandraClient;
    private final @UnknownKeyFor @NonNull @Initialized String keyspaceName;
    private final @UnknownKeyFor @NonNull @Initialized boolean usingStaticDatabase;

    private CassandraResourceManager(@UnknownKeyFor @NonNull @Initialized Builder builder) {
        this(null, new CassandraContainer(DockerImageName.parse((String)builder.containerImageName).withTag(builder.containerImageTag)), builder);
    }

    @VisibleForTesting
    CassandraResourceManager(@Nullable @UnknownKeyFor @Initialized CqlSession cassandraClient, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CassandraContainer<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> container, @UnknownKeyFor @NonNull @Initialized Builder builder) {
        super(container, (TestContainerResourceManager.Builder)builder);
        this.usingStaticDatabase = builder.keyspaceName != null;
        this.keyspaceName = this.usingStaticDatabase ? builder.keyspaceName : CassandraResourceManagerUtils.generateKeyspaceName(builder.testId);
        CqlSession cqlSession = this.cassandraClient = cassandraClient == null ? (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(this.getHost(), this.getPort(9042)))).withLocalDatacenter("datacenter1")).build() : cassandraClient;
        if (!this.usingStaticDatabase) {
            Failsafe.with(CassandraResourceManager.buildRetryPolicy(), (Policy[])new RetryPolicy[0]).run(() -> this.cassandraClient.execute(String.format("CREATE KEYSPACE IF NOT EXISTS %s WITH replication = {'class':'SimpleStrategy', 'replication_factor':1}", this.keyspaceName)));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder(@UnknownKeyFor @NonNull @Initialized String testId) {
        return new Builder(testId);
    }

    public @UnknownKeyFor @NonNull @Initialized int getPort() {
        return super.getPort(9042);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized String getKeyspaceName() {
        return this.keyspaceName;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized ResultSet executeStatement(@UnknownKeyFor @NonNull @Initialized String statement) {
        LOG.info("Executing statement: {}", (Object)statement);
        try {
            return (ResultSet)Failsafe.with(CassandraResourceManager.buildRetryPolicy(), (Policy[])new RetryPolicy[0]).get(() -> this.cassandraClient.execute((Statement)SimpleStatement.newInstance((String)statement).setKeyspace(this.keyspaceName)));
        }
        catch (Exception e) {
            throw new CassandraResourceManagerException("Error reading collection.", e);
        }
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean insertDocument(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> document) {
        return this.insertDocuments(tableName, (List<Map<String, Object>>)ImmutableList.of(document));
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean insertDocuments(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> documents) throws @UnknownKeyFor @NonNull @Initialized CassandraResourceManagerException {
        LOG.info("Attempting to write {} documents to {}.{}.", new Object[]{documents.size(), this.keyspaceName, tableName});
        try {
            for (Map<String, Object> document : documents) {
                this.executeStatement(this.createInsertStatement(tableName, document));
            }
        }
        catch (Exception e) {
            throw new CassandraResourceManagerException("Error inserting documents.", e);
        }
        LOG.info("Successfully wrote {} documents to {}.{}", new Object[]{documents.size(), this.keyspaceName, tableName});
        return true;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row> readTable(@UnknownKeyFor @NonNull @Initialized String tableName) throws @UnknownKeyFor @NonNull @Initialized CassandraResourceManagerException {
        List documents;
        LOG.info("Reading all documents from {}.{}", (Object)this.keyspaceName, (Object)tableName);
        try {
            ResultSet resultSet = this.executeStatement(String.format("SELECT * FROM %s", tableName));
            documents = resultSet.all();
        }
        catch (Exception e) {
            throw new CassandraResourceManagerException("Error reading table.", e);
        }
        LOG.info("Successfully loaded documents from {}.{}", (Object)this.keyspaceName, (Object)tableName);
        return documents;
    }

    public synchronized void cleanupAll() {
        boolean producedError;
        block6: {
            LOG.info("Attempting to cleanup Cassandra manager.");
            producedError = false;
            if (!this.usingStaticDatabase) {
                try {
                    this.executeStatement(String.format("DROP KEYSPACE IF EXISTS %s", this.keyspaceName));
                }
                catch (Exception e) {
                    LOG.error("Failed to drop Cassandra keyspace {}.", (Object)this.keyspaceName, (Object)e);
                    if (ExceptionUtils.containsType((Throwable)e, DriverTimeoutException.class) || ExceptionUtils.containsMessage((Throwable)e, (String)"does not exist")) break block6;
                    producedError = true;
                }
            }
        }
        try {
            this.cassandraClient.close();
        }
        catch (Exception e) {
            LOG.error("Failed to delete Cassandra client.", (Throwable)e);
            producedError = true;
        }
        if (producedError) {
            throw new CassandraResourceManagerException("Failed to delete resources. Check above for errors.");
        }
        super.cleanupAll();
        LOG.info("Cassandra manager successfully cleaned up.");
    }

    private @UnknownKeyFor @NonNull @Initialized String createInsertStatement(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            columns.append(entry.getKey()).append(", ");
            if (entry.getValue() instanceof String) {
                values.append("'").append(entry.getValue()).append("'");
            } else {
                values.append(entry.getValue());
            }
            values.append(", ");
        }
        if (!map.isEmpty()) {
            columns.delete(columns.length() - 2, columns.length());
            values.delete(values.length() - 2, values.length());
        }
        return String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, columns, values);
    }

    private static @UnknownKeyFor @NonNull @Initialized RetryPolicy<@UnknownKeyFor @NonNull @Initialized Object> buildRetryPolicy() {
        return ((RetryPolicyBuilder)RetryPolicy.builder().withMaxRetries(5).withDelay(Duration.ofSeconds(1L)).handle(DriverTimeoutException.class)).build();
    }

    public static final class Builder
    extends TestContainerResourceManager.Builder<CassandraResourceManager> {
        private @Nullable @UnknownKeyFor @Initialized String keyspaceName = null;

        private Builder(@UnknownKeyFor @NonNull @Initialized String testId) {
            super(testId, CassandraResourceManager.DEFAULT_CASSANDRA_CONTAINER_NAME, CassandraResourceManager.DEFAULT_CASSANDRA_CONTAINER_TAG);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setKeyspaceName(@UnknownKeyFor @NonNull @Initialized String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized CassandraResourceManager build() {
            return new CassandraResourceManager(this);
        }
    }
}

