/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.cassandra;

import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.apache.beam.it.common.utils.ResourceManagerUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class CassandraResourceManagerUtils {
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_DATABASE_NAME_LENGTH = 63;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern ILLEGAL_DATABASE_NAME_CHARS = Pattern.compile("[/\\\\. \"\u0000$]");
    private static final @UnknownKeyFor @NonNull @Initialized String REPLACE_DATABASE_NAME_CHAR = "-";
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSSSSS");

    private CassandraResourceManagerUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized String generateKeyspaceName(@UnknownKeyFor @NonNull @Initialized String baseString) {
        return ResourceManagerUtils.generateResourceId((String)baseString, (Pattern)ILLEGAL_DATABASE_NAME_CHARS, (String)REPLACE_DATABASE_NAME_CHAR, (int)63, (DateTimeFormatter)TIME_FORMAT).replace('-', '_');
    }
}

