/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.cassandra.matchers;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.it.truthmatchers.PipelineAsserts;
import org.apache.beam.it.truthmatchers.RecordsSubject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CassandraAsserts {
    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> cassandraRowsToRecords(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row> rows) {
        try {
            ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
            for (Row row : rows) {
                HashMap<String, String> converted = new HashMap<String, String>();
                for (ColumnDefinition columnDefinition : row.getColumnDefinitions()) {
                    Object value = null;
                    if (columnDefinition.getType().equals(DataTypes.TEXT)) {
                        value = row.getString(columnDefinition.getName());
                    } else if (columnDefinition.getType().equals(DataTypes.INT)) {
                        value = row.getInt(columnDefinition.getName());
                    }
                    converted.put(columnDefinition.getName().toString(), (String)value);
                }
                records.add(converted);
            }
            return records;
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting Cassandra Rows to Records", e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized RecordsSubject assertThatCassandraRecords(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row> rows) {
        return PipelineAsserts.assertThatRecords(CassandraAsserts.cassandraRowsToRecords(rows));
    }
}

