/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.it.jdbc.JDBCDriverFactory;
import org.apache.beam.it.jdbc.JDBCResourceManager;
import org.apache.beam.it.jdbc.JDBCResourceManagerException;
import org.apache.beam.it.jdbc.JDBCResourceManagerUtils;
import org.apache.beam.it.testcontainers.TestContainerResourceManager;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.math.NumberUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;

public abstract class AbstractJDBCResourceManager<@UnknownKeyFor T/*
 * Issues handling annotations - annotations may be inaccurate
 */
 extends @UnknownKeyFor @NonNull @Initialized JdbcDatabaseContainer<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
extends TestContainerResourceManager<JdbcDatabaseContainer<?>>
implements JDBCResourceManager {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(AbstractJDBCResourceManager.class);
    protected static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_JDBC_USERNAME = "root";
    protected final @UnknownKeyFor @NonNull @Initialized JDBCDriverFactory driver;
    protected final @UnknownKeyFor @NonNull @Initialized String databaseName;
    protected final @UnknownKeyFor @NonNull @Initialized String username;
    protected final @UnknownKeyFor @NonNull @Initialized String password;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tableIds;

    @VisibleForTesting
    AbstractJDBCResourceManager(T container, @UnknownKeyFor @NonNull @Initialized Builder<T> builder, @UnknownKeyFor @NonNull @Initialized JDBCDriverFactory driver) {
        super((GenericContainer)container.withUsername(builder.username).withPassword(builder.password).withDatabaseName(builder.databaseName), builder);
        this.databaseName = container.getDatabaseName();
        this.username = container.getUsername();
        this.password = container.getPassword();
        this.tableIds = new HashMap<String, String>();
        this.driver = driver;
    }

    protected AbstractJDBCResourceManager(T container, @UnknownKeyFor @NonNull @Initialized Builder<T> builder) {
        this(container, builder, new JDBCDriverFactory());
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized int getJDBCPort();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getUsername() {
        return this.username;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPassword() {
        return this.password;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPort() {
        return this.getPort(this.getJDBCPort());
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized String getUri() {
        return String.format("jdbc:%s://%s:%d/%s", this.getJDBCPrefix(), this.getHost(), this.getPort(), this.getDatabaseName());
    }

    public abstract @UnknownKeyFor @NonNull @Initialized String getJDBCPrefix();

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean createTable(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized JDBCResourceManager.JDBCSchema schema) {
        JDBCResourceManagerUtils.checkValidTableName(tableName);
        if (this.tableIds.containsKey(tableName)) {
            throw new IllegalStateException("Table " + tableName + " already exists for database " + this.databaseName + ".");
        }
        LOG.info("Creating table using tableName '{}'.", (Object)tableName);
        StringBuilder sql = new StringBuilder();
        try (Connection con = this.driver.getConnection(this.getUri(), this.username, this.password);){
            Statement stmt = con.createStatement();
            sql.append("CREATE TABLE ").append(tableName).append(" (").append(schema.toSqlStatement()).append(")");
            stmt.executeUpdate(sql.toString());
            stmt.close();
        }
        catch (Exception e) {
            throw new JDBCResourceManagerException("Error creating table with SQL statement: " + sql + " (for connection with URL " + this.getUri() + ")", e);
        }
        this.tableIds.put(tableName, schema.getIdColumn());
        LOG.info("Successfully created table {}.{}", (Object)this.databaseName, (Object)tableName);
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean write(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> rows) throws @UnknownKeyFor @NonNull @Initialized JDBCResourceManagerException {
        if (rows.size() == 0) {
            return false;
        }
        LOG.info("Attempting to write {} rows to {}.{}.", new Object[]{rows.size(), this.databaseName, tableName});
        try (Connection con = this.driver.getConnection(this.getUri(), this.username, this.password);){
            Statement stmt = con.createStatement();
            for (Map<String, Object> row : rows) {
                ArrayList<String> columns = new ArrayList<String>(row.keySet());
                StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append("(").append(String.join((CharSequence)",", columns)).append(") VALUES (");
                ArrayList<String> valueList = new ArrayList<String>();
                for (String colName : columns) {
                    Object value = row.get(colName);
                    if (value == null) {
                        valueList.add(null);
                        continue;
                    }
                    if (NumberUtils.isCreatable((String)value.toString()) || "true".equalsIgnoreCase(value.toString()) || "false".equalsIgnoreCase(value.toString()) || value.toString().startsWith("ARRAY[")) {
                        valueList.add(String.valueOf(value));
                        continue;
                    }
                    valueList.add("'" + value + "'");
                }
                sql.append(String.join((CharSequence)",", valueList)).append(")");
                try {
                    LOG.info("Running SQL statement: " + sql);
                    stmt.executeUpdate(sql.toString());
                }
                catch (SQLException e) {
                    throw new JDBCResourceManagerException("Failed to insert values into table with SQL statement: " + sql, e);
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw new JDBCResourceManagerException(String.format("Exception occurred when trying to write records to %s.", tableName), e);
        }
        LOG.info("Successfully wrote {} rows to {}.{}.", new Object[]{rows.size(), this.databaseName, tableName});
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> readTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        LOG.info("Reading all rows from {}.{}", (Object)this.databaseName, (Object)tableName);
        List<Map<String, Object>> result = this.runSQLQuery(String.format("SELECT * FROM %s", tableName));
        LOG.info("Successfully loaded rows from {}.{}", (Object)this.databaseName, (Object)tableName);
        return result;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getTableSchema(@UnknownKeyFor @NonNull @Initialized String tableName) {
        ArrayList<String> arrayList;
        block9: {
            String sql = "";
            Connection con = this.driver.getConnection(this.getUri(), this.username, this.password);
            try {
                Statement stmt = con.createStatement();
                sql = this.getFirstRow(tableName);
                ResultSet result = stmt.executeQuery(sql);
                ResultSetMetaData metadata = result.getMetaData();
                ArrayList<String> columnNames = new ArrayList<String>();
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    columnNames.add(metadata.getColumnName(i));
                }
                result.close();
                stmt.close();
                arrayList = columnNames;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JDBCResourceManagerException("Failed to fetch table schema. SQL statement: " + sql, e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    protected @UnknownKeyFor @NonNull @Initialized String getFirstRow(@UnknownKeyFor @NonNull @Initialized String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 1";
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> runSQLQuery(@UnknownKeyFor @NonNull @Initialized String sql) {
        ArrayList<Map<String, Object>> arrayList;
        block10: {
            Statement stmt = this.driver.getConnection(this.getUri(), this.username, this.password).createStatement();
            try {
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                ResultSet resultSet = stmt.executeQuery(sql);
                while (resultSet.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        row.put(metadata.getColumnName(i), resultSet.getObject(i));
                    }
                    result.add(row);
                }
                arrayList = result;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JDBCResourceManagerException("Failed to execute SQL statement: " + sql, e);
                }
            }
            stmt.close();
        }
        return arrayList;
    }

    @Override
    public synchronized void runSQLUpdate(@UnknownKeyFor @NonNull @Initialized String sql) {
        try (Statement stmt = this.driver.getConnection(this.getUri(), this.username, this.password).createStatement();){
            stmt.executeUpdate(sql);
        }
        catch (Exception e) {
            throw new JDBCResourceManagerException("Failed to execute SQL statement: " + sql, e);
        }
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized long getRowCount(@UnknownKeyFor @NonNull @Initialized String tableName) {
        long l;
        block8: {
            Connection con = this.driver.getConnection(this.getUri(), this.username, this.password);
            try {
                Statement stmt = con.createStatement();
                ResultSet resultSet = stmt.executeQuery(String.format("SELECT count(*) FROM %s", tableName));
                resultSet.next();
                long rows = resultSet.getLong(1);
                resultSet.close();
                stmt.close();
                l = rows;
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JDBCResourceManagerException("Failed to get row count from " + tableName, e);
                }
            }
            con.close();
        }
        return l;
    }

    public static abstract class Builder<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized JdbcDatabaseContainer<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
    extends TestContainerResourceManager.Builder<AbstractJDBCResourceManager<T>> {
        protected @UnknownKeyFor @NonNull @Initialized String databaseName;
        protected @UnknownKeyFor @NonNull @Initialized String username = "root";
        protected @UnknownKeyFor @NonNull @Initialized String password = JDBCResourceManagerUtils.generateJdbcPassword();

        public Builder(@UnknownKeyFor @NonNull @Initialized String testId, @UnknownKeyFor @NonNull @Initialized String containerImageName, @UnknownKeyFor @NonNull @Initialized String containerImageTag) {
            super(testId, containerImageName, containerImageTag);
            this.databaseName = JDBCResourceManagerUtils.generateDatabaseName(testId);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setDatabaseName(@UnknownKeyFor @NonNull @Initialized String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            this.username = username;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            this.password = password;
            return this;
        }
    }
}

