/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.jdbc;

import java.util.List;
import java.util.Map;
import org.apache.beam.it.common.ResourceManager;
import org.apache.beam.it.jdbc.JDBCResourceManagerException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface JDBCResourceManager
extends ResourceManager {
    public @UnknownKeyFor @NonNull @Initialized String getUri();

    public @UnknownKeyFor @NonNull @Initialized String getUsername();

    public @UnknownKeyFor @NonNull @Initialized String getPassword();

    public @UnknownKeyFor @NonNull @Initialized String getDatabaseName();

    public @UnknownKeyFor @NonNull @Initialized boolean createTable(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized JDBCSchema var2) throws @UnknownKeyFor @NonNull @Initialized JDBCResourceManagerException;

    public @UnknownKeyFor @NonNull @Initialized boolean write(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> var2) throws @UnknownKeyFor @NonNull @Initialized JDBCResourceManagerException;

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> readTable(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getTableSchema(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> runSQLQuery(@UnknownKeyFor @NonNull @Initialized String var1);

    public void runSQLUpdate(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized long getRowCount(@UnknownKeyFor @NonNull @Initialized String var1);

    public static class JDBCSchema {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> columns;
        private final @UnknownKeyFor @NonNull @Initialized String idColumn;

        public JDBCSchema(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> columns, @UnknownKeyFor @NonNull @Initialized String idColumn) {
            Preconditions.checkArgument((columns.get(idColumn) != null ? 1 : 0) != 0, (Object)String.format("%s must be one of the columns passed in the columns map.", idColumn));
            this.columns = columns;
            this.idColumn = idColumn;
        }

        public @UnknownKeyFor @NonNull @Initialized String getIdColumn() {
            return this.idColumn;
        }

        public @UnknownKeyFor @NonNull @Initialized String toSqlStatement() {
            StringBuilder sql = new StringBuilder(this.idColumn + " " + this.columns.get(this.idColumn));
            if (!this.columns.get(this.idColumn).toUpperCase().contains(" NOT NULL")) {
                sql.append(" NOT NULL");
            }
            for (Map.Entry<String, String> entry : this.columns.entrySet()) {
                if (entry.getKey().contains(this.idColumn)) continue;
                sql.append(", ");
                sql.append(entry.getKey()).append(" ").append(entry.getValue().toUpperCase());
            }
            sql.append(", PRIMARY KEY ( ").append(this.idColumn).append(" )");
            return sql.toString();
        }
    }
}

